/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.AbstractSQLTemplatesTest;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.DerbyTemplates;
import com.querydsl.sql.SQLOps;
import com.querydsl.sql.SQLSerializer;
import com.querydsl.sql.SQLTemplates;
import org.junit.Assert;
import org.junit.Test;

public class DerbyTemplatesTest
extends AbstractSQLTemplatesTest {
    @Override
    protected SQLTemplates createTemplates() {
        return new DerbyTemplates();
    }

    @Test
    public void nextVal() {
        Operation nextval = ExpressionUtils.operation(String.class, (Operator)SQLOps.NEXTVAL, (Expression[])new Expression[]{ConstantImpl.create((Object)"myseq")});
        Assert.assertEquals((Object)"next value for myseq", (Object)((SQLSerializer)new SQLSerializer(new Configuration((SQLTemplates)new DerbyTemplates())).handle((Expression)nextval)).toString());
    }

    @Test
    public void precedence() {
        int p1 = this.getPrecedence(new Operator[]{Ops.NEGATE});
        int p2 = this.getPrecedence(new Operator[]{Ops.MULT, Ops.DIV});
        int p3 = this.getPrecedence(new Operator[]{Ops.ADD, Ops.SUB});
        int p4 = this.getPrecedence(new Operator[]{Ops.EQ, Ops.NE, Ops.LT, Ops.GT, Ops.LOE, Ops.GOE, Ops.EXISTS, Ops.IN, Ops.IS_NULL, Ops.LIKE, Ops.BETWEEN, Ops.IS_NOT_NULL});
        int p5 = this.getPrecedence(new Operator[]{Ops.NOT});
        int p6 = this.getPrecedence(new Operator[]{Ops.AND});
        int p7 = this.getPrecedence(new Operator[]{Ops.OR});
        Assert.assertTrue((p1 < p2 ? 1 : 0) != 0);
        Assert.assertTrue((p2 < p3 ? 1 : 0) != 0);
        Assert.assertTrue((p3 < p4 ? 1 : 0) != 0);
        Assert.assertTrue((p4 < p5 ? 1 : 0) != 0);
        Assert.assertTrue((p5 < p6 ? 1 : 0) != 0);
        Assert.assertTrue((p6 < p7 ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void booleanTemplate() {
        this.assertSerialized((Expression<?>)Expressions.booleanPath((String)"b").eq((Expression)Expressions.TRUE), "b = true");
        this.assertSerialized((Expression<?>)Expressions.booleanPath((String)"b").eq((Expression)Expressions.FALSE), "b = false");
        this.query.setUseLiterals(true);
        this.query.where((Predicate)Expressions.booleanPath((String)"b").eq(Boolean.valueOf(true)));
        Assert.assertTrue((String)this.query.toString(), (boolean)this.query.toString().endsWith("where b = true"));
    }
}

