/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadataFactory;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.DatePath;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.types.dsl.Wildcard;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.MySQLTemplates;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLSerializer;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.mysql.MySQLQuery;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class ExtendedSQLTest {
    @Test
    public void test() {
        QAuthor author = QAuthor.author;
        QBook book = QBook.book;
        MySQLQuery query = new MySQLQuery(null);
        ((MySQLQuery)((MySQLQuery)((MySQLQuery)((MySQLQuery)((MySQLQuery)((MySQLQuery)((MySQLQuery)((MySQLQuery)((MySQLQuery)query.from((Expression)author)).join((EntityPath)book)).on((Predicate)author.id.eq(book.authorId))).where(new Predicate[]{book.language.eq((Object)"DE"), book.published.eq((Object)new Date())})).groupBy(new Expression[]{author.firstName, author.lastName})).having((Predicate)Wildcard.count.gt((Number)5))).orderBy(author.lastName.asc())).limit(2L)).offset(1L)).forUpdate();
        query.getMetadata().setProjection((Expression)Projections.tuple((Expression[])new Expression[]{author.firstName, author.lastName, Wildcard.count}));
        SQLSerializer serializer = new SQLSerializer(new Configuration((SQLTemplates)new MySQLTemplates()));
        serializer.serialize(query.getMetadata(), false);
        Assert.assertEquals((Object)"select author.FIRST_NAME, author.LAST_NAME, count(*)\nfrom AUTHOR author\njoin BOOK book\non author.ID = book.AUTHOR_ID\nwhere book.LANGUAGE = ? and book.PUBLISHED = ?\ngroup by author.FIRST_NAME, author.LAST_NAME\nhaving count(*) > ?\norder by author.LAST_NAME asc\nlimit ?\noffset ?\nfor update", (Object)serializer.toString());
    }

    public static class QAuthor
    extends RelationalPathBase<QAuthor> {
        private static final long serialVersionUID = -512402580246687292L;
        public static final QAuthor author = new QAuthor("author");
        public final NumberPath<Integer> id = this.createNumber("id", Integer.class);
        public final StringPath firstName = this.createString("firstName");
        public final StringPath lastName = this.createString("lastName");

        public QAuthor(String variable) {
            super(QAuthor.class, PathMetadataFactory.forVariable((String)variable), "", "AUTHOR");
            this.addMetadata();
        }

        protected void addMetadata() {
            this.addMetadata((Path)this.id, ColumnMetadata.named((String)"ID"));
            this.addMetadata((Path)this.firstName, ColumnMetadata.named((String)"FIRST_NAME"));
            this.addMetadata((Path)this.lastName, ColumnMetadata.named((String)"LAST_NAME"));
        }
    }

    public static class QBook
    extends RelationalPathBase<QBook> {
        private static final long serialVersionUID = 4842689279054229095L;
        public static final QBook book = new QBook("book");
        public final NumberPath<Integer> authorId = this.createNumber("authorId", Integer.class);
        public final StringPath language = this.createString("language");
        public final DatePath<Date> published = this.createDate("published", Date.class);

        public QBook(String variable) {
            super(QBook.class, PathMetadataFactory.forVariable((String)variable), "", "BOOK");
            this.addMetadata();
        }

        protected void addMetadata() {
            this.addMetadata((Path)this.authorId, ColumnMetadata.named((String)"AUTHOR_ID"));
            this.addMetadata((Path)this.language, ColumnMetadata.named((String)"LANGUAGE"));
            this.addMetadata((Path)this.published, ColumnMetadata.named((String)"PUBLISHED"));
        }
    }
}

