/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.sql.AbstractSQLTemplatesTest;
import com.querydsl.sql.FirebirdTemplates;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.Union;
import org.junit.Assert;
import org.junit.Test;

public class FirebirdTemplatesTest
extends AbstractSQLTemplatesTest {
    @Override
    protected SQLTemplates createTemplates() {
        return new FirebirdTemplates();
    }

    @Override
    public void arithmetic() {
    }

    @Override
    @Test
    public void union() {
        NumberExpression one = Expressions.ONE;
        NumberExpression two = Expressions.TWO;
        NumberExpression three = Expressions.THREE;
        NumberPath col1 = Expressions.numberPath(Integer.class, (String)"col1");
        Union union = this.query.union(new SubQueryExpression[]{SQLExpressions.select((Expression)one.as((Path)col1)), SQLExpressions.select((Expression)two), SQLExpressions.select((Expression)three)});
        Assert.assertEquals((Object)"select 1 as col1 from RDB$DATABASE\nunion\nselect 2 from RDB$DATABASE\nunion\nselect 3 from RDB$DATABASE", (Object)union.toString());
    }

    @Test
    public void precedence() {
        int p1 = this.getPrecedence(new Operator[]{Ops.CONCAT});
        int p2 = this.getPrecedence(new Operator[]{Ops.NEGATE});
        int p3 = this.getPrecedence(new Operator[]{Ops.MULT, Ops.DIV});
        int p4 = this.getPrecedence(new Operator[]{Ops.SUB, Ops.ADD});
        int p5 = this.getPrecedence(new Operator[]{Ops.EQ, Ops.GOE, Ops.GT, Ops.LT, Ops.NE, Ops.IS_NULL, Ops.IS_NOT_NULL, Ops.MATCHES, Ops.IN, Ops.LIKE, Ops.LIKE_ESCAPE, Ops.BETWEEN});
        int p6 = this.getPrecedence(new Operator[]{Ops.NOT});
        int p7 = this.getPrecedence(new Operator[]{Ops.AND});
        int p8 = this.getPrecedence(new Operator[]{Ops.XOR, Ops.XNOR});
        int p9 = this.getPrecedence(new Operator[]{Ops.OR});
        Assert.assertTrue((p1 < p2 ? 1 : 0) != 0);
        Assert.assertTrue((p2 < p3 ? 1 : 0) != 0);
        Assert.assertTrue((p3 < p4 ? 1 : 0) != 0);
        Assert.assertTrue((p4 < p5 ? 1 : 0) != 0);
        Assert.assertTrue((p5 < p6 ? 1 : 0) != 0);
        Assert.assertTrue((p6 < p7 ? 1 : 0) != 0);
        Assert.assertTrue((p7 < p8 ? 1 : 0) != 0);
        Assert.assertTrue((p8 < p9 ? 1 : 0) != 0);
    }
}

