/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.QueryException;
import com.querydsl.core.QueryFlag;
import com.querydsl.core.Target;
import com.querydsl.core.Tuple;
import com.querydsl.core.testutil.ExcludeIn;
import com.querydsl.core.testutil.IncludeIn;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.Param;
import com.querydsl.sql.AbstractBaseTest;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.Constants;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLBaseListener;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLListener;
import com.querydsl.sql.SQLListenerContext;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SkipForQuoted;
import com.querydsl.sql.TestLoggingListener;
import com.querydsl.sql.dml.DefaultMapper;
import com.querydsl.sql.dml.Mapper;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.domain.Employee;
import com.querydsl.sql.domain.QDateTest;
import com.querydsl.sql.domain.QEmployee;
import com.querydsl.sql.domain.QSurvey;
import com.querydsl.sql.domain.QUuids;
import com.querydsl.sql.domain.QXmlTest;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class InsertBase
extends AbstractBaseTest {
    private void reset() throws SQLException {
        this.delete((RelationalPath<?>)Constants.survey).execute();
        ((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).values(new Object[]{1, "Hello World", "Hello"})).execute();
        this.delete((RelationalPath<?>)QDateTest.qDateTest).execute();
    }

    @Before
    public void setUp() throws SQLException {
        this.reset();
    }

    @After
    public void tearDown() throws SQLException {
        this.reset();
    }

    @Test
    @ExcludeIn(value={Target.CUBRID, Target.SQLITE})
    public void insert_dates() {
        QDateTest dateTest = QDateTest.qDateTest;
        LocalDate localDate = new LocalDate(1978, 1, 2);
        Path localDateProperty = ExpressionUtils.path(LocalDate.class, (String)"DATE_TEST");
        Path dateTimeProperty = ExpressionUtils.path(DateTime.class, (String)"DATE_TEST");
        SQLInsertClause insert = this.insert((RelationalPath<?>)dateTest);
        insert.set(localDateProperty, (Object)localDate);
        insert.execute();
        Tuple result = (Tuple)((SQLQuery)this.query().from((Expression)dateTest)).select(new Expression[]{dateTest.dateTest.year(), dateTest.dateTest.month(), dateTest.dateTest.dayOfMonth(), dateTimeProperty}).fetchFirst();
        Assert.assertEquals((Object)1978, (Object)result.get(0, Integer.class));
        Assert.assertEquals((Object)1, (Object)result.get(1, Integer.class));
        Assert.assertEquals((Object)2, (Object)result.get(2, Integer.class));
        DateTime dateTime = (DateTime)result.get((Expression)dateTimeProperty);
        if (this.target == Target.CUBRID) {
            dateTime = dateTime.withMillisOfSecond(0);
        }
        Assert.assertEquals((Object)localDate.toDateTimeAtStartOfDay(), (Object)dateTime);
    }

    @Test
    public void complex1() {
        QSurvey survey = new QSurvey("survey");
        QEmployee emp1 = new QEmployee("emp1");
        QEmployee emp2 = new QEmployee("emp2");
        SQLInsertClause insert = this.insert((RelationalPath<?>)survey);
        insert.columns(new Path[]{survey.id, survey.name});
        insert.select((SubQueryExpression)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select((Expression[])new Expression[]{survey.id, emp2.firstname}).from((Expression)survey)).innerJoin((EntityPath)emp1)).on((Predicate)survey.id.eq(emp1.id))).innerJoin((EntityPath)emp2)).on(new Predicate[]{emp1.superiorId.eq(emp2.superiorId), emp1.firstname.eq((Expression)emp2.firstname)}));
        Assert.assertEquals((long)0L, (long)insert.execute());
    }

    @Test
    public void insert_alternative_syntax() {
        Assert.assertEquals((long)1L, (long)((SQLInsertClause)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).set(Constants.survey.id, (Object)3)).set((Path)Constants.survey.name, (Object)"Hello")).execute());
    }

    @Test
    public void insert_batch() {
        SQLInsertClause insert = (SQLInsertClause)((SQLInsertClause)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).set(Constants.survey.id, (Object)5)).set((Path)Constants.survey.name, (Object)"55")).addBatch();
        Assert.assertEquals((long)1L, (long)insert.getBatchCount());
        ((SQLInsertClause)((SQLInsertClause)insert.set(Constants.survey.id, (Object)6)).set((Path)Constants.survey.name, (Object)"66")).addBatch();
        Assert.assertEquals((long)2L, (long)insert.getBatchCount());
        Assert.assertEquals((long)2L, (long)insert.execute());
        Assert.assertEquals((long)1L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.eq((Object)"55"))).fetchCount());
        Assert.assertEquals((long)1L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.eq((Object)"66"))).fetchCount());
    }

    @Test
    public void insert_batch_to_bulk() {
        SQLInsertClause insert = this.insert((RelationalPath<?>)Constants.survey);
        insert.setBatchToBulk(true);
        ((SQLInsertClause)((SQLInsertClause)insert.set(Constants.survey.id, (Object)5)).set((Path)Constants.survey.name, (Object)"55")).addBatch();
        Assert.assertEquals((long)1L, (long)insert.getBatchCount());
        ((SQLInsertClause)((SQLInsertClause)insert.set(Constants.survey.id, (Object)6)).set((Path)Constants.survey.name, (Object)"66")).addBatch();
        Assert.assertEquals((long)2L, (long)insert.getBatchCount());
        Assert.assertEquals((long)2L, (long)insert.execute());
        Assert.assertEquals((long)1L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.eq((Object)"55"))).fetchCount());
        Assert.assertEquals((long)1L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.eq((Object)"66"))).fetchCount());
    }

    @Test
    public void insert_batch_Templates() {
        SQLInsertClause insert = (SQLInsertClause)((SQLInsertClause)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).set(Constants.survey.id, (Object)5)).set((Path)Constants.survey.name, (Expression)Expressions.stringTemplate((String)"'55'", (Object[])new Object[0]))).addBatch();
        ((SQLInsertClause)((SQLInsertClause)insert.set(Constants.survey.id, (Object)6)).set((Path)Constants.survey.name, (Expression)Expressions.stringTemplate((String)"'66'", (Object[])new Object[0]))).addBatch();
        Assert.assertEquals((long)2L, (long)insert.execute());
        Assert.assertEquals((long)1L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.eq((Object)"55"))).fetchCount());
        Assert.assertEquals((long)1L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.eq((Object)"66"))).fetchCount());
    }

    @Test
    public void insert_batch2() {
        SQLInsertClause insert = (SQLInsertClause)((SQLInsertClause)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).set(Constants.survey.id, (Object)5)).set((Path)Constants.survey.name, (Object)"55")).addBatch();
        ((SQLInsertClause)((SQLInsertClause)insert.set(Constants.survey.id, (Object)6)).setNull((Path)Constants.survey.name)).addBatch();
        Assert.assertEquals((long)2L, (long)insert.execute());
    }

    @Test
    public void insert_null_with_columns() {
        Assert.assertEquals((long)1L, (long)((SQLInsertClause)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).columns(new Path[]{Constants.survey.id, Constants.survey.name})).values(new Object[]{3, null})).execute());
    }

    @Test
    @ExcludeIn(value={Target.DB2, Target.DERBY})
    public void insert_null_without_columns() {
        Assert.assertEquals((long)1L, (long)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).values(new Object[]{4, null, null})).execute());
    }

    @Test
    @ExcludeIn(value={Target.FIREBIRD, Target.HSQLDB, Target.DB2, Target.DERBY, Target.ORACLE})
    public void insert_without_values() {
        Assert.assertEquals((long)1L, (long)this.insert((RelationalPath<?>)Constants.survey).execute());
    }

    @Test
    @ExcludeIn(value={Target.ORACLE})
    public void insert_nulls_in_batch() {
        SQLInsertClause sic = this.insert((RelationalPath<?>)Constants.survey);
        ((SQLInsertClause)((SQLInsertClause)sic.columns(new Path[]{Constants.survey.name, Constants.survey.name2})).values(new Object[]{null, null})).addBatch();
        ((SQLInsertClause)((SQLInsertClause)sic.columns(new Path[]{Constants.survey.name, Constants.survey.name2})).values(new Object[]{null, "X"})).addBatch();
        Assert.assertEquals((long)2L, (long)sic.execute());
    }

    @Test
    @Ignore
    @ExcludeIn(value={Target.DERBY})
    public void insert_nulls_in_batch2() {
        DefaultMapper mapper = DefaultMapper.WITH_NULL_BINDINGS;
        QEmployee employee = QEmployee.employee;
        SQLInsertClause sic = this.insert((RelationalPath<?>)employee);
        Employee e = new Employee();
        ((SQLInsertClause)sic.populate((Object)e, (Mapper)mapper)).addBatch();
        e = new Employee();
        e.setFirstname("X");
        ((SQLInsertClause)sic.populate((Object)e, (Mapper)mapper)).addBatch();
        Assert.assertEquals((long)0L, (long)sic.execute());
    }

    @Test
    public void insert_with_columns() {
        Assert.assertEquals((long)1L, (long)((SQLInsertClause)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).columns(new Path[]{Constants.survey.id, Constants.survey.name})).values(new Object[]{3, "Hello"})).execute());
    }

    @Test
    @ExcludeIn(value={Target.CUBRID, Target.SQLSERVER})
    public void insert_with_keys() throws SQLException {
        ResultSet rs = ((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).set((Path)Constants.survey.name, (Object)"Hello World")).executeWithKeys();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((rs.getObject(1) != null ? 1 : 0) != 0);
        rs.close();
    }

    @Test
    @ExcludeIn(value={Target.CUBRID, Target.SQLSERVER})
    public void insert_with_keys_listener() throws SQLException {
        final AtomicBoolean result = new AtomicBoolean();
        SQLBaseListener listener = new SQLBaseListener(){

            public void end(SQLListenerContext context) {
                result.set(true);
            }
        };
        SQLInsertClause clause = (SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).set((Path)Constants.survey.name, (Object)"Hello World");
        clause.addListener((SQLListener)listener);
        ResultSet rs = clause.executeWithKeys();
        Assert.assertFalse((boolean)result.get());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((rs.getObject(1) != null ? 1 : 0) != 0);
        rs.close();
        Assert.assertTrue((boolean)result.get());
    }

    @Test
    @ExcludeIn(value={Target.CUBRID, Target.SQLSERVER})
    public void insert_with_keys_Projected() throws SQLException {
        Assert.assertNotNull((Object)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).set((Path)Constants.survey.name, (Object)"Hello you")).executeWithKey(Constants.survey.id));
    }

    @Test
    @ExcludeIn(value={Target.CUBRID, Target.SQLSERVER})
    public void insert_with_keys_Projected2() throws SQLException {
        Path idPath = ExpressionUtils.path(Object.class, (String)"id");
        Object id = ((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).set((Path)Constants.survey.name, (Object)"Hello you")).executeWithKey(idPath);
        Assert.assertNotNull((Object)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=QueryException.class)
    @IncludeIn(value={Target.DERBY, Target.HSQLDB})
    public void insert_with_keys_OverriddenColumn() throws SQLException {
        String originalColumnName = ColumnMetadata.getName(Constants.survey.id);
        try {
            this.configuration.registerColumnOverride(Constants.survey.getSchemaName(), Constants.survey.getTableName(), originalColumnName, "wrongColumnName");
            SQLInsertClause sqlInsertClause = new SQLInsertClause(this.connection, this.configuration, (RelationalPath)Constants.survey);
            sqlInsertClause.addListener((SQLListener)new TestLoggingListener());
            Object id = ((SQLInsertClause)sqlInsertClause.set((Path)Constants.survey.name, (Object)"Hello you")).executeWithKey(Constants.survey.id);
            Assert.assertNotNull((Object)id);
        }
        finally {
            this.configuration.registerColumnOverride(Constants.survey.getSchemaName(), Constants.survey.getTableName(), originalColumnName, originalColumnName);
        }
    }

    @Test
    public void insert_with_set() {
        Assert.assertEquals((long)1L, (long)((SQLInsertClause)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).set(Constants.survey.id, (Object)5)).set((Path)Constants.survey.name, (Object)null)).execute());
    }

    @Test
    @IncludeIn(value={Target.MYSQL})
    @SkipForQuoted
    public void insert_with_special_options() {
        SQLInsertClause clause = (SQLInsertClause)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).columns(new Path[]{Constants.survey.id, Constants.survey.name})).values(new Object[]{3, "Hello"});
        clause.addFlag(QueryFlag.Position.START_OVERRIDE, "insert ignore into ");
        Assert.assertEquals((Object)"insert ignore into SURVEY (ID, NAME) values (?, ?)", (Object)clause.toString());
        Assert.assertEquals((long)1L, (long)clause.execute());
    }

    @Test
    @ExcludeIn(value={Target.FIREBIRD})
    public void insert_with_subQuery() {
        int count = (int)((SQLQuery)this.query().from((Expression)Constants.survey)).fetchCount();
        Assert.assertEquals((long)count, (long)((SQLInsertClause)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).columns(new Path[]{Constants.survey.id, Constants.survey.name})).select((SubQueryExpression)((SQLQuery)this.query().from((Expression)Constants.survey2)).select(new Expression[]{Constants.survey2.id.add((Number)20), Constants.survey2.name}))).execute());
    }

    @Test
    @ExcludeIn(value={Target.DB2, Target.HSQLDB, Target.CUBRID, Target.DERBY, Target.FIREBIRD})
    public void insert_with_subQuery2() {
        Assert.assertEquals((long)1L, (long)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).set((Path)Constants.survey.name, (Object)((String)((SQLQuery)this.query().where((Predicate)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey2)).where((Predicate)Constants.survey2.name.eq((Object)"MyModule"))).notExists())).select(Expressions.constant((Object)"MyModule")).fetchFirst()))).execute());
        Assert.assertEquals((long)1L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.eq((Object)"MyModule"))).fetchCount());
    }

    @Test
    @ExcludeIn(value={Target.HSQLDB, Target.CUBRID, Target.DERBY})
    public void insert_with_subQuery3() {
        Assert.assertEquals((long)1L, (long)((SQLInsertClause)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).columns(new Path[]{Constants.survey.name})).select((SubQueryExpression)((SQLQuery)this.query().where((Predicate)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey2)).where((Predicate)Constants.survey2.name.eq((Object)"MyModule2"))).notExists())).select(Expressions.constant((Object)"MyModule2")))).execute());
        Assert.assertEquals((long)1L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.eq((Object)"MyModule2"))).fetchCount());
    }

    @Test
    @ExcludeIn(value={Target.FIREBIRD})
    public void insert_with_subQuery_Params() {
        Param param = new Param(Integer.class, "param");
        SQLQuery sq = (SQLQuery)this.query().from((Expression)Constants.survey2);
        sq.set((ParamExpression)param, (Object)20);
        int count = (int)((SQLQuery)this.query().from((Expression)Constants.survey)).fetchCount();
        Assert.assertEquals((long)count, (long)((SQLInsertClause)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).columns(new Path[]{Constants.survey.id, Constants.survey.name})).select((SubQueryExpression)sq.select(new Expression[]{Constants.survey2.id.add((Expression)param), Constants.survey2.name}))).execute());
    }

    @Test
    @ExcludeIn(value={Target.FIREBIRD})
    public void insert_with_subQuery_Via_Constructor() {
        int count = (int)((SQLQuery)this.query().from((Expression)Constants.survey)).fetchCount();
        SQLInsertClause insert = this.insert((RelationalPath<?>)Constants.survey, (SQLQuery<?>)((SQLQuery)this.query().from((Expression)Constants.survey2)));
        insert.set(Constants.survey.id, (Expression)Constants.survey2.id.add((Number)20));
        insert.set((Path)Constants.survey.name, (Expression)Constants.survey2.name);
        Assert.assertEquals((long)count, (long)insert.execute());
    }

    @Test
    @ExcludeIn(value={Target.FIREBIRD})
    public void insert_with_subQuery_Without_Columns() {
        int count = (int)((SQLQuery)this.query().from((Expression)Constants.survey)).fetchCount();
        Assert.assertEquals((long)count, (long)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).select((SubQueryExpression)((SQLQuery)this.query().from((Expression)Constants.survey2)).select(new Expression[]{Constants.survey2.id.add((Number)10), Constants.survey2.name, Constants.survey2.name2}))).execute());
    }

    @Test
    @ExcludeIn(value={Target.FIREBIRD})
    public void insert_without_columns() {
        Assert.assertEquals((long)1L, (long)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).values(new Object[]{4, "Hello", "World"})).execute());
    }

    @Test
    @ExcludeIn(value={Target.FIREBIRD})
    public void insertBatch_with_subquery() {
        SQLInsertClause insert = (SQLInsertClause)((SQLInsertClause)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).columns(new Path[]{Constants.survey.id, Constants.survey.name})).select((SubQueryExpression)((SQLQuery)this.query().from((Expression)Constants.survey2)).select(new Expression[]{Constants.survey2.id.add((Number)20), Constants.survey2.name}))).addBatch();
        ((SQLInsertClause)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).columns(new Path[]{Constants.survey.id, Constants.survey.name})).select((SubQueryExpression)((SQLQuery)this.query().from((Expression)Constants.survey2)).select(new Expression[]{Constants.survey2.id.add((Number)40), Constants.survey2.name}))).addBatch();
        Assert.assertEquals((long)1L, (long)insert.execute());
    }

    @Test
    public void like() {
        ((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).values(new Object[]{11, "Hello World", "a\\b"})).execute();
        Assert.assertEquals((long)1L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name2.contains("a\\b"))).fetchCount());
    }

    @Test
    public void like_with_escape() {
        SQLInsertClause insert = this.insert((RelationalPath<?>)Constants.survey);
        ((SQLInsertClause)((SQLInsertClause)insert.set(Constants.survey.id, (Object)5)).set((Path)Constants.survey.name, (Object)"aaa")).addBatch();
        ((SQLInsertClause)((SQLInsertClause)insert.set(Constants.survey.id, (Object)6)).set((Path)Constants.survey.name, (Object)"a_")).addBatch();
        ((SQLInsertClause)((SQLInsertClause)insert.set(Constants.survey.id, (Object)7)).set((Path)Constants.survey.name, (Object)"a%")).addBatch();
        Assert.assertEquals((long)3L, (long)insert.execute());
        Assert.assertEquals((long)1L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.like("a|%", '|'))).fetchCount());
        Assert.assertEquals((long)1L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.like("a|_", '|'))).fetchCount());
        Assert.assertEquals((long)3L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.like("a%"))).fetchCount());
        Assert.assertEquals((long)2L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.like("a_"))).fetchCount());
        Assert.assertEquals((long)1L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.startsWith("a_"))).fetchCount());
        Assert.assertEquals((long)1L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.startsWith("a%"))).fetchCount());
    }

    @Test
    @IncludeIn(value={Target.MYSQL})
    @SkipForQuoted
    public void replace() {
        SQLInsertClause clause = this.mysqlReplace((RelationalPath<?>)Constants.survey);
        ((SQLInsertClause)clause.columns(new Path[]{Constants.survey.id, Constants.survey.name})).values(new Object[]{3, "Hello"});
        Assert.assertEquals((Object)"replace into SURVEY (ID, NAME) values (?, ?)", (Object)clause.toString());
        clause.execute();
    }

    @Test
    public void insert_with_tempateExpression_in_batch() {
        Assert.assertEquals((long)1L, (long)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).set(Constants.survey.id, (Object)3)).set((Path)Constants.survey.name, (Expression)Expressions.stringTemplate((String)"'Hello'", (Object[])new Object[0]))).addBatch()).execute());
    }

    @Test
    @IncludeIn(value={Target.H2, Target.POSTGRESQL})
    @SkipForQuoted
    public void uuids() {
        this.delete((RelationalPath<?>)QUuids.uuids).execute();
        QUuids uuids = QUuids.uuids;
        UUID uuid = UUID.randomUUID();
        ((SQLInsertClause)this.insert((RelationalPath<?>)uuids).set(uuids.field, (Object)uuid)).execute();
        Assert.assertEquals((Object)uuid, (Object)((SQLQuery)this.query().from((Expression)uuids)).select(uuids.field).fetchFirst());
    }

    @Test
    @ExcludeIn(value={Target.ORACLE})
    public void xml() {
        this.delete((RelationalPath<?>)QXmlTest.xmlTest).execute();
        QXmlTest xmlTest = QXmlTest.xmlTest;
        String contents = "<html><head>a</head><body>b</body></html>";
        ((SQLInsertClause)this.insert((RelationalPath<?>)xmlTest).set((Path)xmlTest.col, (Object)contents)).execute();
        Assert.assertEquals((Object)contents, (Object)((SQLQuery)this.query().from((Expression)xmlTest)).select((Expression)xmlTest.col).fetchFirst());
    }
}

