/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.testutil.ReportingOnly;
import com.querydsl.sql.JDBCTypeMapping;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public class JDBCTypeMappingTest {
    private JDBCTypeMapping typeMapping = new JDBCTypeMapping();

    @Test
    public void get() {
        Assert.assertEquals(Float.class, (Object)this.typeMapping.get(6, 0, 0));
        Assert.assertEquals(Float.class, (Object)this.typeMapping.get(7, 0, 0));
    }

    @Test
    public void stringTypes() {
        Assert.assertEquals(String.class, (Object)this.typeMapping.get(1, 0, 0));
        Assert.assertEquals(String.class, (Object)this.typeMapping.get(-15, 0, 0));
        Assert.assertEquals(String.class, (Object)this.typeMapping.get(2005, 0, 0));
        Assert.assertEquals(String.class, (Object)this.typeMapping.get(2011, 0, 0));
        Assert.assertEquals(String.class, (Object)this.typeMapping.get(-1, 0, 0));
        Assert.assertEquals(String.class, (Object)this.typeMapping.get(-16, 0, 0));
        Assert.assertEquals(String.class, (Object)this.typeMapping.get(2009, 0, 0));
        Assert.assertEquals(String.class, (Object)this.typeMapping.get(12, 0, 0));
        Assert.assertEquals(String.class, (Object)this.typeMapping.get(-9, 0, 0));
    }

    @Test
    public void blobTypes() {
        Assert.assertEquals(Blob.class, (Object)this.typeMapping.get(2004, 0, 0));
    }

    @Test
    public void bytesTypes() {
        Assert.assertEquals(byte[].class, (Object)this.typeMapping.get(-2, 0, 0));
        Assert.assertEquals(byte[].class, (Object)this.typeMapping.get(-3, 0, 0));
        Assert.assertEquals(byte[].class, (Object)this.typeMapping.get(-4, 0, 0));
    }

    @Test
    public void numericTypes() {
        Assert.assertEquals((Object)this.typeMapping.get(2, 20, 0), BigInteger.class);
        Assert.assertEquals((Object)this.typeMapping.get(2, 19, 0), BigInteger.class);
        Assert.assertEquals((Object)this.typeMapping.get(2, 15, 0), Long.class);
        Assert.assertEquals((Object)this.typeMapping.get(2, 6, 0), Integer.class);
        Assert.assertEquals((Object)this.typeMapping.get(2, 5, 0), Integer.class);
        Assert.assertEquals((Object)this.typeMapping.get(2, 4, 0), Short.class);
        Assert.assertEquals((Object)this.typeMapping.get(2, 3, 0), Short.class);
        Assert.assertEquals((Object)this.typeMapping.get(2, 2, 0), Byte.class);
        Assert.assertEquals((Object)this.typeMapping.get(2, 1, 0), Byte.class);
        Assert.assertEquals((Object)this.typeMapping.get(2, 0, 0), BigInteger.class);
        Assert.assertEquals((Object)this.typeMapping.get(2, 17, 2), BigDecimal.class);
        Assert.assertEquals((Object)this.typeMapping.get(2, 5, 2), BigDecimal.class);
    }

    @Test
    @Category(value={ReportingOnly.class})
    public void max() {
        System.err.println("Byte: " + String.valueOf(127).length());
        System.err.println("Short: " + String.valueOf(Short.MAX_VALUE).length());
        System.err.println("Integer: " + String.valueOf(Integer.MAX_VALUE).length());
        System.err.println("Long: " + String.valueOf(Long.MAX_VALUE).length());
    }

    @Test
    public void numericOverriden() {
        this.typeMapping.registerNumeric(19, 0, BigInteger.class);
        Assert.assertEquals((Object)this.typeMapping.get(2, 19, 0), BigInteger.class);
    }

    @Test
    public void numericOverriden2() {
        this.typeMapping.registerNumeric(19, 0, BigInteger.class);
        Assert.assertEquals((Object)this.typeMapping.get(4, 19, 0), BigInteger.class);
        Assert.assertEquals((Object)this.typeMapping.get(4, 18, 0), Integer.class);
    }

    @Test
    public void numericOverriden3() {
        this.typeMapping.registerNumeric(5, 2, BigDecimal.class);
        Assert.assertEquals((Object)this.typeMapping.get(8, 5, 2), BigDecimal.class);
        Assert.assertEquals((Object)this.typeMapping.get(8, 5, 1), Double.class);
    }
}

