/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.sql.DummyBlob;
import com.querydsl.sql.JavaTypeMapping;
import com.querydsl.sql.types.BlobType;
import com.querydsl.sql.types.BooleanType;
import com.querydsl.sql.types.ByteType;
import com.querydsl.sql.types.CharacterType;
import com.querydsl.sql.types.DoubleType;
import com.querydsl.sql.types.FloatType;
import com.querydsl.sql.types.InputStreamType;
import com.querydsl.sql.types.IntegerType;
import com.querydsl.sql.types.LongType;
import com.querydsl.sql.types.ObjectType;
import com.querydsl.sql.types.ShortType;
import com.querydsl.sql.types.Type;
import java.io.FileInputStream;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;

public class JavaTypeMappingTest {
    private JavaTypeMapping typeMapping = new JavaTypeMapping();

    @Test
    public void getType_with_subtypes() {
        this.typeMapping.register((Type)new InputStreamType());
        Assert.assertNotNull((Object)this.typeMapping.getType(InputStream.class));
        Assert.assertNotNull((Object)this.typeMapping.getType(FileInputStream.class));
    }

    @Test
    public void getType_with_interfaces() {
        Assert.assertEquals(BlobType.class, this.typeMapping.getType(DummyBlob.class).getClass());
    }

    @Test
    public void getType_for_object() {
        Assert.assertEquals(ObjectType.class, this.typeMapping.getType(Object.class).getClass());
    }

    @Test
    public void getType_for_primitive() {
        Assert.assertEquals(ByteType.class, this.typeMapping.getType(Byte.TYPE).getClass());
        Assert.assertEquals(ShortType.class, this.typeMapping.getType(Short.TYPE).getClass());
        Assert.assertEquals(IntegerType.class, this.typeMapping.getType(Integer.TYPE).getClass());
        Assert.assertEquals(LongType.class, this.typeMapping.getType(Long.TYPE).getClass());
        Assert.assertEquals(FloatType.class, this.typeMapping.getType(Float.TYPE).getClass());
        Assert.assertEquals(DoubleType.class, this.typeMapping.getType(Double.TYPE).getClass());
        Assert.assertEquals(BooleanType.class, this.typeMapping.getType(Boolean.TYPE).getClass());
        Assert.assertEquals(CharacterType.class, this.typeMapping.getType(Character.TYPE).getClass());
    }
}

