/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.JoinFlag;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.domain.QSurvey;
import java.sql.Connection;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JoinFlagsTest {
    private Connection connection = (Connection)EasyMock.createMock(Connection.class);
    private QSurvey s1;
    private QSurvey s2;
    private QSurvey s3;
    private QSurvey s4;
    private QSurvey s5;
    private QSurvey s6;
    private SQLQuery query;

    @Before
    public void setUp() {
        this.s1 = new QSurvey("s");
        this.s2 = new QSurvey("s2");
        this.s3 = new QSurvey("s3");
        this.s4 = new QSurvey("s4");
        this.s5 = new QSurvey("s5");
        this.s6 = new QSurvey("s6");
        this.query = new SQLQuery(this.connection, SQLTemplates.DEFAULT);
        this.query.from((Expression)this.s1);
    }

    @Test
    public void joinFlags_beforeCondition() {
        this.query.innerJoin((EntityPath)this.s2).on((Predicate)this.s1.eq((Object)this.s2));
        this.query.addJoinFlag(" a ", JoinFlag.Position.BEFORE_CONDITION);
        Assert.assertEquals((Object)"from SURVEY s\ninner join SURVEY s2 a \non s.ID = s2.ID", (Object)this.query.toString());
    }

    @Test
    public void joinFlags_beforeTarget() {
        this.query.innerJoin((EntityPath)this.s3).on((Predicate)this.s1.eq((Object)this.s3));
        this.query.addJoinFlag(" b ", JoinFlag.Position.BEFORE_TARGET);
        Assert.assertEquals((Object)"from SURVEY s\ninner join  b SURVEY s3\non s.ID = s3.ID", (Object)this.query.toString());
    }

    @Test
    public void joinFlags_end() {
        this.query.innerJoin((EntityPath)this.s4).on((Predicate)this.s1.eq((Object)this.s4));
        this.query.addJoinFlag(" c ", JoinFlag.Position.END);
        Assert.assertEquals((Object)"from SURVEY s\ninner join SURVEY s4\non s.ID = s4.ID c", (Object)this.query.toString());
    }

    @Test
    public void joinFlags_override() {
        this.query.innerJoin((EntityPath)this.s5).on((Predicate)this.s1.eq((Object)this.s5));
        this.query.addJoinFlag(" d ", JoinFlag.Position.OVERRIDE);
        Assert.assertEquals((Object)"from SURVEY s d SURVEY s5\non s.ID = s5.ID", (Object)this.query.toString());
    }

    @Test
    public void joinFlags_start() {
        this.query.innerJoin((EntityPath)this.s6).on((Predicate)this.s1.eq((Object)this.s6));
        this.query.addJoinFlag(" e ", JoinFlag.Position.START);
        Assert.assertEquals((Object)"from SURVEY s e \ninner join SURVEY s6\non s.ID = s6.ID", (Object)this.query.toString());
    }
}

