/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.AbstractBaseTest;
import com.querydsl.sql.Constants;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.sql.SQLException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LikeEscapeBase
extends AbstractBaseTest {
    @Before
    public void setUp() throws SQLException {
        this.delete((RelationalPath<?>)Constants.survey).execute();
        SQLInsertClause insert = this.insert((RelationalPath<?>)Constants.survey);
        ((SQLInsertClause)((SQLInsertClause)insert.set(Constants.survey.id, (Object)5)).set((Path)Constants.survey.name, (Object)"aaa")).addBatch();
        ((SQLInsertClause)((SQLInsertClause)insert.set(Constants.survey.id, (Object)6)).set((Path)Constants.survey.name, (Object)"a_")).addBatch();
        ((SQLInsertClause)((SQLInsertClause)insert.set(Constants.survey.id, (Object)7)).set((Path)Constants.survey.name, (Object)"a%")).addBatch();
        insert.execute();
    }

    @After
    public void tearDown() throws SQLException {
        this.delete((RelationalPath<?>)Constants.survey).execute();
        ((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).values(new Object[]{1, "Hello World", "Hello"})).execute();
    }

    @Test
    public void like() {
        Assert.assertEquals((long)0L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.like("a!%"))).fetchCount());
        Assert.assertEquals((long)0L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.like("a!_"))).fetchCount());
        Assert.assertEquals((long)3L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.like("a%"))).fetchCount());
        Assert.assertEquals((long)2L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.like("a_"))).fetchCount());
        Assert.assertEquals((long)1L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.startsWith("a_"))).fetchCount());
        Assert.assertEquals((long)1L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.startsWith("a%"))).fetchCount());
    }

    @Test
    public void like_with_escape() {
        Assert.assertEquals((long)1L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.like("a!%", '!'))).fetchCount());
        Assert.assertEquals((long)1L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.like("a!_", '!'))).fetchCount());
        Assert.assertEquals((long)3L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.like("a%", '!'))).fetchCount());
        Assert.assertEquals((long)2L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.like("a_", '!'))).fetchCount());
    }

    @Test
    public void like_escaping_conclusion() {
        Assert.assertTrue((String)"Escaped like construct must return more results", (((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.like("a!%"))).fetchCount() < ((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.like("a!%", '!'))).fetchCount() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Escaped like construct must return more results", (((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.like("a!_"))).fetchCount() < ((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.like("a!_", '!'))).fetchCount() ? 1 : 0) != 0);
    }
}

