/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.Target;
import com.querydsl.core.testutil.ExcludeIn;
import com.querydsl.core.testutil.IncludeIn;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.AbstractBaseTest;
import com.querydsl.sql.AbstractSQLQuery;
import com.querydsl.sql.Constants;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLBaseListener;
import com.querydsl.sql.SQLListener;
import com.querydsl.sql.SQLListenerContext;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLMergeClause;
import com.querydsl.sql.domain.QSurvey;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MergeBase
extends AbstractBaseTest {
    private void reset() throws SQLException {
        this.delete((RelationalPath<?>)Constants.survey).execute();
        ((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).values(new Object[]{1, "Hello World", "Hello"})).execute();
    }

    @Before
    public void setUp() throws SQLException {
        this.reset();
    }

    @After
    public void tearDown() throws SQLException {
        this.reset();
    }

    @Test
    @ExcludeIn(value={Target.H2, Target.CUBRID, Target.SQLSERVER})
    public void merge_with_keys() throws SQLException {
        ResultSet rs = this.merge((RelationalPath<?>)Constants.survey).keys(new Path[]{Constants.survey.id}).set(Constants.survey.id, (Object)7).set((Path)Constants.survey.name, (Object)"Hello World").executeWithKeys();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((rs.getObject(1) != null ? 1 : 0) != 0);
        rs.close();
    }

    @Test
    @ExcludeIn(value={Target.H2, Target.CUBRID, Target.SQLSERVER})
    public void merge_with_keys_listener() throws SQLException {
        final AtomicBoolean result = new AtomicBoolean();
        SQLBaseListener listener = new SQLBaseListener(){

            public void end(SQLListenerContext context) {
                result.set(true);
            }
        };
        SQLMergeClause clause = this.merge((RelationalPath<?>)Constants.survey).keys(new Path[]{Constants.survey.id}).set(Constants.survey.id, (Object)7).set((Path)Constants.survey.name, (Object)"Hello World");
        clause.addListener((SQLListener)listener);
        ResultSet rs = clause.executeWithKeys();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((rs.getObject(1) != null ? 1 : 0) != 0);
        rs.close();
        Assert.assertTrue((boolean)result.get());
    }

    @Test
    @IncludeIn(value={Target.H2})
    public void merge_with_keys_and_subQuery() {
        Assert.assertEquals((long)1L, (long)((SQLInsertClause)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).set(Constants.survey.id, (Object)6)).set((Path)Constants.survey.name, (Object)"H")).execute());
        QSurvey survey2 = new QSurvey("survey2");
        Assert.assertEquals((long)2L, (long)this.merge((RelationalPath<?>)Constants.survey).keys(new Path[]{Constants.survey.id}).select((SubQueryExpression)((SQLQuery)this.query().from((Expression)survey2)).select(new Expression[]{survey2.id.add((Number)1), survey2.name, survey2.name2})).execute());
    }

    @Test
    @IncludeIn(value={Target.H2})
    public void merge_with_keys_and_values() {
        Assert.assertEquals((long)1L, (long)this.merge((RelationalPath<?>)Constants.survey).keys(new Path[]{Constants.survey.id}).values(new Object[]{5, "Hello World", "Hello"}).execute());
    }

    @Test
    public void merge_with_keys_columns_and_values() {
        Assert.assertEquals((long)1L, (long)this.merge((RelationalPath<?>)Constants.survey).keys(new Path[]{Constants.survey.id}).set(Constants.survey.id, (Object)5).set((Path)Constants.survey.name, (Object)"Hello World").execute());
    }

    @Test
    public void merge_with_keys_columns_and_values_using_null() {
        Assert.assertEquals((long)1L, (long)this.merge((RelationalPath<?>)Constants.survey).keys(new Path[]{Constants.survey.id}).set(Constants.survey.id, (Object)5).set((Path)Constants.survey.name, (Object)null).execute());
    }

    @Test
    @ExcludeIn(value={Target.CUBRID, Target.DB2, Target.DERBY, Target.POSTGRESQL, Target.SQLSERVER, Target.TERADATA})
    public void merge_with_keys_Null_Id() throws SQLException {
        ResultSet rs = this.merge((RelationalPath<?>)Constants.survey).keys(new Path[]{Constants.survey.id}).setNull(Constants.survey.id).set((Path)Constants.survey.name, (Object)"Hello World").executeWithKeys();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((rs.getObject(1) != null ? 1 : 0) != 0);
        rs.close();
    }

    @Test
    @ExcludeIn(value={Target.H2, Target.CUBRID, Target.SQLSERVER})
    public void merge_with_keys_Projected() throws SQLException {
        Assert.assertNotNull((Object)this.merge((RelationalPath<?>)Constants.survey).keys(new Path[]{Constants.survey.id}).set(Constants.survey.id, (Object)8).set((Path)Constants.survey.name, (Object)"Hello you").executeWithKey(Constants.survey.id));
    }

    @Test
    @ExcludeIn(value={Target.H2, Target.CUBRID, Target.SQLSERVER})
    public void merge_with_keys_Projected2() throws SQLException {
        Path idPath = ExpressionUtils.path(Object.class, (String)"id");
        Object id = this.merge((RelationalPath<?>)Constants.survey).keys(new Path[]{Constants.survey.id}).set(Constants.survey.id, (Object)9).set((Path)Constants.survey.name, (Object)"Hello you").executeWithKey(idPath);
        Assert.assertNotNull((Object)id);
    }

    @Test
    @IncludeIn(value={Target.H2})
    public void mergeBatch() {
        SQLMergeClause merge = this.merge((RelationalPath<?>)Constants.survey).keys(new Path[]{Constants.survey.id}).set(Constants.survey.id, (Object)5).set((Path)Constants.survey.name, (Object)"5").addBatch();
        Assert.assertEquals((long)1L, (long)merge.getBatchCount());
        Assert.assertFalse((boolean)merge.isEmpty());
        merge.keys(new Path[]{Constants.survey.id}).set(Constants.survey.id, (Object)6).set((Path)Constants.survey.name, (Object)"6").addBatch();
        Assert.assertEquals((long)2L, (long)merge.getBatchCount());
        Assert.assertEquals((long)2L, (long)merge.execute());
        Assert.assertEquals((long)1L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.eq((Object)"5"))).fetchCount());
        Assert.assertEquals((long)1L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.eq((Object)"6"))).fetchCount());
    }

    @Test
    @IncludeIn(value={Target.H2})
    public void mergeBatch_templates() {
        SQLMergeClause merge = this.merge((RelationalPath<?>)Constants.survey).keys(new Path[]{Constants.survey.id}).set(Constants.survey.id, (Object)5).set((Path)Constants.survey.name, (Expression)Expressions.stringTemplate((String)"'5'", (Object[])new Object[0])).addBatch();
        merge.keys(new Path[]{Constants.survey.id}).set(Constants.survey.id, (Object)6).set((Path)Constants.survey.name, (Expression)Expressions.stringTemplate((String)"'6'", (Object[])new Object[0])).addBatch();
        Assert.assertEquals((long)2L, (long)merge.execute());
        Assert.assertEquals((long)1L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.eq((Object)"5"))).fetchCount());
        Assert.assertEquals((long)1L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.eq((Object)"6"))).fetchCount());
    }

    @Test
    @IncludeIn(value={Target.H2})
    public void mergeBatch_with_subquery() {
        SQLMergeClause merge = this.merge((RelationalPath<?>)Constants.survey).keys(new Path[]{Constants.survey.id}).columns(new Path[]{Constants.survey.id, Constants.survey.name}).select((SubQueryExpression)((SQLQuery)this.query().from((Expression)Constants.survey2)).select(new Expression[]{Constants.survey2.id.add((Number)20), Constants.survey2.name})).addBatch();
        this.merge((RelationalPath<?>)Constants.survey).keys(new Path[]{Constants.survey.id}).columns(new Path[]{Constants.survey.id, Constants.survey.name}).select((SubQueryExpression)((SQLQuery)this.query().from((Expression)Constants.survey2)).select(new Expression[]{Constants.survey2.id.add((Number)40), Constants.survey2.name})).addBatch();
        Assert.assertEquals((long)1L, (long)merge.execute());
    }

    @Test
    @IncludeIn(value={Target.H2})
    public void merge_with_templateExpression_in_batch() {
        SQLMergeClause merge = this.merge((RelationalPath<?>)Constants.survey).keys(new Path[]{Constants.survey.id}).set(Constants.survey.id, (Object)5).set((Path)Constants.survey.name, (Expression)Expressions.stringTemplate((String)"'5'", (Object[])new Object[0])).addBatch();
        Assert.assertEquals((long)1L, (long)merge.execute());
    }

    @Test
    public void merge_listener() {
        final AtomicInteger calls = new AtomicInteger(0);
        SQLBaseListener listener = new SQLBaseListener(){

            public void end(SQLListenerContext context) {
                if (context.getData(AbstractSQLQuery.PARENT_CONTEXT) == null) {
                    calls.incrementAndGet();
                }
            }
        };
        SQLMergeClause clause = this.merge((RelationalPath<?>)Constants.survey).keys(new Path[]{Constants.survey.id}).set(Constants.survey.id, (Object)5).set((Path)Constants.survey.name, (Object)"Hello World");
        clause.addListener((SQLListener)listener);
        Assert.assertEquals((long)1L, (long)clause.execute());
        Assert.assertEquals((long)1L, (long)calls.intValue());
    }
}

