/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.dsl.DateTimeExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.AbstractSQLTemplatesTest;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.DatePart;
import com.querydsl.sql.MySQLTemplates;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLTemplates;
import org.junit.Assert;
import org.junit.Test;

public class MySQLTemplatesTest
extends AbstractSQLTemplatesTest {
    @Override
    protected SQLTemplates createTemplates() {
        return new MySQLTemplates();
    }

    @Test
    public void test() {
        SQLTemplates templates = MySQLTemplates.builder().printSchema().build();
        Configuration conf = new Configuration(templates);
        System.out.println(new SQLQuery(conf).from((Expression)survey1).toString());
    }

    @Test
    public void order_nullsFirst() {
        ((SQLQuery)this.query.from((Expression)survey1)).orderBy(MySQLTemplatesTest.survey1.name.asc().nullsFirst());
        Assert.assertEquals((Object)"from SURVEY survey1 order by (case when survey1.NAME is null then 0 else 1 end), survey1.NAME asc", (Object)this.query.toString());
    }

    @Test
    public void order_nullsLast() {
        ((SQLQuery)this.query.from((Expression)survey1)).orderBy(MySQLTemplatesTest.survey1.name.asc().nullsLast());
        Assert.assertEquals((Object)"from SURVEY survey1 order by (case when survey1.NAME is null then 1 else 0 end), survey1.NAME asc", (Object)this.query.toString());
    }

    @Test
    public void precedence() {
        int p0 = this.getPrecedence(new Operator[]{Ops.NEGATE});
        int p1 = this.getPrecedence(new Operator[]{Ops.MULT, Ops.DIV, Ops.MOD});
        int p2 = this.getPrecedence(new Operator[]{Ops.SUB, Ops.ADD});
        int p3 = this.getPrecedence(new Operator[]{Ops.EQ, Ops.GOE, Ops.GT, Ops.LT, Ops.NE, Ops.IS_NULL, Ops.IS_NOT_NULL, Ops.MATCHES, Ops.IN, Ops.LIKE, Ops.LIKE_ESCAPE});
        int p4 = this.getPrecedence(new Operator[]{Ops.BETWEEN, Ops.CASE, Ops.CASE_ELSE});
        int p5 = this.getPrecedence(new Operator[]{Ops.NOT});
        int p6 = this.getPrecedence(new Operator[]{Ops.AND});
        int p7 = this.getPrecedence(new Operator[]{Ops.XOR, Ops.XNOR});
        int p8 = this.getPrecedence(new Operator[]{Ops.OR});
        Assert.assertTrue((p0 < p1 ? 1 : 0) != 0);
        Assert.assertTrue((p1 < p2 ? 1 : 0) != 0);
        Assert.assertTrue((p2 < p3 ? 1 : 0) != 0);
        Assert.assertTrue((p3 < p4 ? 1 : 0) != 0);
        Assert.assertTrue((p4 < p5 ? 1 : 0) != 0);
        Assert.assertTrue((p5 < p6 ? 1 : 0) != 0);
        Assert.assertTrue((p6 < p7 ? 1 : 0) != 0);
        Assert.assertTrue((p7 < p8 ? 1 : 0) != 0);
    }

    @Test
    public void truncateWeek() {
        SQLQuery expression = this.query.select((Expression)SQLExpressions.datetrunc((DatePart)DatePart.week, (DateTimeExpression)Expressions.dateTimeTemplate(Comparable.class, (String)"dateExpression", (Object[])new Object[0])));
        Assert.assertEquals((Object)"select str_to_date(concat(date_format(dateExpression,'%Y-%u'),'-1'),'%Y-%u-%w') from dual", (Object)expression.toString());
    }
}

