/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.QueryFlag;
import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.DateTimeExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.SimpleTemplate;
import com.querydsl.sql.AbstractSQLTemplatesTest;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.DatePart;
import com.querydsl.sql.OracleTemplates;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLOps;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLSerializer;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.Union;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class OracleTemplatesTest
extends AbstractSQLTemplatesTest {
    @Override
    protected SQLTemplates createTemplates() {
        return new OracleTemplates();
    }

    @Override
    @Test
    public void union() {
        SimpleTemplate one = Expressions.template(Integer.class, (String)"1", (Object[])new Object[0]);
        SimpleTemplate two = Expressions.template(Integer.class, (String)"2", (Object[])new Object[0]);
        SimpleTemplate three = Expressions.template(Integer.class, (String)"3", (Object[])new Object[0]);
        NumberPath col1 = Expressions.numberPath(Integer.class, (String)"col1");
        Union union = this.query.union(new SubQueryExpression[]{SQLExpressions.select((Expression)one.as((Path)col1)), SQLExpressions.select((Expression)two), SQLExpressions.select((Expression)three)});
        Assert.assertEquals((Object)"(select 1 col1 from dual)\nunion\n(select 2 from dual)\nunion\n(select 3 from dual)", (Object)union.toString());
    }

    @Test
    public void modifiers() {
        ((SQLQuery)((SQLQuery)this.query.from((Expression)survey1)).limit(5L)).offset(3L);
        this.query.getMetadata().setProjection(OracleTemplatesTest.survey1.id);
        Assert.assertEquals((Object)"select * from (  select a.*, rownum rn from (   select survey1.ID from SURVEY survey1  ) a) where rn > 3 and rownum <= 5", (Object)this.query.toString());
    }

    @Test
    public void modifiers2() {
        ((SQLQuery)((SQLQuery)this.query.from((Expression)survey1)).limit(5L)).offset(3L);
        this.query.getMetadata().setProjection(OracleTemplatesTest.survey1.id);
        this.query.getMetadata().addFlag(new QueryFlag(QueryFlag.Position.AFTER_PROJECTION, ", count(*) over() "));
        Assert.assertEquals((Object)"select * from (  select a.*, rownum rn from (   select survey1.ID, count(*) over()  from SURVEY survey1  ) a) where rn > 3 and rownum <= 5", (Object)this.query.toString());
    }

    @Override
    @Test
    public void in() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (int i = 0; i < 2000; ++i) {
            ids.add(i);
        }
        this.query.where((Predicate)OracleTemplatesTest.survey1.id.isNotNull());
        this.query.where((Predicate)OracleTemplatesTest.survey1.id.in(ids));
        Assert.assertTrue((boolean)this.query.toString().startsWith("from dual where survey1.ID is not null and (survey1.ID in "));
    }

    @Test
    public void nextVal() {
        Operation nextval = ExpressionUtils.operation(String.class, (Operator)SQLOps.NEXTVAL, (Expression[])new Expression[]{ConstantImpl.create((Object)"myseq")});
        Assert.assertEquals((Object)"myseq.nextval", (Object)((SQLSerializer)new SQLSerializer(new Configuration((SQLTemplates)new OracleTemplates())).handle((Expression)nextval)).toString());
    }

    @Test
    public void precedence() {
        int p1 = this.getPrecedence(new Operator[]{Ops.NEGATE});
        int p2 = this.getPrecedence(new Operator[]{Ops.MULT, Ops.DIV});
        int p3 = this.getPrecedence(new Operator[]{Ops.ADD, Ops.SUB, Ops.CONCAT});
        int p4 = this.getPrecedence(new Operator[]{Ops.EQ, Ops.NE, Ops.LT, Ops.GT, Ops.LOE, Ops.GOE});
        int p5 = this.getPrecedence(new Operator[]{Ops.IS_NULL, Ops.IS_NOT_NULL, Ops.LIKE, Ops.LIKE_ESCAPE, Ops.BETWEEN, Ops.IN, Ops.NOT_IN, Ops.EXISTS});
        int p6 = this.getPrecedence(new Operator[]{Ops.NOT});
        int p7 = this.getPrecedence(new Operator[]{Ops.AND});
        int p8 = this.getPrecedence(new Operator[]{Ops.OR});
        Assert.assertTrue((p1 < p2 ? 1 : 0) != 0);
        Assert.assertTrue((p2 < p3 ? 1 : 0) != 0);
        Assert.assertTrue((p3 < p4 ? 1 : 0) != 0);
        Assert.assertTrue((p4 < p5 ? 1 : 0) != 0);
        Assert.assertTrue((p5 < p6 ? 1 : 0) != 0);
        Assert.assertTrue((p6 < p7 ? 1 : 0) != 0);
        Assert.assertTrue((p7 < p8 ? 1 : 0) != 0);
    }

    @Test
    public void truncateWeek() {
        SQLQuery expression = this.query.select((Expression)SQLExpressions.datetrunc((DatePart)DatePart.week, (DateTimeExpression)Expressions.dateTimeTemplate(Comparable.class, (String)"dateExpression", (Object[])new Object[0])));
        Assert.assertEquals((Object)"select trunc(dateExpression, 'iw') from dual", (Object)expression.toString());
    }
}

