/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.QueryMetadata;
import com.querydsl.core.QueryModifiers;
import com.querydsl.core.support.QueryMixin;
import com.querydsl.core.testutil.ReportingOnly;
import com.querydsl.core.types.Expression;
import com.querydsl.sql.CUBRIDTemplates;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.DerbyTemplates;
import com.querydsl.sql.H2Templates;
import com.querydsl.sql.HSQLDBTemplates;
import com.querydsl.sql.MySQLTemplates;
import com.querydsl.sql.OracleTemplates;
import com.querydsl.sql.PostgreSQLTemplates;
import com.querydsl.sql.SQLSerializer;
import com.querydsl.sql.SQLServer2005Templates;
import com.querydsl.sql.SQLServer2012Templates;
import com.querydsl.sql.SQLServerTemplates;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.SQLiteTemplates;
import com.querydsl.sql.TeradataTemplates;
import com.querydsl.sql.domain.QEmployee;
import java.util.ArrayList;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReportingOnly.class})
public class PaginationTest {
    private String serialize(QueryMetadata metadata, SQLTemplates templates) {
        SQLSerializer serializer = new SQLSerializer(new Configuration(templates));
        serializer.serialize(metadata, false);
        return serializer.toString();
    }

    @Test
    public void test() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new CUBRIDTemplates());
        list.add(new DerbyTemplates());
        list.add(new H2Templates());
        list.add(new HSQLDBTemplates());
        list.add(new MySQLTemplates());
        list.add(new OracleTemplates());
        list.add(new PostgreSQLTemplates());
        list.add(new SQLiteTemplates());
        list.add(new SQLServerTemplates());
        list.add(new SQLServer2005Templates());
        list.add(new SQLServer2012Templates());
        list.add(new TeradataTemplates());
        for (SQLTemplates sQLTemplates : list) {
            QEmployee employee = QEmployee.employee;
            QueryMixin query = new QueryMixin();
            query.from((Expression)employee);
            query.orderBy(employee.firstname.asc());
            query.setProjection(employee.id);
            System.out.println(sQLTemplates.getClass().getSimpleName());
            System.out.println();
            query.restrict(QueryModifiers.limit((long)10L));
            System.out.println("* limit");
            System.out.println(this.serialize(query.getMetadata(), sQLTemplates));
            System.out.println();
            if (sQLTemplates.getClass().equals(SQLServerTemplates.class)) continue;
            query.restrict(QueryModifiers.offset((long)10L));
            System.out.println("* offset");
            System.out.println(this.serialize(query.getMetadata(), sQLTemplates));
            System.out.println();
            query.restrict(new QueryModifiers(Long.valueOf(10L), Long.valueOf(10L)));
            System.out.println("* limit and offset");
            System.out.println(this.serialize(query.getMetadata(), sQLTemplates));
            System.out.println();
        }
    }
}

