/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.sql.AbstractSQLTemplatesTest;
import com.querydsl.sql.PostgreSQLTemplates;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.Union;
import org.junit.Assert;
import org.junit.Test;

public class PostgreSQLTemplatesTest
extends AbstractSQLTemplatesTest {
    @Override
    protected SQLTemplates createTemplates() {
        return new PostgreSQLTemplates();
    }

    @Override
    @Test
    public void noFrom() {
        this.query.getMetadata().setProjection((Expression)Expressions.ONE);
        Assert.assertEquals((Object)"select 1", (Object)this.query.toString());
    }

    @Override
    @Test
    public void union() {
        NumberExpression one = Expressions.ONE;
        NumberExpression two = Expressions.TWO;
        NumberExpression three = Expressions.THREE;
        SimplePath col1 = Expressions.path(Integer.class, (String)"col1");
        Union union = this.query.union(new SubQueryExpression[]{SQLExpressions.select((Expression)one.as((Path)col1)), SQLExpressions.select((Expression)two), SQLExpressions.select((Expression)three)});
        Assert.assertEquals((Object)"(select 1 as col1)\nunion\n(select 2)\nunion\n(select 3)", (Object)union.toString());
    }

    @Test
    public void precedence() {
        int p0 = this.getPrecedence(new Operator[]{Ops.NEGATE});
        int p1 = this.getPrecedence(new Operator[]{Ops.MULT, Ops.DIV, Ops.MOD});
        int p2 = this.getPrecedence(new Operator[]{Ops.ADD, Ops.SUB});
        int p3 = this.getPrecedence(new Operator[]{Ops.IS_NULL, Ops.IS_NOT_NULL});
        int p4 = this.getPrecedence(new Operator[]{Ops.IN});
        int p5 = this.getPrecedence(new Operator[]{Ops.BETWEEN});
        int p6 = this.getPrecedence(new Operator[]{Ops.LIKE, Ops.LIKE_ESCAPE});
        int p7 = this.getPrecedence(new Operator[]{Ops.LT, Ops.GT});
        int p8 = this.getPrecedence(new Operator[]{Ops.EQ});
        int p9 = this.getPrecedence(new Operator[]{Ops.NOT});
        int p10 = this.getPrecedence(new Operator[]{Ops.AND});
        int p11 = this.getPrecedence(new Operator[]{Ops.OR});
        Assert.assertTrue((p0 < p1 ? 1 : 0) != 0);
        Assert.assertTrue((p1 < p2 ? 1 : 0) != 0);
        Assert.assertTrue((p2 < p3 ? 1 : 0) != 0);
        Assert.assertTrue((p3 < p4 ? 1 : 0) != 0);
        Assert.assertTrue((p4 < p5 ? 1 : 0) != 0);
        Assert.assertTrue((p5 < p6 ? 1 : 0) != 0);
        Assert.assertTrue((p6 < p7 ? 1 : 0) != 0);
        Assert.assertTrue((p7 < p8 ? 1 : 0) != 0);
        Assert.assertTrue((p8 < p9 ? 1 : 0) != 0);
        Assert.assertTrue((p9 < p10 ? 1 : 0) != 0);
        Assert.assertTrue((p10 < p11 ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void booleanTemplate() {
        this.assertSerialized((Expression<?>)Expressions.booleanPath((String)"b").eq((Expression)Expressions.TRUE), "b = true");
        this.assertSerialized((Expression<?>)Expressions.booleanPath((String)"b").eq((Expression)Expressions.FALSE), "b = false");
        this.query.setUseLiterals(true);
        this.query.where((Predicate)Expressions.booleanPath((String)"b").eq(Boolean.valueOf(true)));
        Assert.assertTrue((String)this.query.toString(), (boolean)this.query.toString().endsWith("where b = true"));
    }
}

