/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.sql.domain.Employee;
import com.querydsl.sql.domain.QEmployee;
import org.junit.Assert;
import org.junit.Test;

public class QBeanTest {
    private final QEmployee e = new QEmployee("e");

    @Test
    public void direct_to_managed_type() {
        QBean expr = Projections.bean(Employee.class, (Expression[])new Expression[]{this.e.superiorId});
        Employee e = (Employee)expr.newInstance(new Object[]{3});
        Assert.assertEquals((Object)3, (Object)e.getSuperiorId());
    }

    @Test
    public void direct_to_custom_type() {
        QBean expr = Projections.bean(Employee.class, (Expression[])new Expression[]{this.e.firstname, this.e.lastname});
        Employee e = (Employee)expr.newInstance(new Object[]{"John", "Smith"});
        Assert.assertEquals((Object)"John", (Object)e.getFirstname());
        Assert.assertEquals((Object)"Smith", (Object)e.getLastname());
    }

    @Test
    public void alias_to_managed_type() {
        QBean expr = Projections.bean(Employee.class, (Expression[])new Expression[]{this.e.superiorId.as("id")});
        Employee e = (Employee)expr.newInstance(new Object[]{3});
        Assert.assertEquals((long)3L, (long)e.getId().intValue());
    }

    @Test
    public void alias_to_custom_type() {
        QBean expr = Projections.bean(Employee.class, (Expression[])new Expression[]{this.e.firstname.as("lastname"), this.e.lastname.as("firstname")});
        Employee e = (Employee)expr.newInstance(new Object[]{"John", "Smith"});
        Assert.assertEquals((Object)"Smith", (Object)e.getFirstname());
        Assert.assertEquals((Object)"John", (Object)e.getLastname());
    }
}

