/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.FetchableQuery;
import com.querydsl.core.QueryMutability;
import com.querydsl.core.testutil.Derby;
import com.querydsl.core.types.Expression;
import com.querydsl.sql.Connections;
import com.querydsl.sql.DerbyTemplates;
import com.querydsl.sql.SQLListener;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.TestLoggingListener;
import com.querydsl.sql.domain.QSurvey;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Derby.class})
public class QueryMutabilityTest {
    private static final QSurvey survey = new QSurvey("survey");
    private Connection connection;

    @Before
    public void setUp() throws Exception {
        Connections.initDerby();
        this.connection = Connections.getConnection();
    }

    @After
    public void tearDown() throws SQLException {
        Connections.close();
    }

    @Test
    public void test() throws IOException, SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        SQLQuery query = new SQLQuery(this.connection, (SQLTemplates)DerbyTemplates.DEFAULT);
        query.from((Expression)survey);
        query.addListener((SQLListener)new TestLoggingListener());
        new QueryMutability((FetchableQuery)query).test(QueryMutabilityTest.survey.id, (Expression)QueryMutabilityTest.survey.name);
    }

    @Test
    public void clone_() {
        SQLQuery query = (SQLQuery)new SQLQuery((SQLTemplates)DerbyTemplates.DEFAULT).from((Expression)survey);
        SQLQuery query2 = query.clone(this.connection);
        Assert.assertEquals((Object)query.getMetadata().getJoins(), (Object)query2.getMetadata().getJoins());
        Assert.assertEquals((Object)query.getMetadata().getWhere(), (Object)query2.getMetadata().getWhere());
        query2.select(QueryMutabilityTest.survey.id).fetch();
    }
}

