/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.JoinType;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.testutil.H2;
import com.querydsl.core.testutil.Performance;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.Connections;
import com.querydsl.sql.H2Templates;
import com.querydsl.sql.QCompanies;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLSerializer;
import com.querydsl.sql.SQLTemplates;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;

@Category(value={H2.class, Performance.class})
public class QueryPerformanceTest {
    private static final String QUERY = "select COMPANIES.NAME\nfrom COMPANIES COMPANIES\nwhere COMPANIES.ID = ?";
    private static final SQLTemplates templates = new H2Templates();
    private static final Configuration conf = new Configuration(templates);

    @BeforeClass
    public static void setUpClass() throws SQLException, ClassNotFoundException {
        Connections.initH2();
        Connection conn = Connections.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create or replace table companies (id identity, name varchar(30) unique not null);");
        PreparedStatement pstmt = conn.prepareStatement("insert into companies (name) values (?)");
        int iterations = 1000000;
        for (int i = 0; i < 1000000; ++i) {
            pstmt.setString(1, String.valueOf(i));
            pstmt.execute();
            pstmt.clearParameters();
        }
        pstmt.close();
        stmt.close();
        conn.setAutoCommit(false);
    }

    @AfterClass
    public static void tearDownClass() throws SQLException {
        Connection conn = Connections.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("drop table companies");
        stmt.close();
        Connections.close();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void jDBC() throws Exception {
        try (Connection conn = Connections.getH2();
             PreparedStatement stmt = conn.prepareStatement(QUERY);){
            stmt.setLong(1, ThreadLocalRandom.current().nextLong());
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    rs.getString(1);
                }
            }
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void jDBC2() throws Exception {
        try (Connection conn = Connections.getH2();
             PreparedStatement stmt = conn.prepareStatement(QUERY);){
            stmt.setString(1, String.valueOf(ThreadLocalRandom.current().nextLong()));
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    rs.getString(1);
                }
            }
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void querydsl1() throws Exception {
        try (Connection conn = Connections.getH2();){
            QCompanies companies = QCompanies.companies;
            SQLQuery query = new SQLQuery(conn, conf);
            ((SQLQuery)((SQLQuery)query.from((Expression)companies)).where((Predicate)companies.id.eq((Object)ThreadLocalRandom.current().nextLong()))).select((Expression)companies.name).fetch();
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void querydsl12() throws Exception {
        try (Connection conn = Connections.getH2();){
            QCompanies companies = QCompanies.companies;
            SQLQuery query = new SQLQuery(conn, conf);
            try (CloseableIterator it = ((SQLQuery)((SQLQuery)query.from((Expression)companies)).where((Predicate)companies.id.eq((Object)ThreadLocalRandom.current().nextLong()))).select((Expression)companies.name).iterate();){
                while (it.hasNext()) {
                    it.next();
                }
            }
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void querydsl13() throws Exception {
        try (Connection conn = Connections.getH2();){
            QCompanies companies = QCompanies.companies;
            SQLQuery query = new SQLQuery(conn, conf);
            try (ResultSet rs = ((SQLQuery)((SQLQuery)query.select((Expression)companies.name).from((Expression)companies)).where((Predicate)companies.id.eq((Object)ThreadLocalRandom.current().nextLong()))).getResults();){
                while (rs.next()) {
                    rs.getString(1);
                }
            }
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void querydsl14() throws Exception {
        try (Connection conn = Connections.getH2();){
            QCompanies companies = QCompanies.companies;
            SQLQuery query = new SQLQuery(conn, conf, (QueryMetadata)new DefaultQueryMetadata());
            ((SQLQuery)((SQLQuery)query.from((Expression)companies)).where((Predicate)companies.id.eq((Object)ThreadLocalRandom.current().nextLong()))).select((Expression)companies.name).fetch();
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void querydsl15() throws Exception {
        try (Connection conn = Connections.getH2();){
            QCompanies companies = QCompanies.companies;
            SQLQuery query = new SQLQuery(conn, conf);
            ((SQLQuery)((SQLQuery)query.from((Expression)companies)).where((Predicate)companies.id.eq((Object)ThreadLocalRandom.current().nextLong()))).select(new Expression[]{companies.id, companies.name}).fetch();
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void querydsl2() throws Exception {
        try (Connection conn = Connections.getH2();){
            QCompanies companies = QCompanies.companies;
            SQLQuery query = new SQLQuery(conn, conf);
            ((SQLQuery)((SQLQuery)query.from((Expression)companies)).where((Predicate)companies.name.eq((Object)String.valueOf(ThreadLocalRandom.current().nextLong())))).select((Expression)companies.name).fetch();
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void querydsl22() throws Exception {
        try (Connection conn = Connections.getH2();){
            QCompanies companies = QCompanies.companies;
            SQLQuery query = new SQLQuery(conn, conf);
            try (CloseableIterator it = ((SQLQuery)((SQLQuery)query.from((Expression)companies)).where((Predicate)companies.name.eq((Object)String.valueOf(ThreadLocalRandom.current().nextLong())))).select((Expression)companies.name).iterate();){
                while (it.hasNext()) {
                    it.next();
                }
            }
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void querydsl23() throws Exception {
        try (Connection conn = Connections.getH2();){
            QCompanies companies = QCompanies.companies;
            SQLQuery query = new SQLQuery(conn, conf, (QueryMetadata)new DefaultQueryMetadata());
            ((SQLQuery)((SQLQuery)query.from((Expression)companies)).where((Predicate)companies.name.eq((Object)String.valueOf(ThreadLocalRandom.current().nextLong())))).select((Expression)companies.name).fetch();
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void serialization() throws Exception {
        try (Connection conn = Connections.getH2();){
            QCompanies companies = QCompanies.companies;
            DefaultQueryMetadata md = new DefaultQueryMetadata();
            md.addJoin(JoinType.DEFAULT, (Expression)companies);
            md.addWhere((Predicate)companies.id.eq((Object)1L));
            md.setProjection((Expression)companies.name);
            SQLSerializer serializer = new SQLSerializer(conf);
            serializer.serialize((QueryMetadata)md, false);
            serializer.getConstants();
            serializer.getConstantPaths();
            Assert.assertNotNull((Object)serializer.toString());
        }
    }

    @Test
    public void launchBenchmark() throws Exception {
        Options opt = new OptionsBuilder().include(this.getClass().getName() + ".*").mode(Mode.AverageTime).timeUnit(TimeUnit.MICROSECONDS).warmupTime(TimeValue.seconds((long)1L)).warmupIterations(1).measurementTime(TimeValue.seconds((long)1L)).measurementIterations(3).threads(1).forks(1).shouldFailOnError(true).shouldDoGC(true).build();
        new Runner(opt).run();
    }
}

