/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.sql.RelationalFunctionCall;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.domain.QSurvey;
import org.junit.Assert;
import org.junit.Test;

public class RelationalFunctionCallTest {
    private static Expression[] serializeCollection(String ... tokens) {
        Expression[] rv = new Expression[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            rv[i] = ConstantImpl.create((Object)tokens[i]);
        }
        return rv;
    }

    @Test
    public void validation() {
        QSurvey survey = QSurvey.survey;
        TokenizeFunction func = new TokenizeFunction("func", "a", "b");
        SQLQuery sub = (SQLQuery)((SQLQuery)SQLExpressions.selectOne().from((Expression)func.as((Path)func.alias))).where((Predicate)survey.name.like((Expression)func.token));
        System.out.println(sub);
    }

    @Test
    public void noArgs() {
        RelationalFunctionCall functionCall = SQLExpressions.relationalFunctionCall(String.class, (String)"getElements", (Object[])new Object[0]);
        Assert.assertEquals((Object)"getElements()", (Object)functionCall.getTemplate().toString());
    }

    @Test
    public void twoArgs() {
        StringPath str = Expressions.stringPath((String)"str");
        RelationalFunctionCall functionCall = SQLExpressions.relationalFunctionCall(String.class, (String)"getElements", (Object[])new Object[]{"a", str});
        Assert.assertEquals((Object)"getElements({0}, {1})", (Object)functionCall.getTemplate().toString());
        Assert.assertEquals((Object)"a", (Object)functionCall.getArg(0));
        Assert.assertEquals((Object)str, (Object)functionCall.getArg(1));
    }

    private static class TokenizeFunction
    extends RelationalFunctionCall<String> {
        final PathBuilder<String> alias;
        final StringPath token;

        TokenizeFunction(String alias, String ... tokens) {
            super(String.class, "tokenize", (Object[])RelationalFunctionCallTest.serializeCollection(tokens));
            this.alias = new PathBuilder(String.class, alias);
            this.token = Expressions.stringPath(this.alias, (String)"token");
        }
    }
}

