/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.QueryMetadata;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.sql.Constants;
import com.querydsl.sql.RelationalPathExtractor;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.domain.QEmployee;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class RelationalPathExtractorTest {
    private SQLQuery<?> query() {
        return new SQLQuery();
    }

    @Test
    public void simpleQuery() {
        QEmployee employee2 = new QEmployee("employee2");
        SQLQuery query = (SQLQuery)this.query().from(new Expression[]{Constants.employee, employee2});
        Assert.assertEquals(new HashSet<QEmployee>(Arrays.asList(Constants.employee, employee2)), (Object)RelationalPathExtractor.extract((QueryMetadata)query.getMetadata()));
    }

    @Test
    public void joins() {
        QEmployee employee2 = new QEmployee("employee2");
        SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).innerJoin((EntityPath)employee2)).on((Predicate)Constants.employee.superiorId.eq(employee2.id));
        Assert.assertEquals(new HashSet<QEmployee>(Arrays.asList(Constants.employee, employee2)), (Object)RelationalPathExtractor.extract((QueryMetadata)query.getMetadata()));
    }

    @Test
    public void subQuery() {
        SQLQuery query = (SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.id.eq((Expression)((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.id.max())));
        Assert.assertEquals(Collections.singleton(Constants.employee), (Object)RelationalPathExtractor.extract((QueryMetadata)query.getMetadata()));
    }

    @Test
    public void subQuery2() {
        QEmployee employee2 = new QEmployee("employee2");
        SQLQuery query = (SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Expressions.list((SimpleExpression[])new SimpleExpression[]{Constants.employee.id, Constants.employee.lastname}).in((SubQueryExpression)((SQLQuery)this.query().from((Expression)employee2)).select(new Expression[]{employee2.id, employee2.lastname})));
        Assert.assertEquals(new HashSet<QEmployee>(Arrays.asList(Constants.employee, employee2)), (Object)RelationalPathExtractor.extract((QueryMetadata)query.getMetadata()));
    }
}

