/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Param;
import com.querydsl.sql.SQLBindings;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.domain.QSurvey;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class SQLBindingsTest {
    private QSurvey survey = QSurvey.survey;
    private SQLQuery<?> query = new SQLQuery();

    @Test
    public void empty() {
        SQLBindings bindings = this.query.getSQL();
        Assert.assertEquals((Object)"\nfrom dual", (Object)bindings.getSQL());
        Assert.assertTrue((boolean)bindings.getNullFriendlyBindings().isEmpty());
    }

    @Test
    public void singleArg() {
        ((SQLQuery)((SQLQuery)this.query.from((Expression)this.survey)).where((Predicate)this.survey.name.eq((Object)"Bob"))).select(this.survey.id);
        SQLBindings bindings = this.query.getSQL();
        Assert.assertEquals((Object)"select SURVEY.ID\nfrom SURVEY SURVEY\nwhere SURVEY.NAME = ?", (Object)bindings.getSQL());
        Assert.assertEquals(Collections.singletonList("Bob"), (Object)bindings.getNullFriendlyBindings());
    }

    @Test
    public void twoArgs() {
        ((SQLQuery)((SQLQuery)this.query.from((Expression)this.survey)).where(new Predicate[]{this.survey.name.eq((Object)"Bob"), this.survey.name2.eq((Object)"A")})).select(this.survey.id);
        SQLBindings bindings = this.query.getSQL();
        Assert.assertEquals((Object)"select SURVEY.ID\nfrom SURVEY SURVEY\nwhere SURVEY.NAME = ? and SURVEY.NAME2 = ?", (Object)bindings.getSQL());
        Assert.assertEquals(Arrays.asList("Bob", "A"), (Object)bindings.getNullFriendlyBindings());
    }

    @Test
    public void params() {
        Param name = new Param(String.class, "name");
        ((SQLQuery)((SQLQuery)this.query.from((Expression)this.survey)).where(new Predicate[]{this.survey.name.eq((Expression)name), this.survey.name2.eq((Object)"A")})).select(this.survey.id);
        this.query.set((ParamExpression)name, (Object)"Bob");
        SQLBindings bindings = this.query.getSQL();
        Assert.assertEquals((Object)"select SURVEY.ID\nfrom SURVEY SURVEY\nwhere SURVEY.NAME = ? and SURVEY.NAME2 = ?", (Object)bindings.getSQL());
        Assert.assertEquals(Arrays.asList("Bob", "A"), (Object)bindings.getNullFriendlyBindings());
    }
}

