/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.testutil.H2;
import com.querydsl.core.types.Expression;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.Connections;
import com.querydsl.sql.Constants;
import com.querydsl.sql.H2Templates;
import com.querydsl.sql.SQLCloseListener;
import com.querydsl.sql.SQLListener;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.domain.Employee;
import java.sql.SQLException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={H2.class})
public class SQLCloseListenerTest {
    private SQLQuery<Employee> query;

    @Before
    public void setUp() throws SQLException, ClassNotFoundException {
        Connections.initH2();
        Configuration conf = new Configuration((SQLTemplates)H2Templates.DEFAULT);
        conf.addListener((SQLListener)SQLCloseListener.DEFAULT);
        this.query = (SQLQuery)new SQLQuery(Connections.getConnection(), conf).select((Expression)Constants.employee).from((Expression)Constants.employee);
    }

    @After
    public void tearDown() throws SQLException {
        Connections.close();
    }

    @Test
    public void fetch() {
        Assert.assertFalse((boolean)this.query.fetch().isEmpty());
    }

    @Test
    public void fetchOne() {
        Assert.assertNotNull((Object)((SQLQuery)this.query.limit(1L)).fetchOne());
    }

    @Test
    public void fetchFirst() {
        Assert.assertNotNull((Object)this.query.fetchFirst());
    }

    @Test
    public void fetchResults() {
        Assert.assertNotNull((Object)this.query.fetchResults());
    }

    @Test
    public void iterate() {
        try (CloseableIterator it = this.query.iterate();){
            while (it.hasNext()) {
                it.next();
            }
        }
    }
}

