/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLDetailedListener;
import com.querydsl.sql.SQLListener;
import com.querydsl.sql.SQLListenerContext;
import com.querydsl.sql.SQLListenerContextImpl;
import com.querydsl.sql.SQLListeners;
import com.querydsl.sql.dml.SQLInsertBatch;
import com.querydsl.sql.dml.SQLMergeBatch;
import com.querydsl.sql.dml.SQLUpdateBatch;
import java.util.List;
import java.util.Map;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class SQLListenersTest {
    @Test
    public void notifyQuery() {
        SQLListener listener = (SQLListener)EasyMock.createMock(SQLListener.class);
        SQLListeners listeners = new SQLListeners();
        listeners.add(listener);
        DefaultQueryMetadata md = new DefaultQueryMetadata();
        listener.notifyQuery((QueryMetadata)md);
        EasyMock.replay((Object[])new Object[]{listener});
        listeners.notifyQuery((QueryMetadata)md);
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void notifyQuery_parent() {
        SQLListener listener = (SQLListener)EasyMock.createMock(SQLListener.class);
        SQLListeners listeners = new SQLListeners(listener);
        DefaultQueryMetadata md = new DefaultQueryMetadata();
        listener.notifyQuery((QueryMetadata)md);
        EasyMock.replay((Object[])new Object[]{listener});
        listeners.notifyQuery((QueryMetadata)md);
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void notifyQuery_detailedListener_start() {
        SQLListenerContext sqlListenerContext = (SQLListenerContext)EasyMock.createMock(SQLListenerContext.class);
        SQLDetailedListener listenerParent = (SQLDetailedListener)EasyMock.createMock(SQLDetailedListener.class);
        SQLDetailedListener listener1 = (SQLDetailedListener)EasyMock.createMock(SQLDetailedListener.class);
        SQLDetailedListener listener2 = (SQLDetailedListener)EasyMock.createMock(SQLDetailedListener.class);
        listenerParent.start(sqlListenerContext);
        EasyMock.replay((Object[])new Object[]{listenerParent});
        listener1.start(sqlListenerContext);
        EasyMock.replay((Object[])new Object[]{listener1});
        listener2.start(sqlListenerContext);
        EasyMock.replay((Object[])new Object[]{listener2});
        SQLListeners listeners = new SQLListeners((SQLListener)listenerParent);
        listeners.add((SQLListener)listener1);
        listeners.add((SQLListener)listener2);
        listeners.start(sqlListenerContext);
        EasyMock.verify((Object[])new Object[]{listenerParent});
        EasyMock.verify((Object[])new Object[]{listener1});
        EasyMock.verify((Object[])new Object[]{listener2});
    }

    @Test
    public void notifyQuery_detailedListener_contexSetting() {
        SQLListenerContextImpl sqlListenerContext = new SQLListenerContextImpl((QueryMetadata)new DefaultQueryMetadata());
        AssertingDetailedListener listenerParent = new AssertingDetailedListener("keyParent", "valueParent");
        AssertingDetailedListener listener1 = new AssertingDetailedListener("key1", "value1");
        AssertingDetailedListener listener2 = new AssertingDetailedListener("key1", "value1");
        SQLListeners listeners = new SQLListeners((SQLListener)listenerParent);
        listeners.add((SQLListener)listener1);
        listeners.add((SQLListener)listener2);
        listeners.start((SQLListenerContext)sqlListenerContext);
        listeners.preRender((SQLListenerContext)sqlListenerContext);
        listeners.rendered((SQLListenerContext)sqlListenerContext);
        listeners.prePrepare((SQLListenerContext)sqlListenerContext);
        listeners.prepared((SQLListenerContext)sqlListenerContext);
        listeners.preExecute((SQLListenerContext)sqlListenerContext);
        listeners.preExecute((SQLListenerContext)sqlListenerContext);
    }

    static class AssertingDetailedListener
    implements SQLDetailedListener {
        private final String key;
        private final Object value;

        AssertingDetailedListener(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public void start(SQLListenerContext context) {
            context.setData(this.key, this.value);
        }

        public void preRender(SQLListenerContext context) {
            Assert.assertThat((Object)this.value, (Matcher)CoreMatchers.equalTo((Object)context.getData(this.key)));
        }

        public void rendered(SQLListenerContext context) {
            Assert.assertThat((Object)this.value, (Matcher)CoreMatchers.equalTo((Object)context.getData(this.key)));
        }

        public void prePrepare(SQLListenerContext context) {
            Assert.assertThat((Object)this.value, (Matcher)CoreMatchers.equalTo((Object)context.getData(this.key)));
        }

        public void prepared(SQLListenerContext context) {
            Assert.assertThat((Object)this.value, (Matcher)CoreMatchers.equalTo((Object)context.getData(this.key)));
        }

        public void preExecute(SQLListenerContext context) {
            Assert.assertThat((Object)this.value, (Matcher)CoreMatchers.equalTo((Object)context.getData(this.key)));
        }

        public void executed(SQLListenerContext context) {
            Assert.assertThat((Object)this.value, (Matcher)CoreMatchers.equalTo((Object)context.getData(this.key)));
        }

        public void exception(SQLListenerContext context) {
            Assert.assertThat((Object)this.value, (Matcher)CoreMatchers.equalTo((Object)context.getData(this.key)));
        }

        public void end(SQLListenerContext context) {
            Assert.assertThat((Object)this.value, (Matcher)CoreMatchers.equalTo((Object)context.getData(this.key)));
        }

        public void notifyQuery(QueryMetadata md) {
        }

        public void notifyDelete(RelationalPath<?> entity, QueryMetadata md) {
        }

        public void notifyDeletes(RelationalPath<?> entity, List<QueryMetadata> batches) {
        }

        public void notifyMerge(RelationalPath<?> entity, QueryMetadata md, List<Path<?>> keys, List<Path<?>> columns, List<Expression<?>> values, SubQueryExpression<?> subQuery) {
        }

        public void notifyMerges(RelationalPath<?> entity, QueryMetadata md, List<SQLMergeBatch> batches) {
        }

        public void notifyInsert(RelationalPath<?> entity, QueryMetadata md, List<Path<?>> columns, List<Expression<?>> values, SubQueryExpression<?> subQuery) {
        }

        public void notifyInserts(RelationalPath<?> entity, QueryMetadata md, List<SQLInsertBatch> batches) {
        }

        public void notifyUpdate(RelationalPath<?> entity, QueryMetadata md, Map<Path<?>, Expression<?>> updates) {
        }

        public void notifyUpdates(RelationalPath<?> entity, List<SQLUpdateBatch> batches) {
        }
    }
}

