/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.types.dsl.Wildcard;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.DatePart;
import com.querydsl.sql.DerbyTemplates;
import com.querydsl.sql.Keywords;
import com.querydsl.sql.MySQLTemplates;
import com.querydsl.sql.PostgreSQLTemplates;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLSerializer;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.Survey;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.domain.QEmployee;
import com.querydsl.sql.domain.QEmployeeNoPK;
import com.querydsl.sql.domain.QSurvey;
import java.sql.Connection;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.TimeZone;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class SQLSerializerTest {
    private static final QEmployee employee = QEmployee.employee;
    private static final QSurvey survey = QSurvey.survey;

    @Test
    public void count() {
        SQLSerializer serializer = new SQLSerializer(Configuration.DEFAULT);
        serializer.handle((Expression)SQLSerializerTest.employee.id.count().add((Expression)SQLSerializerTest.employee.id.countDistinct()));
        Assert.assertEquals((Object)"count(EMPLOYEE.ID) + count(distinct EMPLOYEE.ID)", (Object)serializer.toString());
    }

    @Test
    public void countDistinct() {
        SQLSerializer serializer = new SQLSerializer(Configuration.DEFAULT);
        SQLQuery query = new SQLQuery();
        query.from((Expression)QEmployeeNoPK.employee);
        query.distinct();
        serializer.serializeForQuery(query.getMetadata(), true);
        Assert.assertEquals((Object)"select count(*)\nfrom (select distinct EMPLOYEE.ID, EMPLOYEE.FIRSTNAME, EMPLOYEE.LASTNAME, EMPLOYEE.SALARY, EMPLOYEE.DATEFIELD, EMPLOYEE.TIMEFIELD, EMPLOYEE.SUPERIOR_ID\nfrom EMPLOYEE EMPLOYEE) internal", (Object)serializer.toString());
    }

    @Test
    public void countDistinct_postgreSQL() {
        Configuration postgresql = new Configuration((SQLTemplates)new PostgreSQLTemplates());
        SQLSerializer serializer = new SQLSerializer(postgresql);
        SQLQuery query = new SQLQuery();
        query.from((Expression)QEmployeeNoPK.employee);
        query.distinct();
        serializer.serializeForQuery(query.getMetadata(), true);
        Assert.assertEquals((Object)"select count(distinct (EMPLOYEE.ID, EMPLOYEE.FIRSTNAME, EMPLOYEE.LASTNAME, EMPLOYEE.SALARY, EMPLOYEE.DATEFIELD, EMPLOYEE.TIMEFIELD, EMPLOYEE.SUPERIOR_ID))\nfrom EMPLOYEE EMPLOYEE", (Object)serializer.toString());
    }

    @Test
    public void dynamicQuery() {
        SimplePath userPath = Expressions.path(Object.class, (String)"user");
        NumberPath idPath = Expressions.numberPath(Long.class, (Path)userPath, (String)"id");
        StringPath usernamePath = Expressions.stringPath((Path)userPath, (String)"username");
        Expression sq = (Expression)((SQLQuery)SQLExpressions.select((Expression[])new Expression[]{idPath, usernamePath}).from((Expression)userPath)).where((Predicate)idPath.eq((Object)1L));
        SQLSerializer serializer = new SQLSerializer(Configuration.DEFAULT);
        serializer.handle(sq);
        Assert.assertEquals((Object)"(select \"user\".id, \"user\".username\nfrom \"user\"\nwhere \"user\".id = ?)", (Object)serializer.toString());
    }

    @Test
    public void dynamicQuery2() {
        PathBuilder userPath = new PathBuilder(Object.class, "user");
        NumberPath idPath = userPath.getNumber("id", Long.class);
        StringPath usernamePath = userPath.getString("username");
        Expression sq = (Expression)((SQLQuery)SQLExpressions.select((Expression[])new Expression[]{idPath, usernamePath}).from((Expression)userPath)).where((Predicate)idPath.eq((Object)1L));
        SQLSerializer serializer = new SQLSerializer(Configuration.DEFAULT);
        serializer.handle(sq);
        Assert.assertEquals((Object)"(select \"user\".id, \"user\".username\nfrom \"user\"\nwhere \"user\".id = ?)", (Object)serializer.toString());
    }

    @Test
    public void in() {
        StringPath path = Expressions.stringPath((String)"str");
        Predicate expr = ExpressionUtils.in((Expression)path, Arrays.asList("1", "2", "3"));
        SQLSerializer serializer = new SQLSerializer(Configuration.DEFAULT);
        serializer.handle((Expression)expr);
        Assert.assertEquals(Arrays.asList(path, path, path), (Object)serializer.getConstantPaths());
        Assert.assertEquals((long)3L, (long)serializer.getConstants().size());
    }

    @Test
    public void fullJoinWithoutCodeGeneration() {
        SQLQuery sqlQuery = this.queryForMYSQLTemplate();
        PathBuilder customerPath = new PathBuilder(Object.class, "customer");
        PathBuilder deptPath = new PathBuilder(Object.class, "department");
        PathBuilder deptAliasPath = new PathBuilder(Object.class, "d");
        sqlQuery = (SQLQuery)sqlQuery.from((Expression)customerPath.as("c"));
        NumberPath idPath = Expressions.numberPath(Long.class, (Path)deptAliasPath, (String)"id");
        sqlQuery = ((SQLQuery)sqlQuery.fullJoin((EntityPath)deptPath, (Path)deptAliasPath)).select((Expression)idPath);
        Assert.assertEquals((Object)"select d.id from customer as c full join department as d", (Object)sqlQuery.toString());
    }

    @Test
    public void innerJoinWithoutCodeGeneration() {
        SQLQuery sqlQuery = this.queryForMYSQLTemplate();
        PathBuilder customerPath = new PathBuilder(Object.class, "customer");
        PathBuilder deptPath = new PathBuilder(Object.class, "department");
        PathBuilder deptAliasPath = new PathBuilder(Object.class, "d");
        sqlQuery = (SQLQuery)sqlQuery.from((Expression)customerPath.as("c"));
        NumberPath idPath = Expressions.numberPath(Long.class, (Path)deptAliasPath, (String)"id");
        sqlQuery = ((SQLQuery)sqlQuery.innerJoin((EntityPath)deptPath, (Path)deptAliasPath)).select((Expression)idPath);
        Assert.assertEquals((Object)"select d.id from customer as c inner join department as d", (Object)sqlQuery.toString());
    }

    @Test
    public void joinWithoutCodeGeneration() {
        SQLQuery sqlQuery = this.queryForMYSQLTemplate();
        PathBuilder customerPath = new PathBuilder(Object.class, "customer");
        PathBuilder deptPath = new PathBuilder(Object.class, "department");
        PathBuilder deptAliasPath = new PathBuilder(Object.class, "d");
        sqlQuery = (SQLQuery)sqlQuery.from((Expression)customerPath.as("c"));
        NumberPath idPath = Expressions.numberPath(Long.class, (Path)deptAliasPath, (String)"id");
        sqlQuery = ((SQLQuery)sqlQuery.join((EntityPath)deptPath, (Path)deptAliasPath)).select((Expression)idPath);
        Assert.assertEquals((Object)"select d.id from customer as c join department as d", (Object)sqlQuery.toString());
    }

    @Test
    public void leftJoinWithoutCodeGeneration() {
        SQLQuery sqlQuery = this.queryForMYSQLTemplate();
        PathBuilder customerPath = new PathBuilder(Object.class, "customer");
        PathBuilder deptPath = new PathBuilder(Object.class, "department");
        PathBuilder deptAliasPath = new PathBuilder(Object.class, "d");
        sqlQuery = (SQLQuery)sqlQuery.from((Expression)customerPath.as("c"));
        NumberPath idPath = Expressions.numberPath(Long.class, (Path)deptAliasPath, (String)"id");
        sqlQuery = ((SQLQuery)sqlQuery.leftJoin((EntityPath)deptPath, (Path)deptAliasPath)).select((Expression)idPath);
        Assert.assertEquals((Object)"select d.id from customer as c left join department as d", (Object)sqlQuery.toString());
    }

    @Test
    public void or_in() {
        StringPath path = Expressions.stringPath((String)"str");
        Predicate expr = ExpressionUtils.anyOf((Predicate[])new Predicate[]{ExpressionUtils.in((Expression)path, Arrays.asList("1", "2", "3")), ExpressionUtils.in((Expression)path, Arrays.asList("4", "5", "6"))});
        SQLSerializer serializer = new SQLSerializer(Configuration.DEFAULT);
        serializer.handle((Expression)expr);
        Assert.assertEquals(Arrays.asList(path, path, path, path, path, path), (Object)serializer.getConstantPaths());
        Assert.assertEquals((long)6L, (long)serializer.getConstants().size());
    }

    @Test
    public void some() {
        SQLSerializer serializer = new SQLSerializer(Configuration.DEFAULT);
        serializer.handle((Expression)SQLExpressions.any((BooleanExpression)SQLSerializerTest.employee.firstname.isNotNull()));
        Assert.assertEquals((Object)"some(EMPLOYEE.FIRSTNAME is not null)", (Object)serializer.toString());
    }

    @Test
    public void startsWith() {
        SQLSerializer serializer = new SQLSerializer(Configuration.DEFAULT);
        QSurvey s1 = new QSurvey("s1");
        serializer.handle((Expression)s1.name.startsWith("X"));
        Assert.assertEquals((Object)"s1.NAME like ? escape '\\'", (Object)serializer.toString());
        Assert.assertEquals(Collections.singletonList("X%"), (Object)serializer.getConstants());
    }

    @Test
    public void from_function() {
        SQLQuery<?> query = this.query();
        ((SQLQuery)query.from((Expression)Expressions.template(Survey.class, (String)"functionCall()", (Object[])new Object[0]))).join((EntityPath)survey);
        query.where((Predicate)SQLSerializerTest.survey.name.isNotNull());
        Assert.assertEquals((Object)"from functionCall()\njoin SURVEY SURVEY\nwhere SURVEY.NAME is not null", (Object)query.toString());
    }

    @Test
    public void join_to_function_with_alias() {
        SQLQuery<?> query = this.query();
        ((SQLQuery)query.from((Expression)survey)).join(SQLExpressions.relationalFunctionCall(Survey.class, (String)"functionCall", (Object[])new Object[0]), (Path)Expressions.path(Survey.class, (String)"fc"));
        query.where((Predicate)SQLSerializerTest.survey.name.isNotNull());
        Assert.assertEquals((Object)"from SURVEY SURVEY\njoin functionCall() as fc\nwhere SURVEY.NAME is not null", (Object)query.toString());
    }

    @Test
    public void join_to_function_in_derby() {
        SQLQuery query = new SQLQuery((SQLTemplates)DerbyTemplates.DEFAULT);
        ((SQLQuery)query.from((Expression)survey)).join(SQLExpressions.relationalFunctionCall(Survey.class, (String)"functionCall", (Object[])new Object[0]), (Path)Expressions.path(Survey.class, (String)"fc"));
        query.where((Predicate)SQLSerializerTest.survey.name.isNotNull());
        Assert.assertEquals((Object)"from SURVEY SURVEY\njoin table(functionCall()) as fc\nwhere SURVEY.NAME is not null", (Object)query.toString());
    }

    @Test
    public void crossJoin() {
        DerbyTemplates templates = new DerbyTemplates();
        templates.setCrossJoin(" cross join ");
        SQLQuery query = new SQLQuery((SQLTemplates)templates);
        query.from(new Expression[]{survey, employee});
        Assert.assertEquals((Object)"from SURVEY SURVEY cross join EMPLOYEE EMPLOYEE", (Object)query.toString());
    }

    @Test
    public void keyword_after_dot() {
        SQLQuery query = new SQLQuery((SQLTemplates)MySQLTemplates.DEFAULT);
        PathBuilder surveyBuilder = new PathBuilder(Survey.class, "survey");
        ((SQLQuery)query.from((Expression)surveyBuilder)).where((Predicate)surveyBuilder.get("not").isNotNull());
        Assert.assertFalse((boolean)query.toString().contains("`"));
    }

    @Test
    public void like() {
        BooleanExpression expr = Expressions.stringTemplate((String)"'%a%'", (Object[])new Object[0]).contains("%a%");
        SQLSerializer serializer = new SQLSerializer(Configuration.DEFAULT);
        serializer.handle((Expression)expr);
        Assert.assertEquals((Object)"'%a%' like ? escape '\\'", (Object)serializer.toString());
    }

    @Test
    public void override() {
        Configuration conf = new Configuration((SQLTemplates)new DerbyTemplates());
        conf.registerTableOverride("SURVEY", "surveys");
        SQLQuery query = new SQLQuery(conf);
        query.from((Expression)survey);
        Assert.assertEquals((Object)"from surveys SURVEY", (Object)query.toString());
    }

    @Test
    public void columnOverrides() {
        Configuration conf = new Configuration((SQLTemplates)new DerbyTemplates());
        conf.registerColumnOverride("SURVEY", "NAME", "LABEL");
        SQLQuery query = new SQLQuery(conf);
        ((SQLQuery)query.from((Expression)survey)).where((Predicate)SQLSerializerTest.survey.name.isNull());
        Assert.assertEquals((Object)"from SURVEY SURVEY\nwhere SURVEY.LABEL is null", (Object)query.toString());
    }

    @Test
    public void columnOverrides2() {
        Configuration conf = new Configuration((SQLTemplates)new DerbyTemplates());
        conf.registerColumnOverride("PUBLIC", "SURVEY", "NAME", "LABEL");
        SQLQuery query = new SQLQuery(conf);
        ((SQLQuery)query.from((Expression)survey)).where((Predicate)SQLSerializerTest.survey.name.isNull());
        Assert.assertEquals((Object)"from SURVEY SURVEY\nwhere SURVEY.LABEL is null", (Object)query.toString());
    }

    @Test
    public void complex_subQuery() {
        String[] strs;
        ArrayList<SubQueryExpression> sq = new ArrayList<SubQueryExpression>();
        for (String str : strs = new String[]{"a", "b", "c"}) {
            Expression alias = Expressions.cases().when((Predicate)SQLSerializerTest.survey.name.eq((Object)str)).then(true).otherwise((Object)false);
            sq.add((SubQueryExpression)((SQLQuery)SQLExpressions.select((Expression[])new Expression[]{SQLSerializerTest.survey.name, alias}).from((Expression)survey)).distinct());
        }
        PathBuilder subAlias = new PathBuilder(Tuple.class, "sub");
        SubQueryExpression master = (SubQueryExpression)((SQLQuery)SQLExpressions.selectOne().from(SQLExpressions.union(sq).as((Path)subAlias))).groupBy((Expression)subAlias.get("prop1"));
        SQLSerializer serializer = new SQLSerializer(Configuration.DEFAULT);
        serializer.serialize(master.getMetadata(), false);
        System.err.println(serializer);
    }

    @Test
    public void boolean_() {
        QSurvey s = new QSurvey("s");
        BooleanBuilder bb1 = new BooleanBuilder();
        bb1.and((Predicate)s.name.eq((Expression)s.name));
        BooleanBuilder bb2 = new BooleanBuilder();
        bb2.or((Predicate)s.name.eq((Expression)s.name));
        bb2.or((Predicate)s.name.eq((Expression)s.name));
        String str = ((SQLSerializer)new SQLSerializer(Configuration.DEFAULT).handle((Expression)bb1.and((Predicate)bb2))).toString();
        Assert.assertEquals((Object)"s.NAME = s.NAME and (s.NAME = s.NAME or s.NAME = s.NAME)", (Object)str);
    }

    @Test
    public void list_in_query() {
        BooleanExpression expr = Expressions.list((SimpleExpression[])new SimpleExpression[]{SQLSerializerTest.survey.id, SQLSerializerTest.survey.name}).in((SubQueryExpression)SQLExpressions.select((Expression[])new Expression[]{SQLSerializerTest.survey.id, SQLSerializerTest.survey.name}).from((Expression)survey));
        String str = ((SQLSerializer)new SQLSerializer(Configuration.DEFAULT).handle((Expression)expr)).toString();
        Assert.assertEquals((Object)"(SURVEY.ID, SURVEY.NAME) in (select SURVEY.ID, SURVEY.NAME\nfrom SURVEY SURVEY)", (Object)str);
    }

    @Test
    public void withRecursive() {
        QEmployee e = QEmployee.employee;
        PathBuilder sub = new PathBuilder(Tuple.class, "sub");
        SQLQuery query = new SQLQuery(SQLTemplates.DEFAULT);
        ((SQLQuery)query.withRecursive((Path)sub, (SubQueryExpression)SQLExpressions.unionAll((SubQueryExpression[])new SubQueryExpression[]{(SubQueryExpression)((SQLQuery)SQLExpressions.select((Expression[])new Expression[]{e.id, e.firstname, e.superiorId}).from((Expression)e)).where((Predicate)e.firstname.eq((Object)"Mike")), (SubQueryExpression)((SQLQuery)SQLExpressions.select((Expression[])new Expression[]{e.id, e.firstname, e.superiorId}).from(new Expression[]{e, sub})).where((Predicate)e.superiorId.eq((Expression)sub.get(e.id)))}))).from((Expression)sub);
        QueryMetadata md = query.getMetadata();
        md.setProjection(Wildcard.all);
        SQLSerializer serializer = new SQLSerializer(Configuration.DEFAULT);
        serializer.serialize(md, false);
        Assert.assertEquals((Object)"with recursive sub as ((select EMPLOYEE.ID, EMPLOYEE.FIRSTNAME, EMPLOYEE.SUPERIOR_ID\nfrom EMPLOYEE EMPLOYEE\nwhere EMPLOYEE.FIRSTNAME = ?)\nunion all\n(select EMPLOYEE.ID, EMPLOYEE.FIRSTNAME, EMPLOYEE.SUPERIOR_ID\nfrom EMPLOYEE EMPLOYEE, sub\nwhere EMPLOYEE.SUPERIOR_ID = sub.ID))\nselect *\nfrom sub", (Object)serializer.toString());
    }

    @Test
    public void withRecursive2() {
        QEmployee e = QEmployee.employee;
        PathBuilder sub = new PathBuilder(Tuple.class, "sub");
        SQLQuery query = new SQLQuery(SQLTemplates.DEFAULT);
        ((SQLQuery)query.withRecursive((Path)sub, new Path[]{sub.get(e.id), sub.get(e.firstname), sub.get(e.superiorId)}).as((Expression)SQLExpressions.unionAll((SubQueryExpression[])new SubQueryExpression[]{(SubQueryExpression)((SQLQuery)SQLExpressions.select((Expression[])new Expression[]{e.id, e.firstname, e.superiorId}).from((Expression)e)).where((Predicate)e.firstname.eq((Object)"Mike")), (SubQueryExpression)((SQLQuery)SQLExpressions.select((Expression[])new Expression[]{e.id, e.firstname, e.superiorId}).from(new Expression[]{e, sub})).where((Predicate)e.superiorId.eq((Expression)sub.get(e.id)))}))).from((Expression)sub);
        QueryMetadata md = query.getMetadata();
        md.setProjection(Wildcard.all);
        SQLSerializer serializer = new SQLSerializer(Configuration.DEFAULT);
        serializer.serialize(md, false);
        Assert.assertEquals((Object)"with recursive sub (ID, FIRSTNAME, SUPERIOR_ID) as ((select EMPLOYEE.ID, EMPLOYEE.FIRSTNAME, EMPLOYEE.SUPERIOR_ID\nfrom EMPLOYEE EMPLOYEE\nwhere EMPLOYEE.FIRSTNAME = ?)\nunion all\n(select EMPLOYEE.ID, EMPLOYEE.FIRSTNAME, EMPLOYEE.SUPERIOR_ID\nfrom EMPLOYEE EMPLOYEE, sub\nwhere EMPLOYEE.SUPERIOR_ID = sub.ID))\nselect *\nfrom sub", (Object)serializer.toString());
    }

    @Test
    public void useLiterals() {
        SQLSerializer serializer = new SQLSerializer(Configuration.DEFAULT);
        serializer.setUseLiterals(true);
        int offset = TimeZone.getDefault().getRawOffset();
        NumberExpression expr = SQLExpressions.datediff((DatePart)DatePart.year, SQLSerializerTest.employee.datefield, (Comparable)new Date(-offset));
        serializer.handle((Expression)expr);
        Assert.assertEquals((Object)"datediff('year',EMPLOYEE.DATEFIELD,(date '1970-01-01'))", (Object)serializer.toString());
    }

    @Test
    public void select_normalization() {
        SQLSerializer serializer = new SQLSerializer(Configuration.DEFAULT);
        serializer.visit((SubQueryExpression)SQLExpressions.select((Expression[])new Expression[]{Expressions.stringPath((String)"id"), Expressions.stringPath((String)"ID")}), null);
        Assert.assertEquals((Object)"(select id, ID as col__ID1\nfrom dual)", (Object)serializer.toString());
    }

    @Test
    public void noSchemaInWhere() {
        Configuration defaultWithPrintSchema = new Configuration(new SQLTemplates(Keywords.DEFAULT, "\"", '\\', false, false));
        defaultWithPrintSchema.getTemplates().setPrintSchema(true);
        QEmployee e = QEmployee.employee;
        SQLDeleteClause delete = new SQLDeleteClause((Connection)EasyMock.createNiceMock(Connection.class), defaultWithPrintSchema, (RelationalPath)e);
        delete.where((Predicate)e.id.gt((Number)100));
        Assert.assertEquals((Object)"delete from PUBLIC.EMPLOYEE\nwhere EMPLOYEE.ID > ?", (Object)delete.toString());
    }

    @Test
    public void schemaInWhere() {
        Configuration derbyWithPrintSchema = new Configuration(DerbyTemplates.builder().printSchema().build());
        QEmployee e = QEmployee.employee;
        SQLDeleteClause delete = new SQLDeleteClause((Connection)EasyMock.createNiceMock(Connection.class), derbyWithPrintSchema, (RelationalPath)e);
        delete.where((Predicate)e.id.gt((Number)100));
        Assert.assertEquals((Object)"delete from \"PUBLIC\".EMPLOYEE\nwhere \"PUBLIC\".EMPLOYEE.ID > ?", (Object)delete.toString());
    }

    private SQLQuery<?> query() {
        return new SQLQuery();
    }

    private SQLQuery<?> queryForMYSQLTemplate() {
        return new SQLQuery(MySQLTemplates.builder().printSchema().newLineToSingleSpace().build());
    }
}

