/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.sql.AbstractSQLTemplatesTest;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLOps;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLSerializer;
import com.querydsl.sql.SQLServer2005Templates;
import com.querydsl.sql.SQLServerTemplates;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.Union;
import org.junit.Assert;
import org.junit.Test;

public class SQLServer2005TemplatesTest
extends AbstractSQLTemplatesTest {
    @Override
    @Test
    public void noFrom() {
        this.query.getMetadata().setProjection((Expression)Expressions.ONE);
        Assert.assertEquals((Object)"select 1", (Object)this.query.toString());
    }

    @Override
    protected SQLTemplates createTemplates() {
        return new SQLServer2005Templates();
    }

    @Override
    @Test
    public void union() {
        NumberExpression one = Expressions.ONE;
        NumberExpression two = Expressions.TWO;
        NumberExpression three = Expressions.THREE;
        SimplePath col1 = Expressions.path(Integer.class, (String)"col1");
        Union union = this.query.union(new SubQueryExpression[]{SQLExpressions.select((Expression)one.as((Path)col1)), SQLExpressions.select((Expression)two), SQLExpressions.select((Expression)three)});
        Assert.assertEquals((Object)"(select 1 as col1)\nunion\n(select 2)\nunion\n(select 3)", (Object)union.toString());
    }

    @Test
    public void limit() {
        ((SQLQuery)this.query.from((Expression)survey1)).limit(5L);
        this.query.getMetadata().setProjection(SQLServer2005TemplatesTest.survey1.id);
        Assert.assertEquals((Object)"select top (?) survey1.ID from SURVEY survey1", (Object)this.query.toString());
    }

    @Test
    public void modifiers() {
        ((SQLQuery)((SQLQuery)this.query.from((Expression)survey1)).limit(5L)).offset(3L);
        this.query.orderBy(SQLServer2005TemplatesTest.survey1.id.asc());
        this.query.getMetadata().setProjection(SQLServer2005TemplatesTest.survey1.id);
        Assert.assertEquals((Object)"select * from (   select survey1.ID, row_number() over (order by survey1.ID asc) as rn from SURVEY survey1) a where rn > ? and rn <= ? order by rn", (Object)this.query.toString());
    }

    @Test
    public void modifiers_noOrder() {
        ((SQLQuery)((SQLQuery)this.query.from((Expression)survey1)).limit(5L)).offset(3L);
        this.query.getMetadata().setProjection(SQLServer2005TemplatesTest.survey1.id);
        Assert.assertEquals((Object)"select * from (   select survey1.ID, row_number() over (order by current_timestamp asc) as rn from SURVEY survey1) a where rn > ? and rn <= ? order by rn", (Object)this.query.toString());
    }

    @Test
    public void nextVal() {
        Operation nextval = ExpressionUtils.operation(String.class, (Operator)SQLOps.NEXTVAL, (Expression[])new Expression[]{ConstantImpl.create((Object)"myseq")});
        Assert.assertEquals((Object)"myseq.nextval", (Object)((SQLSerializer)new SQLSerializer(new Configuration((SQLTemplates)new SQLServerTemplates())).handle((Expression)nextval)).toString());
    }

    @Test
    public void precedence() {
        int p2 = this.getPrecedence(new Operator[]{Ops.MULT, Ops.DIV, Ops.MOD});
        int p3 = this.getPrecedence(new Operator[]{Ops.NEGATE, Ops.ADD, Ops.SUB, Ops.CONCAT});
        int p4 = this.getPrecedence(new Operator[]{Ops.EQ, Ops.GT, Ops.LT, Ops.GOE, Ops.LOE, Ops.NE});
        int p5 = this.getPrecedence(new Operator[]{Ops.NOT});
        int p6 = this.getPrecedence(new Operator[]{Ops.AND});
        int p7 = this.getPrecedence(new Operator[]{Ops.BETWEEN, Ops.IN, Ops.LIKE, Ops.LIKE_ESCAPE, Ops.OR});
        Assert.assertTrue((p2 < p3 ? 1 : 0) != 0);
        Assert.assertTrue((p3 < p4 ? 1 : 0) != 0);
        Assert.assertTrue((p4 < p5 ? 1 : 0) != 0);
        Assert.assertTrue((p5 < p6 ? 1 : 0) != 0);
        Assert.assertTrue((p6 < p7 ? 1 : 0) != 0);
    }
}

