/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.sql.AbstractSQLTemplatesTest;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLOps;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLServer2012Templates;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.Union;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import org.junit.Assert;
import org.junit.Test;

public class SQLServer2012TemplatesTest
extends AbstractSQLTemplatesTest {
    @Override
    @Test
    public void noFrom() {
        this.query.getMetadata().setProjection((Expression)Expressions.ONE);
        Assert.assertEquals((Object)"select 1", (Object)this.query.toString());
    }

    @Override
    protected SQLTemplates createTemplates() {
        return new SQLServer2012Templates();
    }

    @Override
    @Test
    public void union() {
        NumberExpression one = Expressions.ONE;
        NumberExpression two = Expressions.TWO;
        NumberExpression three = Expressions.THREE;
        SimplePath col1 = Expressions.path(Integer.class, (String)"col1");
        Union union = this.query.union(new SubQueryExpression[]{SQLExpressions.select((Expression)one.as((Path)col1)), SQLExpressions.select((Expression)two), SQLExpressions.select((Expression)three)});
        Assert.assertEquals((Object)"(select 1 as col1)\nunion\n(select 2)\nunion\n(select 3)", (Object)union.toString());
    }

    @Test
    public void limit() {
        ((SQLQuery)this.query.from((Expression)survey1)).limit(5L);
        this.query.getMetadata().setProjection(SQLServer2012TemplatesTest.survey1.id);
        Assert.assertEquals((Object)"select top 5 survey1.ID from SURVEY survey1", (Object)this.query.toString());
    }

    @Test
    public void limitOffset() {
        ((SQLQuery)((SQLQuery)this.query.from((Expression)survey1)).limit(5L)).offset(5L);
        this.query.getMetadata().setProjection(SQLServer2012TemplatesTest.survey1.id);
        Assert.assertEquals((Object)"select survey1.ID from SURVEY survey1 order by 1 asc offset ? rows fetch next ? rows only", (Object)this.query.toString());
    }

    @Test
    public void delete_limit() {
        SQLDeleteClause clause = new SQLDeleteClause(null, this.createTemplates(), (RelationalPath)survey1);
        clause.where((Predicate)SQLServer2012TemplatesTest.survey1.name.eq((Object)"Bob"));
        clause.limit(5L);
        Assert.assertEquals((Object)"delete top 5 from SURVEY\nwhere SURVEY.NAME = ?", (Object)clause.toString());
    }

    @Test
    public void update_limit() {
        SQLUpdateClause clause = new SQLUpdateClause(null, this.createTemplates(), (RelationalPath)survey1);
        clause.set((Path)SQLServer2012TemplatesTest.survey1.name, (Object)"Bob");
        clause.limit(5L);
        Assert.assertEquals((Object)"update top 5 SURVEY\nset NAME = ?", (Object)clause.toString());
    }

    @Test
    public void modifiers() {
        ((SQLQuery)((SQLQuery)((SQLQuery)this.query.from((Expression)survey1)).limit(5L)).offset(3L)).orderBy(SQLServer2012TemplatesTest.survey1.id.asc());
        this.query.getMetadata().setProjection(SQLServer2012TemplatesTest.survey1.id);
        Assert.assertEquals((Object)"select survey1.ID from SURVEY survey1 order by survey1.ID asc offset ? rows fetch next ? rows only", (Object)this.query.toString());
    }

    @Test
    public void nextVal() {
        Operation nextval = ExpressionUtils.operation(String.class, (Operator)SQLOps.NEXTVAL, (Expression[])new Expression[]{ConstantImpl.create((Object)"myseq")});
        this.assertSerialized((Expression<?>)nextval, "next value for myseq");
    }
}

