/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.DateTimeExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.sql.AbstractSQLTemplatesTest;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.DatePart;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLOps;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLSerializer;
import com.querydsl.sql.SQLServerTemplates;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.Union;
import org.junit.Assert;
import org.junit.Test;

public class SQLServerTemplatesTest
extends AbstractSQLTemplatesTest {
    @Override
    @Test
    public void noFrom() {
        this.query.getMetadata().setProjection((Expression)Expressions.ONE);
        Assert.assertEquals((Object)"select 1", (Object)this.query.toString());
    }

    @Override
    protected SQLTemplates createTemplates() {
        return new SQLServerTemplates();
    }

    @Override
    @Test
    public void union() {
        NumberExpression one = Expressions.ONE;
        NumberExpression two = Expressions.TWO;
        NumberExpression three = Expressions.THREE;
        SimplePath col1 = Expressions.path(Integer.class, (String)"col1");
        Union union = this.query.union(new SubQueryExpression[]{SQLExpressions.select((Expression)one.as((Path)col1)), SQLExpressions.select((Expression)two), SQLExpressions.select((Expression)three)});
        Assert.assertEquals((Object)"(select 1 as col1)\nunion\n(select 2)\nunion\n(select 3)", (Object)union.toString());
    }

    @Test
    public void limit() {
        ((SQLQuery)this.query.from((Expression)survey1)).limit(5L);
        this.query.getMetadata().setProjection(SQLServerTemplatesTest.survey1.id);
        Assert.assertEquals((Object)"select top 5 survey1.ID from SURVEY survey1", (Object)this.query.toString());
    }

    @Test
    public void nextVal() {
        Operation nextval = ExpressionUtils.operation(String.class, (Operator)SQLOps.NEXTVAL, (Expression[])new Expression[]{ConstantImpl.create((Object)"myseq")});
        Assert.assertEquals((Object)"myseq.nextval", (Object)((SQLSerializer)new SQLSerializer(new Configuration((SQLTemplates)new SQLServerTemplates())).handle((Expression)nextval)).toString());
    }

    @Test
    public void truncateWeek() {
        SQLQuery expression = this.query.select((Expression)SQLExpressions.datetrunc((DatePart)DatePart.week, (DateTimeExpression)Expressions.dateTimeTemplate(Comparable.class, (String)"dateExpression", (Object[])new Object[0])));
        Assert.assertEquals((Object)"select DATEADD(WEEK, DATEDIFF(WEEK, 0, dateExpression - 1), 0)", (Object)expression.toString());
    }
}

