/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.Wildcard;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.ProjectableSQLQuery;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLSerializer;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.domain.QEmployee;
import com.querydsl.sql.domain.QSurvey;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class SQLSubQueryTest {
    private static final QEmployee employee = QEmployee.employee;

    @Test(expected=IllegalArgumentException.class)
    public void unknownOperator() {
        Operator op = new Operator(){

            public String name() {
                return "unknownfn";
            }

            public String toString() {
                return this.name();
            }

            public Class<?> getType() {
                return Object.class;
            }
        };
        SQLQuery query = new SQLQuery();
        ((SQLQuery)((SQLQuery)query.from((Expression)employee)).where((Predicate)Expressions.booleanOperation((Operator)op, (Expression[])new Expression[]{SQLSubQueryTest.employee.id}))).toString();
    }

    @Test
    public void list() {
        ProjectableSQLQuery subQuery = SQLExpressions.select((Expression[])new Expression[]{SQLSubQueryTest.employee.id, Expressions.constant((Object)"XXX"), SQLSubQueryTest.employee.firstname}).from((Expression)employee);
        List exprs = ((FactoryExpression)subQuery.getMetadata().getProjection()).getArgs();
        Assert.assertEquals(SQLSubQueryTest.employee.id, exprs.get(0));
        Assert.assertEquals((Object)ConstantImpl.create((Object)"XXX"), exprs.get(1));
        Assert.assertEquals((Object)SQLSubQueryTest.employee.firstname, exprs.get(2));
    }

    @Test
    public void list_entity() {
        QEmployee employee2 = new QEmployee("employee2");
        ProjectableSQLQuery expr = ((SQLQuery)SQLExpressions.select((Expression[])new Expression[]{employee, employee2.id}).from((Expression)employee)).innerJoin(SQLSubQueryTest.employee.superiorIdKey, (RelationalPath)employee2);
        SQLSerializer serializer = new SQLSerializer(new Configuration(SQLTemplates.DEFAULT));
        serializer.handle((Expression)expr);
        Assert.assertEquals((Object)"(select EMPLOYEE.ID, EMPLOYEE.FIRSTNAME, EMPLOYEE.LASTNAME, EMPLOYEE.SALARY, EMPLOYEE.DATEFIELD, EMPLOYEE.TIMEFIELD, EMPLOYEE.SUPERIOR_ID, employee2.ID as col__ID7\nfrom EMPLOYEE EMPLOYEE\ninner join EMPLOYEE employee2\non EMPLOYEE.SUPERIOR_ID = employee2.ID)", (Object)serializer.toString());
    }

    @Test
    public void in() {
        ProjectableSQLQuery ints = SQLExpressions.select(SQLSubQueryTest.employee.id).from((Expression)employee);
        QEmployee.employee.id.in((SubQueryExpression)ints);
    }

    @Test
    public void in_union() {
        ProjectableSQLQuery ints1 = SQLExpressions.select(SQLSubQueryTest.employee.id).from((Expression)employee);
        ProjectableSQLQuery ints2 = SQLExpressions.select(SQLSubQueryTest.employee.id).from((Expression)employee);
        QEmployee.employee.id.in((SubQueryExpression)SQLExpressions.union((SubQueryExpression[])new SubQueryExpression[]{ints1, ints2}));
    }

    @Test
    public void in_union2() {
        ProjectableSQLQuery ints1 = SQLExpressions.select(SQLSubQueryTest.employee.id).from((Expression)employee);
        ProjectableSQLQuery ints2 = SQLExpressions.select(SQLSubQueryTest.employee.id).from((Expression)employee);
        QEmployee.employee.id.in((SubQueryExpression)SQLExpressions.union((SubQueryExpression[])new SubQueryExpression[]{ints1, ints2}));
    }

    @Test
    public void unique() {
        ProjectableSQLQuery subQuery = SQLExpressions.select((Expression[])new Expression[]{SQLSubQueryTest.employee.id, Expressions.constant((Object)"XXX"), SQLSubQueryTest.employee.firstname}).from((Expression)employee);
        List exprs = ((FactoryExpression)subQuery.getMetadata().getProjection()).getArgs();
        Assert.assertEquals(SQLSubQueryTest.employee.id, exprs.get(0));
        Assert.assertEquals((Object)ConstantImpl.create((Object)"XXX"), exprs.get(1));
        Assert.assertEquals((Object)SQLSubQueryTest.employee.firstname, exprs.get(2));
    }

    @Test
    public void complex() {
        QSurvey survey = new QSurvey("survey");
        QEmployee emp1 = new QEmployee("emp1");
        QEmployee emp2 = new QEmployee("emp2");
        ProjectableSQLQuery subQuery = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select((Expression[])new Expression[]{survey.id, emp2.firstname}).from((Expression)survey)).innerJoin((EntityPath)emp1)).on((Predicate)survey.id.eq(emp1.id))).innerJoin((EntityPath)emp2)).on(new Predicate[]{emp1.superiorId.eq(emp2.superiorId), emp1.firstname.eq((Expression)emp2.firstname)});
        Assert.assertEquals((long)3L, (long)subQuery.getMetadata().getJoins().size());
    }

    @Test
    public void validate() {
        NumberPath operatorTotalPermits = Expressions.numberPath(Long.class, (String)"operator_total_permits");
        QSurvey survey = new QSurvey("survey");
        SimpleExpression e = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select((Expression[])new Expression[]{survey.name, Wildcard.count.as((Path)operatorTotalPermits)}).from((Expression)survey)).where((Predicate)survey.name.goe((Comparable)((Object)"A")))).groupBy((Expression)survey.name)).orderBy(operatorTotalPermits.asc())).limit(10L)).as("top");
        SQLExpressions.select((Expression)Wildcard.all).from((Expression)e);
    }

    @Test
    public void union1() {
        QSurvey survey = QSurvey.survey;
        ProjectableSQLQuery q1 = SQLExpressions.select(survey.id).from((Expression)survey);
        ProjectableSQLQuery q2 = SQLExpressions.select(survey.id).from((Expression)survey);
        SQLExpressions.union((SubQueryExpression[])new SubQueryExpression[]{q1, q2});
        SQLExpressions.union((SubQueryExpression[])new SubQueryExpression[]{q1});
    }

    @Test
    public void union1_with() {
        QSurvey survey1 = new QSurvey("survey1");
        QSurvey survey2 = new QSurvey("survey2");
        QSurvey survey3 = new QSurvey("survey3");
        SQLQuery query = new SQLQuery();
        query.with((Path)survey1, (SubQueryExpression)SQLExpressions.select((Expression[])survey1.all()).from((Expression)survey1));
        query.union(new SubQueryExpression[]{SQLExpressions.select((Expression[])survey2.all()).from((Expression)survey2), SQLExpressions.select((Expression[])survey3.all()).from((Expression)survey3)});
        Assert.assertEquals((Object)"with survey1 as (select survey1.NAME, survey1.NAME2, survey1.ID\nfrom SURVEY survey1)\n(select survey2.NAME, survey2.NAME2, survey2.ID\nfrom SURVEY survey2)\nunion\n(select survey3.NAME, survey3.NAME2, survey3.ID\nfrom SURVEY survey3)", (Object)query.toString());
    }
}

