/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Template;
import com.querydsl.core.types.TemplateFactory;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.DerbyTemplates;
import com.querydsl.sql.H2Templates;
import com.querydsl.sql.SQLOps;
import com.querydsl.sql.SQLSerializer;
import com.querydsl.sql.SQLTemplates;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.junit.Assert;
import org.junit.Test;

public class SQLTemplatesTest {
    private static final String DATETIME = "\\(timestamp '\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}'\\)";
    private static final String TIME = "\\(time '\\d{2}:\\d{2}:\\d{2}'\\)";
    private static final String DATE = "\\(date '\\d{4}-\\d{2}-\\d{2}'\\)";

    private static void assertMatches(String regex, String str) {
        Assert.assertTrue((String)str, (boolean)str.matches(regex));
    }

    @Test
    public void test() {
        Template template = TemplateFactory.DEFAULT.create("fetch first {0s} rows only");
        Assert.assertTrue((boolean)(template.getElements().get(1) instanceof Template.AsString));
        SQLSerializer serializer = new SQLSerializer(new Configuration((SQLTemplates)new DerbyTemplates()));
        serializer.handle((Expression)Expressions.template(Object.class, (Template)template, (Object[])new Object[]{ConstantImpl.create((int)5)}));
        Assert.assertEquals((Object)"fetch first 5 rows only", (Object)serializer.toString());
    }

    @Test
    public void testRequiresQuotes() {
        Assert.assertTrue((boolean)SQLTemplates.DEFAULT.requiresQuotes("First Name", false));
    }

    @Test
    public void asLiteral() {
        SQLTemplates templates = SQLTemplates.DEFAULT;
        Configuration conf = new Configuration(templates);
        SQLTemplatesTest.assertMatches(DATE, conf.asLiteral((Object)new Date(0L)));
        SQLTemplatesTest.assertMatches(TIME, conf.asLiteral((Object)new Time(0L)));
        SQLTemplatesTest.assertMatches(DATETIME, conf.asLiteral((Object)new Timestamp(0L)));
    }

    @Test
    public void asLiteral_jodaTime() {
        SQLTemplates templates = SQLTemplates.DEFAULT;
        Configuration conf = new Configuration(templates);
        SQLTemplatesTest.assertMatches(DATE, conf.asLiteral((Object)new LocalDate(0L)));
        SQLTemplatesTest.assertMatches(TIME, conf.asLiteral((Object)new LocalTime(0L)));
        SQLTemplatesTest.assertMatches(DATETIME, conf.asLiteral((Object)new DateTime(0L)));
    }

    @Test
    public void quote() {
        SQLTemplates templates = SQLTemplates.DEFAULT;
        Assert.assertEquals((Object)"employee", (Object)templates.quoteIdentifier("employee"));
        Assert.assertEquals((Object)"Employee", (Object)templates.quoteIdentifier("Employee"));
        Assert.assertEquals((Object)"employee1", (Object)templates.quoteIdentifier("employee1"));
        Assert.assertEquals((Object)"employee_", (Object)templates.quoteIdentifier("employee_"));
        Assert.assertEquals((Object)"\"e e\"", (Object)templates.quoteIdentifier("e e"));
        Assert.assertEquals((Object)"\"1phoenix2\"", (Object)templates.quoteIdentifier("1phoenix2"));
    }

    @Test
    public void quoting_performance() {
        H2Templates templates = new H2Templates();
        long start = System.currentTimeMillis();
        int iterations = 1000000;
        for (int i = 0; i < iterations; ++i) {
            templates.quoteIdentifier("companies");
        }
        System.err.println(System.currentTimeMillis() - start);
    }

    @Test
    public void nextVal() {
        Operation nextval = ExpressionUtils.operation(String.class, (Operator)SQLOps.NEXTVAL, (Expression[])new Expression[]{ConstantImpl.create((Object)"myseq")});
        Assert.assertEquals((Object)"nextval('myseq')", (Object)((SQLSerializer)new SQLSerializer(new Configuration(SQLTemplates.DEFAULT)).handle((Expression)nextval)).toString());
    }

    @Test
    public void numeric_operations() {
        NumberPath intPath = Expressions.numberPath(Integer.class, (String)"intPath");
        NumberPath intPath2 = Expressions.numberPath(Integer.class, (String)"intPath2");
        SQLSerializer serializer = new SQLSerializer(new Configuration(SQLTemplates.DEFAULT));
        serializer.handle((Expression)intPath.subtract((Expression)intPath2.add((Number)2)));
        Assert.assertEquals((Object)"intPath - (intPath2 + ?)", (Object)serializer.toString());
    }
}

