/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.sql.AbstractSQLTemplatesTest;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.SQLiteTemplates;
import com.querydsl.sql.Union;
import org.junit.Assert;
import org.junit.Test;

public class SQLiteTemplatesTest
extends AbstractSQLTemplatesTest {
    @Override
    protected SQLTemplates createTemplates() {
        return new SQLiteTemplates();
    }

    @Override
    public void union() {
        NumberExpression one = Expressions.ONE;
        NumberExpression two = Expressions.TWO;
        NumberExpression three = Expressions.THREE;
        SimplePath col1 = Expressions.path(Integer.class, (String)"col1");
        Union union = this.query.union(new SubQueryExpression[]{SQLExpressions.select((Expression)one.as((Path)col1)), SQLExpressions.select((Expression)two), SQLExpressions.select((Expression)three)});
        Assert.assertEquals((Object)"select 1 as col1\nunion\nselect 2\nunion\nselect 3", (Object)union.toString());
    }

    @Test
    public void precedence() {
        int p1 = this.getPrecedence(new Operator[]{Ops.MULT, Ops.DIV, Ops.MOD});
        int p2 = this.getPrecedence(new Operator[]{Ops.ADD, Ops.SUB});
        int p3 = this.getPrecedence(new Operator[]{Ops.LT, Ops.GT, Ops.LOE, Ops.GOE});
        int p4 = this.getPrecedence(new Operator[]{Ops.EQ, Ops.EQ_IGNORE_CASE, Ops.IS_NULL, Ops.IS_NOT_NULL, Ops.IN, Ops.LIKE, Ops.LIKE_ESCAPE, Ops.MATCHES});
        int p5 = this.getPrecedence(new Operator[]{Ops.AND});
        int p6 = this.getPrecedence(new Operator[]{Ops.OR});
        Assert.assertTrue((p1 < p2 ? 1 : 0) != 0);
        Assert.assertTrue((p2 < p3 ? 1 : 0) != 0);
        Assert.assertTrue((p3 < p4 ? 1 : 0) != 0);
        Assert.assertTrue((p4 < p5 ? 1 : 0) != 0);
        Assert.assertTrue((p5 < p6 ? 1 : 0) != 0);
    }
}

