/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.Pair;
import com.querydsl.core.Fetchable;
import com.querydsl.core.NonUniqueResultException;
import com.querydsl.core.QueryException;
import com.querydsl.core.QueryExecution;
import com.querydsl.core.QueryResults;
import com.querydsl.core.QuerydslModule;
import com.querydsl.core.Target;
import com.querydsl.core.Tuple;
import com.querydsl.core.group.Group;
import com.querydsl.core.group.GroupBy;
import com.querydsl.core.testutil.ExcludeIn;
import com.querydsl.core.testutil.IncludeIn;
import com.querydsl.core.testutil.Serialization;
import com.querydsl.core.types.ArrayConstructorExpression;
import com.querydsl.core.types.Concatenation;
import com.querydsl.core.types.Constant;
import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.ParamNotSetException;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.QTuple;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Coalesce;
import com.querydsl.core.types.dsl.ComparableExpressionBase;
import com.querydsl.core.types.dsl.DateExpression;
import com.querydsl.core.types.dsl.DateTimeExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.MathExpressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.NumberTemplate;
import com.querydsl.core.types.dsl.Param;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.SimpleTemplate;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.core.types.dsl.StringExpressions;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.types.dsl.StringTemplate;
import com.querydsl.core.types.dsl.Wildcard;
import com.querydsl.sql.AbstractBaseTest;
import com.querydsl.sql.Beans;
import com.querydsl.sql.Connections;
import com.querydsl.sql.Constants;
import com.querydsl.sql.DatePart;
import com.querydsl.sql.Projection;
import com.querydsl.sql.QBeans;
import com.querydsl.sql.QProjection;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLBaseListener;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLListener;
import com.querydsl.sql.SQLListenerContext;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SimpleProjection;
import com.querydsl.sql.SkipForQuoted;
import com.querydsl.sql.StatementOptions;
import com.querydsl.sql.Survey;
import com.querydsl.sql.WithinGroup;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.domain.Employee;
import com.querydsl.sql.domain.IdName;
import com.querydsl.sql.domain.QEmployee;
import com.querydsl.sql.domain.QEmployeeNoPK;
import com.querydsl.sql.domain.QIdName;
import com.querydsl.sql.domain.QNumberTest;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class SelectBase
extends AbstractBaseTest {
    private static final Expression<?>[] NO_EXPRESSIONS = new Expression[0];
    private final QueryExecution standardTest = new QueryExecution(QuerydslModule.SQL, Connections.getTarget()){

        protected Fetchable<?> createQuery() {
            return SelectBase.this.testQuery().from(new Expression[]{Constants.employee, Constants.employee2});
        }

        protected Fetchable<?> createQuery(Predicate filter) {
            return ((SQLQuery)((SQLQuery)SelectBase.this.testQuery().from(new Expression[]{Constants.employee, Constants.employee2})).where(filter)).select((Expression)Constants.employee.firstname);
        }
    };

    private <T> T firstResult(Expression<T> expr) {
        return (T)this.query().select(expr).fetchFirst();
    }

    private Tuple firstResult(Expression<?> ... exprs) {
        return (Tuple)this.query().select(exprs).fetchFirst();
    }

    @Test
    public void aggregate_list() {
        int min = 30000;
        int avg = 65000;
        int max = 160000;
        Assert.assertEquals((long)min, (long)((BigDecimal)((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.salary.min()).fetch().get(0)).intValue());
        Assert.assertEquals((long)avg, (long)((Double)((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.salary.avg()).fetch().get(0)).intValue());
        Assert.assertEquals((long)max, (long)((BigDecimal)((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.salary.max()).fetch().get(0)).intValue());
    }

    @Test
    public void aggregate_uniqueResult() {
        int min = 30000;
        int avg = 65000;
        int max = 160000;
        Assert.assertEquals((long)min, (long)((BigDecimal)((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.salary.min()).fetchOne()).intValue());
        Assert.assertEquals((long)avg, (long)((Double)((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.salary.avg()).fetchOne()).intValue());
        Assert.assertEquals((long)max, (long)((BigDecimal)((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.salary.max()).fetchOne()).intValue());
    }

    @Test
    @ExcludeIn(value={Target.ORACLE})
    @SkipForQuoted
    public void alias() {
        this.expectedQuery = "select e.ID as id from EMPLOYEE e";
        ((SQLQuery)((SQLQuery)this.query().from(new Expression[0])).select((Expression)Constants.employee.id.as(Constants.employee.id)).from((Expression)Constants.employee)).fetch();
    }

    @Test
    @ExcludeIn(value={Target.MYSQL, Target.ORACLE})
    @SkipForQuoted
    public void alias_quotes() {
        this.expectedQuery = "select e.FIRSTNAME as \"First Name\" from EMPLOYEE e";
        ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.firstname.as("First Name")).fetch();
    }

    @Test
    @IncludeIn(value={Target.MYSQL})
    @SkipForQuoted
    public void alias_quotes_MySQL() {
        this.expectedQuery = "select e.FIRSTNAME as `First Name` from EMPLOYEE e";
        ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.firstname.as("First Name")).fetch();
    }

    @Test
    @IncludeIn(value={Target.ORACLE})
    @SkipForQuoted
    public void alias_quotes_Oracle() {
        this.expectedQuery = "select e.FIRSTNAME \"First Name\" from EMPLOYEE e";
        ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.firstname.as("First Name"));
    }

    @Test
    public void all() {
        Path[] pathArray = Constants.survey.all();
        int n = pathArray.length;
        for (int i = 0; i < n; ++i) {
            Path expr;
            Path path = expr = pathArray[i];
            Assert.assertEquals((Object)((Object)Constants.survey), (Object)path.getMetadata().getParent());
        }
    }

    private void arithmeticTests(NumberExpression<Integer> one, NumberExpression<Integer> two, NumberExpression<Integer> three, NumberExpression<Integer> four) {
        Assert.assertEquals((long)1L, (long)this.firstResult((Expression<T>)((Expression)one)).intValue());
        Assert.assertEquals((long)2L, (long)this.firstResult((Expression<T>)((Expression)two)).intValue());
        Assert.assertEquals((long)4L, (long)this.firstResult((Expression<T>)((Expression)four)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)this.firstResult((Expression<T>)((Expression)one.subtract(two).add(four)))).intValue());
        Assert.assertEquals((long)-5L, (long)((Integer)this.firstResult((Expression<T>)((Expression)one.subtract((Expression)two.add(four))))).intValue());
        Assert.assertEquals((long)-1L, (long)((Integer)this.firstResult((Expression<T>)((Expression)one.add(two).subtract(four)))).intValue());
        Assert.assertEquals((long)-1L, (long)((Integer)this.firstResult((Expression<T>)((Expression)one.add((Expression)two.subtract(four))))).intValue());
        Assert.assertEquals((long)12L, (long)((Integer)this.firstResult((Expression<T>)((Expression)one.add(two).multiply(four)))).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)this.firstResult((Expression<T>)((Expression)four.multiply(one).divide(two)))).intValue());
        Assert.assertEquals((long)6L, (long)((Integer)this.firstResult((Expression<T>)((Expression)four.divide(two).multiply(three)))).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)this.firstResult((Expression<T>)((Expression)four.divide((Expression)two.multiply(two))))).intValue());
    }

    @Test
    public void arithmetic() {
        NumberTemplate one = Expressions.numberTemplate(Integer.class, (String)"(1.0)", (Object[])new Object[0]);
        NumberTemplate two = Expressions.numberTemplate(Integer.class, (String)"(2.0)", (Object[])new Object[0]);
        NumberTemplate three = Expressions.numberTemplate(Integer.class, (String)"(3.0)", (Object[])new Object[0]);
        NumberTemplate four = Expressions.numberTemplate(Integer.class, (String)"(4.0)", (Object[])new Object[0]);
        this.arithmeticTests((NumberExpression<Integer>)one, (NumberExpression<Integer>)two, (NumberExpression<Integer>)three, (NumberExpression<Integer>)four);
        Assert.assertEquals((long)2L, (long)((Integer)this.firstResult((Expression<T>)((Expression)four.multiply((Expression)one.divide((Expression)two))))).intValue());
    }

    @Test
    public void arithmetic2() {
        NumberExpression one = Expressions.ONE;
        NumberExpression two = Expressions.TWO;
        NumberExpression three = Expressions.THREE;
        NumberExpression four = Expressions.FOUR;
        this.arithmeticTests((NumberExpression<Integer>)one, (NumberExpression<Integer>)two, (NumberExpression<Integer>)three, (NumberExpression<Integer>)four);
    }

    @Test
    public void arithmetic_mod() {
        NumberTemplate one = Expressions.numberTemplate(Integer.class, (String)"(1)", (Object[])new Object[0]);
        NumberTemplate two = Expressions.numberTemplate(Integer.class, (String)"(2)", (Object[])new Object[0]);
        NumberTemplate three = Expressions.numberTemplate(Integer.class, (String)"(3)", (Object[])new Object[0]);
        NumberTemplate four = Expressions.numberTemplate(Integer.class, (String)"(4)", (Object[])new Object[0]);
        Assert.assertEquals((long)4L, (long)((Integer)this.firstResult((Expression<T>)((Expression)four.mod((Expression)three).add((Expression)three)))).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)this.firstResult((Expression<T>)((Expression)four.mod((Expression)two.add((Expression)one))))).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)this.firstResult((Expression<T>)((Expression)four.mod((Expression)two.multiply((Expression)one))))).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)this.firstResult((Expression<T>)((Expression)four.add((Expression)one).mod((Expression)three)))).intValue());
    }

    @Test
    @IncludeIn(value={Target.POSTGRESQL})
    public void array() {
        SimpleTemplate expr = Expressions.template(Integer[].class, (String)"'{1,2,3}'::int[]", (Object[])new Object[0]);
        Integer[] result = (Integer[])this.firstResult((Expression<T>)((Expression)expr));
        Assert.assertEquals((long)3L, (long)result.length);
        Assert.assertEquals((long)1L, (long)result[0].intValue());
        Assert.assertEquals((long)2L, (long)result[1].intValue());
        Assert.assertEquals((long)3L, (long)result[2].intValue());
    }

    @Test
    @IncludeIn(value={Target.POSTGRESQL})
    public void array2() {
        SimpleTemplate expr = Expressions.template(int[].class, (String)"'{1,2,3}'::int[]", (Object[])new Object[0]);
        int[] result = (int[])this.firstResult((Expression<T>)((Expression)expr));
        Assert.assertEquals((long)3L, (long)result.length);
        Assert.assertEquals((long)1L, (long)result[0]);
        Assert.assertEquals((long)2L, (long)result[1]);
        Assert.assertEquals((long)3L, (long)result[2]);
    }

    @Test
    @ExcludeIn(value={Target.DERBY, Target.HSQLDB})
    public void array_null() {
        SimpleTemplate expr = Expressions.template(Integer[].class, (String)"null", (Object[])new Object[0]);
        Assert.assertNull(this.firstResult((Expression<T>)((Expression)expr)));
    }

    @Test
    public void array_projection() {
        List results = ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)new ArrayConstructorExpression(String[].class, new Expression[]{Constants.employee.firstname})).fetch();
        Assert.assertFalse((boolean)results.isEmpty());
        for (String[] result : results) {
            Assert.assertNotNull((Object)result[0]);
        }
    }

    @Test
    public void beans() {
        List rows = ((SQLQuery)this.query().from(new Expression[]{Constants.employee, Constants.employee2})).select((Expression)new QBeans(new RelationalPath[]{Constants.employee, Constants.employee2})).fetch();
        Assert.assertFalse((boolean)rows.isEmpty());
        for (Beans row : rows) {
            Assert.assertEquals(Employee.class, ((Employee)row.get((RelationalPath)Constants.employee)).getClass());
            Assert.assertEquals(Employee.class, ((Employee)row.get((RelationalPath)Constants.employee2)).getClass());
        }
    }

    @Test
    public void between() {
        Assert.assertEquals(Arrays.asList(11, 12, 13), (Object)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.id.between((Number)11, (Number)13))).orderBy(Constants.employee.id.asc())).select(Constants.employee.id).fetch());
    }

    @Test
    @ExcludeIn(value={Target.ORACLE, Target.CUBRID, Target.FIREBIRD, Target.DB2, Target.DERBY, Target.SQLSERVER, Target.SQLITE, Target.TERADATA})
    public void boolean_all() {
        Assert.assertTrue((boolean)((Boolean)((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)SQLExpressions.all((BooleanExpression)Constants.employee.firstname.isNotNull())).fetchOne()));
    }

    @Test
    @ExcludeIn(value={Target.ORACLE, Target.CUBRID, Target.FIREBIRD, Target.DB2, Target.DERBY, Target.SQLSERVER, Target.SQLITE, Target.TERADATA})
    public void boolean_any() {
        Assert.assertTrue((boolean)((Boolean)((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)SQLExpressions.any((BooleanExpression)Constants.employee.firstname.isNotNull())).fetchOne()));
    }

    @Test
    public void case_() {
        NumberExpression numExpression = Constants.employee.salary.floatValue().divide((Expression)Constants.employee2.salary.floatValue()).multiply((Number)100.1);
        NumberExpression numExpression2 = (NumberExpression)Constants.employee.id.when((Object)0).then((Number)Float.valueOf(0.0f)).otherwise((Expression)numExpression);
        Assert.assertEquals(Arrays.asList(87, 90, 88, 87, 83, 80, 75), (Object)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from(new Expression[]{Constants.employee, Constants.employee2})).where((Predicate)Constants.employee.id.eq((Expression)Constants.employee2.id.add((Number)1)))).orderBy(new OrderSpecifier[]{Constants.employee.id.asc(), Constants.employee2.id.asc()})).select((Expression)numExpression2.floor().intValue()).fetch());
    }

    @Test
    public void casts() throws SQLException {
        NumberPath<Integer> num = Constants.employee.id;
        ArrayList exprs = new ArrayList();
        this.add(exprs, num.byteValue(), Target.MYSQL);
        this.add(exprs, num.doubleValue(), new Target[0]);
        this.add(exprs, num.floatValue(), new Target[0]);
        this.add(exprs, num.intValue(), new Target[0]);
        this.add(exprs, num.longValue(), Target.MYSQL);
        this.add(exprs, num.shortValue(), Target.MYSQL);
        this.add(exprs, num.stringValue(), Target.DERBY);
        for (Expression expr : exprs) {
            for (Object o : ((SQLQuery)this.query().from((Expression)Constants.employee)).select(expr).fetch()) {
                Assert.assertEquals((Object)expr.getType(), o.getClass());
            }
        }
    }

    @Test
    public void coalesce() {
        Coalesce c = new Coalesce(new Expression[]{Constants.employee.firstname, Constants.employee.lastname}).add((Comparable)((Object)"xxx"));
        Assert.assertEquals(Collections.emptyList(), (Object)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)c.getValue().eq((Object)"xxx"))).select(Constants.employee.id).fetch());
    }

    @Test
    public void compact_join() {
        Assert.assertEquals((long)8L, (long)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).innerJoin((EntityPath)Constants.employee2)).on((Predicate)Constants.employee.superiorId.eq(Constants.employee2.id))).select(new Expression[]{Constants.employee.id, Constants.employee2.id}).fetch().size());
        Assert.assertEquals((long)8L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).innerJoin(Constants.employee.superiorIdKey, (RelationalPath)Constants.employee2)).select(new Expression[]{Constants.employee.id, Constants.employee2.id}).fetch().size());
    }

    @Test
    public void complex_boolean() {
        BooleanExpression first = Constants.employee.firstname.eq((Object)"Mike").and((Predicate)Constants.employee.lastname.eq((Object)"Smith"));
        BooleanExpression second = Constants.employee.firstname.eq((Object)"Joe").and((Predicate)Constants.employee.lastname.eq((Object)"Divis"));
        Assert.assertEquals((long)2L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)first.or((Predicate)second))).fetchCount());
        Assert.assertEquals((long)0L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where(new Predicate[]{Constants.employee.firstname.eq((Object)"Mike"), Constants.employee.lastname.eq((Object)"Smith").or((Predicate)Constants.employee.firstname.eq((Object)"Joe")), Constants.employee.lastname.eq((Object)"Divis")})).fetchCount());
    }

    @Test
    public void complex_subQuery() {
        NumberPath sal = Expressions.numberPath(BigDecimal.class, (String)"sal");
        PathBuilder sq = new PathBuilder(BigDecimal.class, "sq");
        ((SQLQuery)this.query().from((Expression)((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.salary.add(Constants.employee.salary).add(Constants.employee.salary).as((Path)sal)).as((Path)sq))).select(new Expression[]{sq.get(sal).avg(), sq.get(sal).min(), sq.get(sal).max()}).fetch();
    }

    @Test
    public void constructor_projection() {
        for (IdName idAndName : ((SQLQuery)this.query().from((Expression)Constants.survey)).select((Expression)new QIdName((Expression<Integer>)Constants.survey.id, (Expression<String>)Constants.survey.name)).fetch()) {
            Assert.assertNotNull((Object)idAndName);
            Assert.assertNotNull((Object)idAndName.getId());
            Assert.assertNotNull((Object)idAndName.getName());
        }
    }

    @Test
    public void constructor_projection2() {
        List projections = ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Projections.constructor(SimpleProjection.class, (Expression[])new Expression[]{Constants.employee.firstname, Constants.employee.lastname})).fetch();
        Assert.assertFalse((boolean)projections.isEmpty());
        for (SimpleProjection projection : projections) {
            Assert.assertNotNull((Object)projection);
        }
    }

    private double cot(double x) {
        return Math.cos(x) / Math.sin(x);
    }

    private double coth(double x) {
        return Math.cosh(x) / Math.sinh(x);
    }

    @Test
    public void count_with_pK() {
        Assert.assertEquals((long)10L, (long)((SQLQuery)this.query().from((Expression)Constants.employee)).fetchCount());
    }

    @Test
    public void count_without_pK() {
        Assert.assertEquals((long)10L, (long)((SQLQuery)this.query().from((Expression)QEmployeeNoPK.employee)).fetchCount());
    }

    @Test
    public void count2() {
        Assert.assertEquals((long)10L, (long)((Long)((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.count()).fetchFirst()).intValue());
    }

    @Test
    @SkipForQuoted
    @ExcludeIn(value={Target.ORACLE})
    public void count_all() {
        this.expectedQuery = "select count(*) as rc from EMPLOYEE e";
        NumberPath rowCount = Expressions.numberPath(Long.class, (String)"rc");
        Assert.assertEquals((long)10L, (long)((Long)((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Wildcard.count.as((Path)rowCount)).fetchOne()).intValue());
    }

    @Test
    @SkipForQuoted
    @IncludeIn(value={Target.ORACLE})
    public void count_all_Oracle() {
        this.expectedQuery = "select count(*) rc from EMPLOYEE e";
        NumberPath rowCount = Expressions.numberPath(Long.class, (String)"rc");
        Assert.assertEquals((long)10L, (long)((Long)((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Wildcard.count.as((Path)rowCount)).fetchOne()).intValue());
    }

    @Test
    public void count_distinct_with_pK() {
        Assert.assertEquals((long)10L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).distinct()).fetchCount());
    }

    @Test
    public void count_distinct_without_pK() {
        Assert.assertEquals((long)10L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)QEmployeeNoPK.employee)).distinct()).fetchCount());
    }

    @Test
    public void count_distinct2() {
        ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.countDistinct()).fetchFirst();
    }

    @Test
    public void custom_projection() {
        List tuples = ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)new QProjection(new Expression[]{Constants.employee.firstname, Constants.employee.lastname})).fetch();
        Assert.assertFalse((boolean)tuples.isEmpty());
        for (Projection tuple : tuples) {
            Assert.assertNotNull(tuple.get(Constants.employee.firstname));
            Assert.assertNotNull(tuple.get(Constants.employee.lastname));
            Assert.assertNotNull(tuple.getExpr(Constants.employee.firstname));
            Assert.assertNotNull(tuple.getExpr(Constants.employee.lastname));
        }
    }

    @Test
    @ExcludeIn(value={Target.CUBRID, Target.DB2, Target.DERBY, Target.HSQLDB, Target.POSTGRESQL, Target.SQLITE, Target.TERADATA})
    public void dates() throws SQLException {
        if (!this.configuration.getUseLiterals()) {
            this.dates(false);
        }
    }

    @Test
    @ExcludeIn(value={Target.CUBRID, Target.DB2, Target.DERBY, Target.SQLITE, Target.TERADATA})
    public void dates_literals() throws SQLException {
        if (this.configuration.getUseLiterals()) {
            this.dates(true);
        }
    }

    private void dates(boolean literals) throws SQLException {
        boolean supportsTimeZones;
        long ts = (long)Math.floor(System.currentTimeMillis() / 1000L) * 1000L;
        long tsDate = new org.joda.time.LocalDate(ts).toDateMidnight().getMillis();
        long tsTime = new LocalTime(ts).getMillisOfDay();
        ArrayList<Comparable<Date>> data = new ArrayList<Comparable<Date>>();
        data.add(Constants.date);
        data.add(Constants.time);
        data.add(new Date(ts));
        data.add(new Date(tsDate));
        data.add(new Date(tsTime));
        data.add(new Timestamp(ts));
        data.add(new Timestamp(tsDate));
        data.add(new java.sql.Date(110, 0, 1));
        data.add(new java.sql.Date(tsDate));
        data.add(new Time(0, 0, 0));
        data.add(new Time(12, 30, 0));
        data.add(new Time(23, 59, 59));
        data.add((Comparable<Date>)new DateTime(ts));
        data.add((Comparable<Date>)new DateTime(tsDate));
        data.add((Comparable<Date>)new DateTime(tsTime));
        data.add((Comparable<Date>)new LocalDateTime(ts));
        data.add((Comparable<Date>)new LocalDateTime(tsDate));
        data.add((Comparable<Date>)new LocalDateTime(2014, 3, 30, 2, 0));
        data.add((Comparable<Date>)new org.joda.time.LocalDate(2010, 1, 1));
        data.add((Comparable<Date>)new org.joda.time.LocalDate(ts));
        data.add((Comparable<Date>)new org.joda.time.LocalDate(tsDate));
        data.add((Comparable<Date>)new LocalTime(0, 0, 0));
        data.add((Comparable<Date>)new LocalTime(12, 30, 0));
        data.add((Comparable<Date>)new LocalTime(23, 59, 59));
        data.add((Comparable<Date>)new LocalTime(ts));
        data.add((Comparable<Date>)new LocalTime(tsTime));
        Instant javaInstant = Instant.now().truncatedTo(ChronoUnit.SECONDS);
        java.time.LocalDateTime javaDateTime = java.time.LocalDateTime.ofInstant(javaInstant, ZoneId.of("Z"));
        LocalDate javaDate = javaDateTime.toLocalDate();
        java.time.LocalTime javaTime = javaDateTime.toLocalTime();
        data.add(javaInstant);
        data.add(javaDateTime);
        data.add(javaDate);
        data.add(javaTime);
        switch (this.target) {
            case FIREBIRD: 
            case H2: 
            case HSQLDB: 
            case ORACLE: 
            case SQLSERVER: {
                supportsTimeZones = true;
                break;
            }
            default: {
                supportsTimeZones = false;
            }
        }
        if (supportsTimeZones) {
            if (this.target != Target.SQLSERVER && this.target != Target.H2) {
                data.add(javaTime.atOffset(ZoneOffset.UTC));
                data.add(javaTime.atOffset(ZoneOffset.ofHours(-6)));
            }
            data.add(javaDateTime.atOffset(ZoneOffset.UTC));
            data.add(javaDateTime.atOffset(ZoneOffset.ofHours(-6)));
            if (this.target == Target.ORACLE) {
                data.add(javaDateTime.atZone(ZoneId.of("UTC")));
                data.add(javaDateTime.atZone(ZoneId.of("America/Chicago")));
            }
        }
        IdentityHashMap failures = new IdentityHashMap();
        for (Object e : data) {
            try {
                Object dt2 = this.firstResult((Expression<T>)Expressions.constant(e));
                if (e.equals(dt2)) continue;
                failures.put(e, dt2);
            }
            catch (Exception e2) {
                throw new RuntimeException("Error executing query for " + e.getClass().getName() + " " + e, e2);
            }
        }
        if (!failures.isEmpty()) {
            for (Map.Entry entry : failures.entrySet()) {
                System.out.println(entry.getKey().getClass().getName() + ": " + entry.getKey() + " != " + entry.getValue());
            }
            Assert.fail((String)("Failed with " + failures));
        }
    }

    @Test
    @ExcludeIn(value={Target.SQLITE})
    public void date_add() {
        SQLQuery query = (SQLQuery)this.query().from((Expression)Constants.employee);
        java.sql.Date date1 = (java.sql.Date)query.select(Constants.employee.datefield).fetchFirst();
        java.sql.Date date2 = (java.sql.Date)query.select((Expression)SQLExpressions.addYears(Constants.employee.datefield, (int)1)).fetchFirst();
        java.sql.Date date3 = (java.sql.Date)query.select((Expression)SQLExpressions.addMonths(Constants.employee.datefield, (int)1)).fetchFirst();
        java.sql.Date date4 = (java.sql.Date)query.select((Expression)SQLExpressions.addDays(Constants.employee.datefield, (int)1)).fetchFirst();
        Assert.assertTrue((date2.getTime() > date1.getTime() ? 1 : 0) != 0);
        Assert.assertTrue((date3.getTime() > date1.getTime() ? 1 : 0) != 0);
        Assert.assertTrue((date4.getTime() > date1.getTime() ? 1 : 0) != 0);
    }

    @Test
    @ExcludeIn(value={Target.SQLITE})
    public void date_add_Timestamp() {
        ArrayList exprs = new ArrayList();
        DateTimeExpression dt = Expressions.currentTimestamp();
        this.add(exprs, SQLExpressions.addYears((DateTimeExpression)dt, (int)1), new Target[0]);
        this.add(exprs, SQLExpressions.addMonths((DateTimeExpression)dt, (int)1), Target.ORACLE);
        this.add(exprs, SQLExpressions.addDays((DateTimeExpression)dt, (int)1), new Target[0]);
        this.add(exprs, SQLExpressions.addHours((DateTimeExpression)dt, (int)1), Target.TERADATA);
        this.add(exprs, SQLExpressions.addMinutes((DateTimeExpression)dt, (int)1), Target.TERADATA);
        this.add(exprs, SQLExpressions.addSeconds((DateTimeExpression)dt, (int)1), Target.TERADATA);
        for (Expression expr : exprs) {
            Assert.assertNotNull(this.firstResult((Expression<T>)expr));
        }
    }

    @Test
    @ExcludeIn(value={Target.DB2, Target.SQLITE, Target.TERADATA})
    public void date_diff() {
        QEmployee employee2 = new QEmployee("employee2");
        SQLQuery query = (SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).orderBy(Constants.employee.id.asc());
        SQLQuery query2 = (SQLQuery)((SQLQuery)this.query().from(new Expression[]{Constants.employee, employee2})).orderBy(new OrderSpecifier[]{Constants.employee.id.asc(), employee2.id.desc()});
        ArrayList dps = new ArrayList();
        this.add(dps, DatePart.year, new Target[0]);
        this.add(dps, DatePart.month, new Target[0]);
        this.add(dps, DatePart.week, new Target[0]);
        this.add(dps, DatePart.day, new Target[0]);
        this.add(dps, DatePart.hour, Target.HSQLDB);
        this.add(dps, DatePart.minute, Target.HSQLDB);
        this.add(dps, DatePart.second, Target.HSQLDB);
        org.joda.time.LocalDate localDate = new org.joda.time.LocalDate(1970, 1, 10);
        java.sql.Date date = new java.sql.Date(localDate.toDateMidnight().getMillis());
        for (DatePart dp : dps) {
            int diff1 = (Integer)query.select((Expression)SQLExpressions.datediff((DatePart)dp, (Comparable)date, Constants.employee.datefield)).fetchFirst();
            int diff2 = (Integer)query.select((Expression)SQLExpressions.datediff((DatePart)dp, Constants.employee.datefield, (Comparable)date)).fetchFirst();
            int diff3 = (Integer)query2.select((Expression)SQLExpressions.datediff((DatePart)dp, Constants.employee.datefield, employee2.datefield)).fetchFirst();
            Assert.assertEquals((long)diff1, (long)(-diff2));
        }
        Timestamp timestamp = new Timestamp(new Date().getTime());
        for (DatePart dp : dps) {
            query.select((Expression)SQLExpressions.datediff((DatePart)dp, (DateTimeExpression)Expressions.currentTimestamp(), (Comparable)timestamp)).fetchOne();
        }
    }

    @Test
    @ExcludeIn(value={Target.DB2, Target.HSQLDB, Target.SQLITE, Target.TERADATA})
    public void date_diff2() {
        SQLQuery query = (SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).orderBy(Constants.employee.id.asc());
        org.joda.time.LocalDate localDate = new org.joda.time.LocalDate(1970, 1, 10);
        java.sql.Date date = new java.sql.Date(localDate.toDateMidnight().getMillis());
        int years = (Integer)query.select((Expression)SQLExpressions.datediff((DatePart)DatePart.year, (Comparable)date, Constants.employee.datefield)).fetchFirst();
        int months = (Integer)query.select((Expression)SQLExpressions.datediff((DatePart)DatePart.month, (Comparable)date, Constants.employee.datefield)).fetchFirst();
        int days = (Integer)query.select((Expression)SQLExpressions.datediff((DatePart)DatePart.day, (Comparable)date, Constants.employee.datefield)).fetchFirst();
        int hours = (Integer)query.select((Expression)SQLExpressions.datediff((DatePart)DatePart.hour, (Comparable)date, Constants.employee.datefield)).fetchFirst();
        int minutes = (Integer)query.select((Expression)SQLExpressions.datediff((DatePart)DatePart.minute, (Comparable)date, Constants.employee.datefield)).fetchFirst();
        int seconds = (Integer)query.select((Expression)SQLExpressions.datediff((DatePart)DatePart.second, (Comparable)date, Constants.employee.datefield)).fetchFirst();
        Assert.assertEquals((long)949363200L, (long)seconds);
        Assert.assertEquals((long)15822720L, (long)minutes);
        Assert.assertEquals((long)263712L, (long)hours);
        Assert.assertEquals((long)10988L, (long)days);
        Assert.assertEquals((long)361L, (long)months);
        Assert.assertEquals((long)30L, (long)years);
    }

    @Test
    @ExcludeIn(value={Target.SQLITE})
    public void date_trunc() {
        DateTimeExpression expr = DateTimeExpression.currentTimestamp();
        ArrayList dps = new ArrayList();
        this.add(dps, DatePart.year, new Target[0]);
        this.add(dps, DatePart.month, new Target[0]);
        this.add(dps, DatePart.week, Target.DERBY, Target.FIREBIRD, Target.SQLSERVER);
        this.add(dps, DatePart.day, new Target[0]);
        this.add(dps, DatePart.hour, new Target[0]);
        this.add(dps, DatePart.minute, new Target[0]);
        this.add(dps, DatePart.second, new Target[0]);
        for (DatePart dp : dps) {
            this.firstResult((Expression<T>)((Expression)SQLExpressions.datetrunc((DatePart)dp, (DateTimeExpression)expr)));
        }
    }

    @Test
    @ExcludeIn(value={Target.SQLITE, Target.TERADATA})
    public void date_trunc2() {
        DateTimeExpression expr = DateTimeExpression.currentTimestamp(DateTime.class);
        Tuple tuple = this.firstResult(new Expression[]{expr, SQLExpressions.datetrunc((DatePart)DatePart.year, (DateTimeExpression)expr), SQLExpressions.datetrunc((DatePart)DatePart.month, (DateTimeExpression)expr), SQLExpressions.datetrunc((DatePart)DatePart.day, (DateTimeExpression)expr), SQLExpressions.datetrunc((DatePart)DatePart.hour, (DateTimeExpression)expr), SQLExpressions.datetrunc((DatePart)DatePart.minute, (DateTimeExpression)expr), SQLExpressions.datetrunc((DatePart)DatePart.second, (DateTimeExpression)expr)});
        DateTime date = (DateTime)tuple.get((Expression)expr);
        DateTime toYear = (DateTime)tuple.get((Expression)SQLExpressions.datetrunc((DatePart)DatePart.year, (DateTimeExpression)expr));
        DateTime toMonth = (DateTime)tuple.get((Expression)SQLExpressions.datetrunc((DatePart)DatePart.month, (DateTimeExpression)expr));
        DateTime toDay = (DateTime)tuple.get((Expression)SQLExpressions.datetrunc((DatePart)DatePart.day, (DateTimeExpression)expr));
        DateTime toHour = (DateTime)tuple.get((Expression)SQLExpressions.datetrunc((DatePart)DatePart.hour, (DateTimeExpression)expr));
        DateTime toMinute = (DateTime)tuple.get((Expression)SQLExpressions.datetrunc((DatePart)DatePart.minute, (DateTimeExpression)expr));
        DateTime toSecond = (DateTime)tuple.get((Expression)SQLExpressions.datetrunc((DatePart)DatePart.second, (DateTimeExpression)expr));
        Assert.assertEquals((Object)date.getZone(), (Object)toYear.getZone());
        Assert.assertEquals((Object)date.getZone(), (Object)toMonth.getZone());
        Assert.assertEquals((Object)date.getZone(), (Object)toDay.getZone());
        Assert.assertEquals((Object)date.getZone(), (Object)toHour.getZone());
        Assert.assertEquals((Object)date.getZone(), (Object)toMinute.getZone());
        Assert.assertEquals((Object)date.getZone(), (Object)toSecond.getZone());
        Assert.assertEquals((long)date.getYear(), (long)toYear.getYear());
        Assert.assertEquals((long)date.getYear(), (long)toMonth.getYear());
        Assert.assertEquals((long)date.getYear(), (long)toDay.getYear());
        Assert.assertEquals((long)date.getYear(), (long)toHour.getYear());
        Assert.assertEquals((long)date.getYear(), (long)toMinute.getYear());
        Assert.assertEquals((long)date.getYear(), (long)toSecond.getYear());
        Assert.assertEquals((long)1L, (long)toYear.getMonthOfYear());
        Assert.assertEquals((long)date.getMonthOfYear(), (long)toMonth.getMonthOfYear());
        Assert.assertEquals((long)date.getMonthOfYear(), (long)toDay.getMonthOfYear());
        Assert.assertEquals((long)date.getMonthOfYear(), (long)toHour.getMonthOfYear());
        Assert.assertEquals((long)date.getMonthOfYear(), (long)toMinute.getMonthOfYear());
        Assert.assertEquals((long)date.getMonthOfYear(), (long)toSecond.getMonthOfYear());
        Assert.assertEquals((long)1L, (long)toYear.getDayOfMonth());
        Assert.assertEquals((long)1L, (long)toMonth.getDayOfMonth());
        Assert.assertEquals((long)date.getDayOfMonth(), (long)toDay.getDayOfMonth());
        Assert.assertEquals((long)date.getDayOfMonth(), (long)toHour.getDayOfMonth());
        Assert.assertEquals((long)date.getDayOfMonth(), (long)toMinute.getDayOfMonth());
        Assert.assertEquals((long)date.getDayOfMonth(), (long)toSecond.getDayOfMonth());
        Assert.assertEquals((long)0L, (long)toYear.getHourOfDay());
        Assert.assertEquals((long)0L, (long)toMonth.getHourOfDay());
        Assert.assertEquals((long)0L, (long)toDay.getHourOfDay());
        Assert.assertEquals((long)date.getHourOfDay(), (long)toHour.getHourOfDay());
        Assert.assertEquals((long)date.getHourOfDay(), (long)toMinute.getHourOfDay());
        Assert.assertEquals((long)date.getHourOfDay(), (long)toSecond.getHourOfDay());
        Assert.assertEquals((long)0L, (long)toYear.getMinuteOfHour());
        Assert.assertEquals((long)0L, (long)toMonth.getMinuteOfHour());
        Assert.assertEquals((long)0L, (long)toDay.getMinuteOfHour());
        Assert.assertEquals((long)0L, (long)toHour.getMinuteOfHour());
        Assert.assertEquals((long)date.getMinuteOfHour(), (long)toMinute.getMinuteOfHour());
        Assert.assertEquals((long)date.getMinuteOfHour(), (long)toSecond.getMinuteOfHour());
        Assert.assertEquals((long)0L, (long)toYear.getSecondOfMinute());
        Assert.assertEquals((long)0L, (long)toMonth.getSecondOfMinute());
        Assert.assertEquals((long)0L, (long)toDay.getSecondOfMinute());
        Assert.assertEquals((long)0L, (long)toHour.getSecondOfMinute());
        Assert.assertEquals((long)0L, (long)toMinute.getSecondOfMinute());
        Assert.assertEquals((long)date.getSecondOfMinute(), (long)toSecond.getSecondOfMinute());
    }

    @Test
    public void dateTime() {
        SQLQuery query = (SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).orderBy(Constants.employee.id.asc());
        Assert.assertEquals((Object)10, (Object)query.select((Expression)Constants.employee.datefield.dayOfMonth()).fetchFirst());
        Assert.assertEquals((Object)2, (Object)query.select((Expression)Constants.employee.datefield.month()).fetchFirst());
        Assert.assertEquals((Object)2000, (Object)query.select((Expression)Constants.employee.datefield.year()).fetchFirst());
        Assert.assertEquals((Object)200002, (Object)query.select((Expression)Constants.employee.datefield.yearMonth()).fetchFirst());
    }

    @Test
    @ExcludeIn(value={Target.SQLITE})
    public void dateTime_to_date() {
        this.firstResult((Expression<T>)((Expression)SQLExpressions.date((DateTimeExpression)DateTimeExpression.currentTimestamp())));
    }

    private double degrees(double x) {
        return x * 180.0 / Math.PI;
    }

    @Test
    public void distinct_count() {
        long count1 = ((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).distinct()).fetchCount();
        long count2 = ((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).distinct()).fetchCount();
        Assert.assertEquals((long)count1, (long)count2);
    }

    @Test
    public void distinct_list() {
        List lengths1 = ((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).distinct()).select((Expression)Constants.employee.firstname.length()).fetch();
        List lengths2 = ((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).distinct()).select((Expression)Constants.employee.firstname.length()).fetch();
        Assert.assertEquals((Object)lengths1, (Object)lengths2);
    }

    @Test
    public void duplicate_columns() {
        Assert.assertEquals((long)10L, (long)((SQLQuery)this.query().from((Expression)Constants.employee)).select(new Expression[]{Constants.employee.id, Constants.employee.id}).fetch().size());
    }

    @Test
    public void duplicate_columns_In_Subquery() {
        QEmployee employee2 = new QEmployee("e2");
        Assert.assertEquals((long)10L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)((SQLQuery)((SQLQuery)this.query().from((Expression)employee2)).where((Predicate)employee2.id.eq(Constants.employee.id))).select(new Expression[]{employee2.id, employee2.id}).exists())).fetchCount());
    }

    @Test
    public void factoryExpression_in_groupBy() {
        QBean empBean = Projections.bean(Employee.class, (Expression[])new Expression[]{Constants.employee.id, Constants.employee.superiorId});
        Assert.assertTrue((((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).groupBy((Expression)empBean)).select((Expression)empBean).fetchFirst() != null ? 1 : 0) != 0);
    }

    @Test
    @ExcludeIn(value={Target.H2, Target.SQLITE, Target.DERBY, Target.CUBRID, Target.MYSQL})
    public void full_join() throws SQLException {
        Assert.assertEquals((long)18L, (long)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).fullJoin((EntityPath)Constants.employee2)).on(Constants.employee.superiorIdKey.on((RelationalPath)Constants.employee2))).select(new Expression[]{Constants.employee.id, Constants.employee2.id}).fetch().size());
    }

    @Test
    public void getResultSet() throws IOException, SQLException {
        ResultSet results = ((SQLQuery)this.query().select(new Expression[]{Constants.survey.id, Constants.survey.name}).from((Expression)Constants.survey)).getResults();
        while (results.next()) {
            Assert.assertNotNull((Object)results.getObject(1));
            Assert.assertNotNull((Object)results.getObject(2));
        }
        results.close();
    }

    @Test
    public void groupBy_superior() {
        SQLQuery qry = (SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).innerJoin(Constants.employee._superiorIdKey, (RelationalPath)Constants.employee2);
        QTuple subordinates = Projections.tuple((Expression[])new Expression[]{Constants.employee2.id, Constants.employee2.firstname, Constants.employee2.lastname});
        Map results = (Map)qry.transform(GroupBy.groupBy(Constants.employee.id).as(new Expression[]{Constants.employee.firstname, Constants.employee.lastname, GroupBy.map(Constants.employee2.id, (Expression)subordinates)}));
        Assert.assertEquals((long)2L, (long)results.size());
        Group group = (Group)results.get(1);
        Assert.assertEquals((Object)"Mike", (Object)group.getOne((Expression)Constants.employee.firstname));
        Assert.assertEquals((Object)"Smith", (Object)group.getOne((Expression)Constants.employee.lastname));
        Map emps = group.getMap(Constants.employee2.id, (Expression)subordinates);
        Assert.assertEquals((long)4L, (long)emps.size());
        Assert.assertEquals((Object)"Steve", (Object)((Tuple)emps.get(12)).get((Expression)Constants.employee2.firstname));
        group = (Group)results.get(2);
        Assert.assertEquals((Object)"Mary", (Object)group.getOne((Expression)Constants.employee.firstname));
        Assert.assertEquals((Object)"Smith", (Object)group.getOne((Expression)Constants.employee.lastname));
        emps = group.getMap(Constants.employee2.id, (Expression)subordinates);
        Assert.assertEquals((long)4L, (long)emps.size());
        Assert.assertEquals((Object)"Mason", (Object)((Tuple)emps.get(21)).get((Expression)Constants.employee2.lastname));
    }

    @Test
    public void groupBy_yearMonth() {
        Assert.assertEquals(Collections.singletonList(10L), (Object)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).groupBy((Expression)Constants.employee.datefield.yearMonth())).orderBy(Constants.employee.datefield.yearMonth().asc())).select((Expression)Constants.employee.id.count()).fetch());
    }

    @Test
    @ExcludeIn(value={Target.H2, Target.DB2, Target.DERBY, Target.ORACLE, Target.SQLSERVER})
    public void groupBy_validate() {
        NumberPath alias = Expressions.numberPath(BigDecimal.class, (String)"alias");
        Assert.assertEquals((long)8L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).groupBy((Expression)alias)).select(new Expression[]{Constants.employee.salary.multiply((Number)100).as((Path)alias), Constants.employee.salary.avg()}).fetch().size());
    }

    @Test
    @ExcludeIn(value={Target.FIREBIRD})
    public void groupBy_count() {
        List ids = ((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).groupBy(Constants.employee.id)).select(Constants.employee.id).fetch();
        long count = ((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).groupBy(Constants.employee.id)).fetchCount();
        QueryResults results = ((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).groupBy(Constants.employee.id)).limit(1L)).select(Constants.employee.id).fetchResults();
        Assert.assertEquals((long)10L, (long)ids.size());
        Assert.assertEquals((long)10L, (long)count);
        Assert.assertEquals((long)1L, (long)results.getResults().size());
        Assert.assertEquals((long)10L, (long)results.getTotal());
    }

    @Test
    @ExcludeIn(value={Target.FIREBIRD, Target.SQLSERVER, Target.TERADATA})
    public void groupBy_Distinct_count() {
        List ids = ((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).groupBy(Constants.employee.id)).distinct()).select((Expression)Expressions.ONE).fetch();
        QueryResults results = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).groupBy(Constants.employee.id)).limit(1L)).distinct()).select((Expression)Expressions.ONE).fetchResults();
        Assert.assertEquals((long)1L, (long)ids.size());
        Assert.assertEquals((long)1L, (long)results.getResults().size());
        Assert.assertEquals((long)1L, (long)results.getTotal());
    }

    @Test
    @ExcludeIn(value={Target.FIREBIRD})
    public void having_count() {
        ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).innerJoin((EntityPath)Constants.employee2)).on((Predicate)Constants.employee.id.eq(Constants.employee2.id))).groupBy(Constants.employee.id)).having((Predicate)Wildcard.count.eq((Object)4L))).select(new Expression[]{Constants.employee.id, Constants.employee.firstname}).fetchResults();
    }

    @Test(expected=IllegalArgumentException.class)
    public void illegalUnion() throws SQLException {
        SQLQuery sq1 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.id.max());
        SQLQuery sq2 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.id.max());
        Assert.assertEquals((long)0L, (long)((SQLQuery)this.query().from((Expression)Constants.employee)).union(new SubQueryExpression[]{sq1, sq2}).list().size());
    }

    @Test
    public void in() {
        Assert.assertEquals((long)2L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.id.in(Arrays.asList(1, 2)))).select((Expression)Constants.employee).fetch().size());
    }

    @Test
    @ExcludeIn(value={Target.DERBY, Target.FIREBIRD, Target.SQLITE, Target.SQLSERVER, Target.TERADATA})
    public void in_long_list() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (int i = 0; i < 20000; ++i) {
            ids.add(i);
        }
        Assert.assertEquals((long)((SQLQuery)this.query().from((Expression)Constants.employee)).fetchCount(), (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.id.in(ids))).fetchCount());
    }

    @Test
    @ExcludeIn(value={Target.DERBY, Target.FIREBIRD, Target.SQLITE, Target.SQLSERVER, Target.TERADATA})
    public void notIn_long_list() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (int i = 0; i < 20000; ++i) {
            ids.add(i);
        }
        Assert.assertEquals((long)0L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.id.notIn(ids))).fetchCount());
    }

    @Test
    public void in_empty() {
        Assert.assertEquals((long)0L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.id.in(Collections.emptyList()))).fetchCount());
    }

    @Test
    @ExcludeIn(value={Target.DERBY})
    public void in_null() {
        Assert.assertEquals((long)1L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.id.in((Object[])new Integer[]{1, null}))).fetchCount());
    }

    @Test
    @ExcludeIn(value={Target.MYSQL, Target.TERADATA})
    public void in_subqueries() {
        QEmployee e1 = new QEmployee("e1");
        QEmployee e2 = new QEmployee("e2");
        Assert.assertEquals((long)2L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.id.in(new Expression[]{((SQLQuery)((SQLQuery)this.query().from((Expression)e1)).where((Predicate)e1.firstname.eq((Object)"Mike"))).select(e1.id), ((SQLQuery)((SQLQuery)this.query().from((Expression)e2)).where((Predicate)e2.firstname.eq((Object)"Mary"))).select(e2.id)}))).fetchCount());
    }

    @Test
    public void notIn_empty() {
        long count = ((SQLQuery)this.query().from((Expression)Constants.employee)).fetchCount();
        Assert.assertEquals((long)count, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.id.notIn(Collections.emptyList()))).fetchCount());
    }

    @Test
    public void inner_join() throws SQLException {
        Assert.assertEquals((long)8L, (long)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).innerJoin((EntityPath)Constants.employee2)).on(Constants.employee.superiorIdKey.on((RelationalPath)Constants.employee2))).select(new Expression[]{Constants.employee.id, Constants.employee2.id}).fetch().size());
    }

    @Test
    public void inner_join_2Conditions() {
        Assert.assertEquals((long)8L, (long)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).innerJoin((EntityPath)Constants.employee2)).on(Constants.employee.superiorIdKey.on((RelationalPath)Constants.employee2))).on((Predicate)Constants.employee2.firstname.isNotNull())).select(new Expression[]{Constants.employee.id, Constants.employee2.id}).fetch().size());
    }

    @Test
    public void join() throws Exception {
        for (String name : ((SQLQuery)((SQLQuery)this.query().from(new Expression[]{Constants.survey, Constants.survey2})).where((Predicate)Constants.survey.id.eq(Constants.survey2.id))).select((Expression)Constants.survey.name).fetch()) {
            Assert.assertNotNull((Object)name);
        }
    }

    @Test
    public void joins() throws SQLException {
        for (Tuple row : ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).innerJoin((EntityPath)Constants.employee2)).on((Predicate)Constants.employee.superiorId.eq(Constants.employee2.superiorId))).where((Predicate)Constants.employee2.id.eq((Object)10))).select(new Expression[]{Constants.employee.id, Constants.employee2.id}).fetch()) {
            Assert.assertNotNull((Object)row.get(Constants.employee.id));
            Assert.assertNotNull((Object)row.get(Constants.employee2.id));
        }
    }

    @Test
    public void left_join() throws SQLException {
        Assert.assertEquals((long)10L, (long)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).leftJoin((EntityPath)Constants.employee2)).on(Constants.employee.superiorIdKey.on((RelationalPath)Constants.employee2))).select(new Expression[]{Constants.employee.id, Constants.employee2.id}).fetch().size());
    }

    @Test
    public void like() {
        Assert.assertEquals((long)0L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.firstname.like("\\"))).fetchCount());
        Assert.assertEquals((long)0L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.firstname.like("\\\\"))).fetchCount());
    }

    @Test
    public void like_ignore_case() {
        Assert.assertEquals((long)3L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.firstname.likeIgnoreCase("%m%"))).fetchCount());
    }

    @Test
    @ExcludeIn(value={Target.FIREBIRD})
    public void like_escape() {
        List<String> strs = Arrays.asList("%a", "a%", "%a%", "_a", "a_", "_a_", "[C-P]arsen", "a\nb");
        for (String str : strs) {
            Assert.assertTrue((String)str, (((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Expressions.predicate((Operator)Ops.STRING_CONTAINS, (Expression[])new Expression[]{Expressions.constant((Object)str), Expressions.constant((Object)str)}))).fetchCount() > 0L ? 1 : 0) != 0);
        }
    }

    @Test
    @ExcludeIn(value={Target.DB2, Target.DERBY})
    public void like_number() {
        Assert.assertEquals((long)5L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.id.like("1%"))).fetchCount());
    }

    @Test
    public void limit() throws SQLException {
        Assert.assertEquals(Arrays.asList(23, 22, 21, 20), (Object)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).orderBy(Constants.employee.firstname.asc())).limit(4L)).select(Constants.employee.id).fetch());
    }

    @Test
    public void limit_and_offset() throws SQLException {
        Assert.assertEquals(Arrays.asList(20, 13, 10, 2), (Object)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).orderBy(Constants.employee.firstname.asc())).limit(4L)).offset(3L)).select(Constants.employee.id).fetch());
    }

    @Test
    public void limit_and_offset_Group() {
        Assert.assertEquals((long)9L, (long)((Map)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).orderBy(Constants.employee.id.asc())).limit(100L)).offset(1L)).transform(GroupBy.groupBy(Constants.employee.id).as((Expression)Constants.employee))).size());
    }

    @Test
    public void limit_and_offset_and_Order() {
        List<String> names2 = Arrays.asList("Helen", "Jennifer", "Jim", "Joe");
        Assert.assertEquals(names2, (Object)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).orderBy(Constants.employee.firstname.asc())).limit(4L)).offset(2L)).select((Expression)Constants.employee.firstname).fetch());
    }

    @Test
    @IncludeIn(value={Target.DERBY})
    public void limit_and_offset_In_Derby() throws SQLException {
        this.expectedQuery = "select e.ID from EMPLOYEE e offset 3 rows fetch next 4 rows only";
        ((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).limit(4L)).offset(3L)).select(Constants.employee.id).fetch();
        this.expectedQuery = "select e.ID from EMPLOYEE e fetch first 4 rows only";
        ((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).limit(4L)).select(Constants.employee.id).fetch();
        this.expectedQuery = "select e.ID from EMPLOYEE e offset 3 rows";
        ((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).offset(3L)).select(Constants.employee.id).fetch();
    }

    @Test
    @IncludeIn(value={Target.ORACLE})
    @SkipForQuoted
    public void limit_and_offset_In_Oracle() throws SQLException {
        if (this.configuration.getUseLiterals()) {
            return;
        }
        this.expectedQuery = "select * from (   select e.ID from EMPLOYEE e ) where rownum <= ?";
        ((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).limit(4L)).select(Constants.employee.id).fetch();
        this.expectedQuery = "select * from (  select a.*, rownum rn from (   select e.ID from EMPLOYEE e  ) a) where rn > ?";
        ((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).offset(3L)).select(Constants.employee.id).fetch();
        this.expectedQuery = "select * from (  select a.*, rownum rn from (   select e.ID from EMPLOYEE e  ) a) where rn > 3 and rownum <= 4";
        ((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).limit(4L)).offset(3L)).select(Constants.employee.id).fetch();
    }

    @Test
    @ExcludeIn(value={Target.ORACLE, Target.DB2, Target.DERBY, Target.FIREBIRD, Target.SQLSERVER, Target.CUBRID, Target.TERADATA})
    @SkipForQuoted
    public void limit_and_offset2() throws SQLException {
        this.expectedQuery = "select e.ID from EMPLOYEE e limit ?";
        ((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).limit(4L)).select(Constants.employee.id).fetch();
        this.expectedQuery = "select e.ID from EMPLOYEE e limit ? offset ?";
        ((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).limit(4L)).offset(3L)).select(Constants.employee.id).fetch();
    }

    @Test
    public void limit_and_order() {
        List<String> names1 = Arrays.asList("Barbara", "Daisy", "Helen", "Jennifer");
        Assert.assertEquals(names1, (Object)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).orderBy(Constants.employee.firstname.asc())).limit(4L)).select((Expression)Constants.employee.firstname).fetch());
    }

    @Test
    public void listResults() {
        QueryResults results = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).limit(10L)).offset(1L)).orderBy(Constants.employee.id.asc())).select(Constants.employee.id).fetchResults();
        Assert.assertEquals((long)10L, (long)results.getTotal());
    }

    @Test
    public void listResults2() {
        QueryResults results = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).limit(2L)).offset(10L)).orderBy(Constants.employee.id.asc())).select(Constants.employee.id).fetchResults();
        Assert.assertEquals((long)10L, (long)results.getTotal());
    }

    @Test
    public void listResults_factoryExpression() {
        QueryResults results = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).limit(10L)).offset(1L)).orderBy(Constants.employee.id.asc())).select((Expression)Constants.employee).fetchResults();
        Assert.assertEquals((long)10L, (long)results.getTotal());
    }

    @Test
    @ExcludeIn(value={Target.DB2, Target.DERBY})
    public void literals() {
        Assert.assertEquals((long)1L, (long)((Integer)this.firstResult((Expression<T>)((Expression)ConstantImpl.create((int)1)))).intValue());
        Assert.assertEquals((long)2L, (long)((Long)this.firstResult((Expression<T>)((Expression)ConstantImpl.create((long)2L)))));
        Assert.assertEquals((double)3.0, (double)((Double)this.firstResult((Expression<T>)((Expression)ConstantImpl.create((Object)3.0)))), (double)0.001);
        Assert.assertEquals((double)4.0, (double)((Float)this.firstResult((Expression<T>)((Expression)ConstantImpl.create((Object)Float.valueOf(4.0f))))).floatValue(), (double)0.001);
        Assert.assertEquals((Object)true, this.firstResult((Expression<T>)((Expression)ConstantImpl.create((boolean)true))));
        Assert.assertEquals((Object)false, this.firstResult((Expression<T>)((Expression)ConstantImpl.create((boolean)false))));
        Assert.assertEquals((Object)"abc", this.firstResult((Expression<T>)((Expression)ConstantImpl.create((Object)"abc"))));
        Assert.assertEquals((Object)"'", this.firstResult((Expression<T>)((Expression)ConstantImpl.create((Object)"'"))));
        Assert.assertEquals((Object)"\"", this.firstResult((Expression<T>)((Expression)ConstantImpl.create((Object)"\""))));
        Assert.assertEquals((Object)"\n", this.firstResult((Expression<T>)((Expression)ConstantImpl.create((Object)"\n"))));
        Assert.assertEquals((Object)"\r\n", this.firstResult((Expression<T>)((Expression)ConstantImpl.create((Object)"\r\n"))));
        Assert.assertEquals((Object)"\t", this.firstResult((Expression<T>)((Expression)ConstantImpl.create((Object)"\t"))));
    }

    @Test
    public void literals_literals() {
        if (this.configuration.getUseLiterals()) {
            this.literals();
        }
    }

    private double log(double x, int y) {
        return Math.log(x) / Math.log(y);
    }

    @Test
    @ExcludeIn(value={Target.SQLITE, Target.DERBY})
    public void lPad() {
        Assert.assertEquals((Object)"  ab", this.firstResult((Expression<T>)((Expression)StringExpressions.lpad((Expression)ConstantImpl.create((Object)"ab"), (int)4))));
        Assert.assertEquals((Object)"!!ab", this.firstResult((Expression<T>)((Expression)StringExpressions.lpad((Expression)ConstantImpl.create((Object)"ab"), (int)4, (char)'!'))));
    }

    @Test
    public void mappingProjection() {
        List pairs = ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)new MappingProjection<Pair<String, String>>(Pair.class, new Expression[]{Constants.employee.firstname, Constants.employee.lastname}){

            protected Pair<String, String> map(Tuple row) {
                return Pair.of((Object)((String)row.get((Expression)Constants.employee.firstname)), (Object)((String)row.get((Expression)Constants.employee.lastname)));
            }
        }).fetch();
        for (Pair pair : pairs) {
            Assert.assertNotNull((Object)pair.getFirst());
            Assert.assertNotNull((Object)pair.getSecond());
        }
    }

    @Test
    @ExcludeIn(value={Target.HSQLDB})
    public void math() {
        this.math((Expression<Double>)Expressions.numberTemplate(Double.class, (String)"0.50", (Object[])new Object[0]));
    }

    @Test
    @ExcludeIn(value={Target.FIREBIRD, Target.SQLSERVER, Target.HSQLDB})
    public void math2() {
        this.math((Expression<Double>)Expressions.constant((Object)0.5));
    }

    private void math(Expression<Double> expr) {
        double precision = 0.001;
        Assert.assertEquals((double)Math.acos(0.5), (double)((Double)this.firstResult((Expression<T>)((Expression)MathExpressions.acos(expr)))), (double)precision);
        Assert.assertEquals((double)Math.asin(0.5), (double)((Double)this.firstResult((Expression<T>)((Expression)MathExpressions.asin(expr)))), (double)precision);
        Assert.assertEquals((double)Math.atan(0.5), (double)((Double)this.firstResult((Expression<T>)((Expression)MathExpressions.atan(expr)))), (double)precision);
        Assert.assertEquals((double)Math.cos(0.5), (double)((Double)this.firstResult((Expression<T>)((Expression)MathExpressions.cos(expr)))), (double)precision);
        Assert.assertEquals((double)Math.cosh(0.5), (double)((Double)this.firstResult((Expression<T>)((Expression)MathExpressions.cosh(expr)))), (double)precision);
        Assert.assertEquals((double)this.cot(0.5), (double)((Double)this.firstResult((Expression<T>)((Expression)MathExpressions.cot(expr)))), (double)precision);
        if (this.target != Target.DERBY || expr instanceof Constant) {
            Assert.assertEquals((double)this.coth(0.5), (double)((Double)this.firstResult((Expression<T>)((Expression)MathExpressions.coth(expr)))), (double)precision);
        }
        Assert.assertEquals((double)this.degrees(0.5), (double)((Double)this.firstResult((Expression<T>)((Expression)MathExpressions.degrees(expr)))), (double)precision);
        Assert.assertEquals((double)Math.exp(0.5), (double)((Double)this.firstResult((Expression<T>)((Expression)MathExpressions.exp(expr)))), (double)precision);
        Assert.assertEquals((double)Math.log(0.5), (double)((Double)this.firstResult((Expression<T>)((Expression)MathExpressions.ln(expr)))), (double)precision);
        Assert.assertEquals((double)this.log(0.5, 10), (double)((Double)this.firstResult((Expression<T>)((Expression)MathExpressions.log(expr, (int)10)))), (double)precision);
        Assert.assertEquals((double)0.25, (double)((Double)this.firstResult((Expression<T>)((Expression)MathExpressions.power(expr, (int)2)))), (double)precision);
        Assert.assertEquals((double)this.radians(0.5), (double)((Double)this.firstResult((Expression<T>)((Expression)MathExpressions.radians(expr)))), (double)precision);
        Assert.assertEquals((Object)1, this.firstResult((Expression<T>)((Expression)MathExpressions.sign(expr))));
        Assert.assertEquals((double)Math.sin(0.5), (double)((Double)this.firstResult((Expression<T>)((Expression)MathExpressions.sin(expr)))), (double)precision);
        Assert.assertEquals((double)Math.sinh(0.5), (double)((Double)this.firstResult((Expression<T>)((Expression)MathExpressions.sinh(expr)))), (double)precision);
        Assert.assertEquals((double)Math.tan(0.5), (double)((Double)this.firstResult((Expression<T>)((Expression)MathExpressions.tan(expr)))), (double)precision);
        Assert.assertEquals((double)Math.tanh(0.5), (double)((Double)this.firstResult((Expression<T>)((Expression)MathExpressions.tanh(expr)))), (double)precision);
    }

    @Test
    @ExcludeIn(value={Target.DERBY})
    public void math3() {
        NumberTemplate one = Expressions.numberTemplate(Double.class, (String)"1.0", (Object[])new Object[0]);
        NumberTemplate two = Expressions.numberTemplate(Double.class, (String)"2.0", (Object[])new Object[0]);
        NumberTemplate three = Expressions.numberTemplate(Double.class, (String)"3.0", (Object[])new Object[0]);
        NumberTemplate four = Expressions.numberTemplate(Double.class, (String)"4.0", (Object[])new Object[0]);
        NumberTemplate five = Expressions.numberTemplate(Double.class, (String)"5.0", (Object[])new Object[0]);
        NumberTemplate six = Expressions.numberTemplate(Double.class, (String)"6.0", (Object[])new Object[0]);
        Double num = (Double)this.query().select((Expression)one.add((Expression)two.multiply((Expression)three)).subtract((Expression)four.divide((Expression)five)).add((Expression)six.mod((Expression)three))).fetchFirst();
        Assert.assertEquals((double)6.2, (double)num, (double)0.001);
    }

    @Test
    public void nested_tuple_projection() {
        Concatenation concat = new Concatenation(new Expression[]{Constants.employee.firstname, Constants.employee.lastname});
        List tuples = ((SQLQuery)this.query().from((Expression)Constants.employee)).select(new Expression[]{Constants.employee.firstname, Constants.employee.lastname, concat}).fetch();
        Assert.assertFalse((boolean)tuples.isEmpty());
        for (Tuple tuple : tuples) {
            String firstName = (String)tuple.get((Expression)Constants.employee.firstname);
            String lastName = (String)tuple.get((Expression)Constants.employee.lastname);
            Assert.assertEquals((Object)(firstName + lastName), (Object)tuple.get((Expression)concat));
        }
    }

    @Test
    @ExcludeIn(value={Target.SQLITE})
    public void no_from() {
        Assert.assertNotNull(this.firstResult((Expression<T>)((Expression)DateExpression.currentDate())));
    }

    @Test
    public void nullif() {
        ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.firstname.nullif((Expression)Constants.employee.lastname)).fetch();
    }

    @Test
    public void nullif_constant() {
        ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.firstname.nullif("xxx")).fetch();
    }

    @Test
    public void num_cast() {
        ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.id.castToNum(Long.class)).fetch();
        ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.id.castToNum(Float.class)).fetch();
        ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.id.castToNum(Double.class)).fetch();
    }

    @Test
    public void num_cast2() {
        NumberTemplate num = Expressions.numberTemplate(Integer.class, (String)"0", (Object[])new Object[0]);
        this.firstResult((Expression<T>)((Expression)num.castToNum(Byte.class)));
        this.firstResult((Expression<T>)((Expression)num.castToNum(Short.class)));
        this.firstResult((Expression<T>)((Expression)num.castToNum(Integer.class)));
        this.firstResult((Expression<T>)((Expression)num.castToNum(Long.class)));
        this.firstResult((Expression<T>)((Expression)num.castToNum(Float.class)));
        this.firstResult((Expression<T>)((Expression)num.castToNum(Double.class)));
    }

    @Test
    public void num_date_operation() {
        long result = ((Integer)((SQLQuery)this.query().select((Expression)Constants.employee.datefield.year().mod((Number)1)).from((Expression)Constants.employee)).fetchFirst()).intValue();
        Assert.assertEquals((long)0L, (long)result);
    }

    @Test
    @ExcludeIn(value={Target.DERBY, Target.FIREBIRD, Target.POSTGRESQL})
    public void number_as_boolean() {
        QNumberTest numberTest = QNumberTest.numberTest;
        this.delete((RelationalPath<?>)numberTest).execute();
        ((SQLInsertClause)this.insert((RelationalPath<?>)numberTest).set((Path)numberTest.col1Boolean, (Object)true)).execute();
        ((SQLInsertClause)this.insert((RelationalPath<?>)numberTest).set(numberTest.col1Number, (Object)1)).execute();
        Assert.assertEquals((long)2L, (long)((SQLQuery)this.query().from((Expression)numberTest)).select((Expression)numberTest.col1Boolean).fetch().size());
        Assert.assertEquals((long)2L, (long)((SQLQuery)this.query().from((Expression)numberTest)).select(numberTest.col1Number).fetch().size());
    }

    @Test
    public void number_as_boolean_Null() {
        QNumberTest numberTest = QNumberTest.numberTest;
        this.delete((RelationalPath<?>)numberTest).execute();
        ((SQLInsertClause)this.insert((RelationalPath<?>)numberTest).setNull((Path)numberTest.col1Boolean)).execute();
        ((SQLInsertClause)this.insert((RelationalPath<?>)numberTest).setNull(numberTest.col1Number)).execute();
        Assert.assertEquals((long)2L, (long)((SQLQuery)this.query().from((Expression)numberTest)).select((Expression)numberTest.col1Boolean).fetch().size());
        Assert.assertEquals((long)2L, (long)((SQLQuery)this.query().from((Expression)numberTest)).select(numberTest.col1Number).fetch().size());
    }

    @Test
    public void offset_only() {
        Assert.assertEquals(Arrays.asList(20, 13, 10, 2, 1, 11, 12), (Object)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).orderBy(Constants.employee.firstname.asc())).offset(3L)).select(Constants.employee.id).fetch());
    }

    @Test
    public void operation_in_constant_list() {
        Assert.assertEquals((long)0L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.charAt(0).in(Collections.singletonList(Character.valueOf('a'))))).fetchCount());
        Assert.assertEquals((long)0L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.charAt(0).in(Arrays.asList(Character.valueOf('a'), Character.valueOf('b'))))).fetchCount());
        Assert.assertEquals((long)0L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.charAt(0).in(Arrays.asList(Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'))))).fetchCount());
    }

    @Test
    public void order_nullsFirst() {
        Assert.assertEquals(Collections.singletonList("Hello World"), (Object)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).orderBy(Constants.survey.name.asc().nullsFirst())).select((Expression)Constants.survey.name).fetch());
    }

    @Test
    public void order_nullsLast() {
        Assert.assertEquals(Collections.singletonList("Hello World"), (Object)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).orderBy(Constants.survey.name.asc().nullsLast())).select((Expression)Constants.survey.name).fetch());
    }

    @Test
    public void params() {
        Param name = new Param(String.class, "name");
        Assert.assertEquals((Object)"Mike", (Object)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.firstname.eq((Expression)name))).set((ParamExpression)name, (Object)"Mike")).select((Expression)Constants.employee.firstname).fetchFirst());
    }

    @Test
    public void params_anon() {
        Param name = new Param(String.class);
        Assert.assertEquals((Object)"Mike", (Object)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.firstname.eq((Expression)name))).set((ParamExpression)name, (Object)"Mike")).select((Expression)Constants.employee.firstname).fetchFirst());
    }

    @Test(expected=ParamNotSetException.class)
    public void params_not_set() {
        Param name = new Param(String.class, "name");
        Assert.assertEquals((Object)"Mike", (Object)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.firstname.eq((Expression)name))).select((Expression)Constants.employee.firstname).fetchFirst());
    }

    @Test
    @ExcludeIn(value={Target.DB2, Target.DERBY, Target.FIREBIRD, Target.HSQLDB, Target.ORACLE, Target.SQLSERVER})
    @SkipForQuoted
    public void path_alias() {
        this.expectedQuery = "select e.LASTNAME, sum(e.SALARY) as salarySum from EMPLOYEE e group by e.LASTNAME having salarySum > ?";
        NumberExpression salarySum = Constants.employee.salary.sum().as("salarySum");
        ((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).groupBy((Expression)Constants.employee.lastname)).having((Predicate)salarySum.gt((Number)10000))).select(new Expression[]{Constants.employee.lastname, salarySum}).fetch();
    }

    @Test
    public void path_in_constant_list() {
        Assert.assertEquals((long)0L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.in(Collections.singletonList("a")))).fetchCount());
        Assert.assertEquals((long)0L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.in(Arrays.asList("a", "b")))).fetchCount());
        Assert.assertEquals((long)0L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.in(Arrays.asList("a", "b", "c")))).fetchCount());
    }

    @Test
    public void precedence() {
        StringPath fn = Constants.employee.firstname;
        StringPath ln = Constants.employee.lastname;
        BooleanExpression where = fn.eq((Object)"Mike").and((Predicate)ln.eq((Object)"Smith")).or((Predicate)fn.eq((Object)"Joe").and((Predicate)ln.eq((Object)"Divis")));
        Assert.assertEquals((long)2L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)where)).fetchCount());
    }

    @Test
    public void precedence2() {
        StringPath fn = Constants.employee.firstname;
        StringPath ln = Constants.employee.lastname;
        BooleanExpression where = fn.eq((Object)"Mike").and((Predicate)ln.eq((Object)"Smith").or((Predicate)fn.eq((Object)"Joe")).and((Predicate)ln.eq((Object)"Divis")));
        Assert.assertEquals((long)0L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)where)).fetchCount());
    }

    @Test
    public void projection() throws IOException {
        CloseableIterator results = ((SQLQuery)this.query().from((Expression)Constants.survey)).select((Expression[])Constants.survey.all()).iterate();
        Assert.assertTrue((boolean)results.hasNext());
        while (results.hasNext()) {
            Assert.assertEquals((long)3L, (long)((Tuple)results.next()).size());
        }
        results.close();
    }

    @Test
    public void projection_and_twoColumns() {
        for (Tuple row : ((SQLQuery)this.query().from((Expression)Constants.survey)).select(new Expression[]{new QIdName((Expression<Integer>)Constants.survey.id, (Expression<String>)Constants.survey.name), Constants.survey.id, Constants.survey.name}).fetch()) {
            Assert.assertEquals((long)3L, (long)row.size());
            Assert.assertEquals(IdName.class, row.get(0, Object.class).getClass());
            Assert.assertEquals(Integer.class, row.get(1, Object.class).getClass());
            Assert.assertEquals(String.class, row.get(2, Object.class).getClass());
        }
    }

    @Test
    public void projection2() throws IOException {
        CloseableIterator results = ((SQLQuery)this.query().from((Expression)Constants.survey)).select(new Expression[]{Constants.survey.id, Constants.survey.name}).iterate();
        Assert.assertTrue((boolean)results.hasNext());
        while (results.hasNext()) {
            Assert.assertEquals((long)2L, (long)((Tuple)results.next()).size());
        }
        results.close();
    }

    @Test
    public void projection3() throws IOException {
        CloseableIterator names = ((SQLQuery)this.query().from((Expression)Constants.survey)).select((Expression)Constants.survey.name).iterate();
        Assert.assertTrue((boolean)names.hasNext());
        while (names.hasNext()) {
            System.out.println((String)names.next());
        }
        names.close();
    }

    @Test
    public void qBeanUsage() {
        PathBuilder sq = new PathBuilder(Object[].class, "sq");
        List surveys = ((SQLQuery)this.query().from((Expression)((SQLQuery)this.query().from((Expression)Constants.survey)).select((Expression[])Constants.survey.all()).as("sq"))).select((Expression)Projections.bean(Survey.class, Collections.singletonMap("name", sq.get(Constants.survey.name)))).fetch();
        Assert.assertFalse((boolean)surveys.isEmpty());
    }

    @Test
    public void query_with_constant() throws Exception {
        for (Tuple row : ((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.id.eq((Object)1))).select(new Expression[]{Constants.survey.id, Constants.survey.name}).fetch()) {
            Assert.assertNotNull((Object)row.get(Constants.survey.id));
            Assert.assertNotNull((Object)row.get((Expression)Constants.survey.name));
        }
    }

    @Test
    public void query1() throws Exception {
        for (String s : ((SQLQuery)this.query().from((Expression)Constants.survey)).select((Expression)Constants.survey.name).fetch()) {
            Assert.assertNotNull((Object)s);
        }
    }

    @Test
    public void query2() throws Exception {
        for (Tuple row : ((SQLQuery)this.query().from((Expression)Constants.survey)).select(new Expression[]{Constants.survey.id, Constants.survey.name}).fetch()) {
            Assert.assertNotNull((Object)row.get(Constants.survey.id));
            Assert.assertNotNull((Object)row.get((Expression)Constants.survey.name));
        }
    }

    private double radians(double x) {
        return x * Math.PI / 180.0;
    }

    @Test
    public void random() {
        this.firstResult((Expression<T>)((Expression)MathExpressions.random()));
    }

    @Test
    @ExcludeIn(value={Target.FIREBIRD, Target.ORACLE, Target.POSTGRESQL, Target.SQLITE, Target.TERADATA})
    public void random2() {
        this.firstResult((Expression<T>)((Expression)MathExpressions.random((int)10)));
    }

    @Test
    public void relationalPath_projection() {
        List results = ((SQLQuery)((SQLQuery)this.query().from(new Expression[]{Constants.employee, Constants.employee2})).where((Predicate)Constants.employee.id.eq(Constants.employee2.id))).select(new Expression[]{Constants.employee, Constants.employee2}).fetch();
        Assert.assertFalse((boolean)results.isEmpty());
        for (Tuple row : results) {
            Employee e1 = (Employee)row.get((Expression)Constants.employee);
            Employee e2 = (Employee)row.get((Expression)Constants.employee2);
            Assert.assertEquals((Object)e1.getId(), (Object)e2.getId());
        }
    }

    @Test
    public void relationalPath_eq() {
        Assert.assertEquals((long)10L, (long)((SQLQuery)((SQLQuery)this.query().from(new Expression[]{Constants.employee, Constants.employee2})).where((Predicate)Constants.employee.eq((Expression)Constants.employee2))).select(new Expression[]{Constants.employee.id, Constants.employee2.id}).fetch().size());
    }

    @Test
    public void relationalPath_ne() {
        Assert.assertEquals((long)90L, (long)((SQLQuery)((SQLQuery)this.query().from(new Expression[]{Constants.employee, Constants.employee2})).where((Predicate)Constants.employee.ne((Expression)Constants.employee2))).select(new Expression[]{Constants.employee.id, Constants.employee2.id}).fetch().size());
    }

    @Test
    public void relationalPath_eq2() {
        Assert.assertEquals((long)1L, (long)((SQLQuery)((SQLQuery)this.query().from(new Expression[]{Constants.survey, Constants.survey2})).where((Predicate)Constants.survey.eq((Object)Constants.survey2))).select(new Expression[]{Constants.survey.id, Constants.survey2.id}).fetch().size());
    }

    @Test
    public void relationalPath_ne2() {
        Assert.assertEquals((long)0L, (long)((SQLQuery)((SQLQuery)this.query().from(new Expression[]{Constants.survey, Constants.survey2})).where((Predicate)Constants.survey.ne((Object)Constants.survey2))).select(new Expression[]{Constants.survey.id, Constants.survey2.id}).fetch().size());
    }

    @Test
    @ExcludeIn(value={Target.SQLITE})
    public void right_join() throws SQLException {
        Assert.assertEquals((long)16L, (long)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).rightJoin((EntityPath)Constants.employee2)).on(Constants.employee.superiorIdKey.on((RelationalPath)Constants.employee2))).select(new Expression[]{Constants.employee.id, Constants.employee2.id}).fetch().size());
    }

    @Test
    @ExcludeIn(value={Target.DERBY})
    public void round() {
        NumberTemplate expr = Expressions.numberTemplate(Double.class, (String)"1.32", (Object[])new Object[0]);
        Assert.assertEquals((Object)1.0, this.firstResult((Expression<T>)((Expression)MathExpressions.round((Expression)expr))));
        Assert.assertEquals((Object)1.3, this.firstResult((Expression<T>)((Expression)MathExpressions.round((Expression)expr, (int)1))));
    }

    @Test
    @ExcludeIn(value={Target.SQLITE, Target.DERBY})
    public void rpad() {
        Assert.assertEquals((Object)"ab  ", this.firstResult((Expression<T>)((Expression)StringExpressions.rpad((Expression)ConstantImpl.create((Object)"ab"), (int)4))));
        Assert.assertEquals((Object)"ab!!", this.firstResult((Expression<T>)((Expression)StringExpressions.rpad((Expression)ConstantImpl.create((Object)"ab"), (int)4, (char)'!'))));
    }

    @Test
    @Ignore
    @ExcludeIn(value={Target.ORACLE, Target.DERBY, Target.SQLSERVER})
    public void select_booleanExpr() throws SQLException {
        System.out.println(((SQLQuery)this.query().from((Expression)Constants.survey)).select((Expression)Constants.survey.id.eq((Object)0)).fetch());
    }

    @Test
    @Ignore
    @ExcludeIn(value={Target.ORACLE, Target.DERBY, Target.SQLSERVER})
    public void select_booleanExpr2() throws SQLException {
        System.out.println(((SQLQuery)this.query().from((Expression)Constants.survey)).select((Expression)Constants.survey.id.gt((Number)0)).fetch());
    }

    @Test
    public void select_booleanExpr3() {
        Assert.assertTrue((boolean)((Boolean)this.query().select((Expression)Expressions.TRUE).fetchFirst()));
        Assert.assertFalse((boolean)((Boolean)this.query().select((Expression)Expressions.FALSE).fetchFirst()));
    }

    @Test
    public void select_concat() throws SQLException {
        for (Tuple row : ((SQLQuery)this.query().from((Expression)Constants.survey)).select(new Expression[]{Constants.survey.name, Constants.survey.name.append("Hello World")}).fetch()) {
            Assert.assertEquals((Object)((String)row.get((Expression)Constants.survey.name) + "Hello World"), (Object)row.get((Expression)Constants.survey.name.append("Hello World")));
        }
    }

    @Test
    @ExcludeIn(value={Target.SQLITE, Target.CUBRID, Target.TERADATA})
    public void select_for_update() {
        Assert.assertEquals((long)1L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).forUpdate()).select(Constants.survey.id).fetch().size());
    }

    @Test
    @ExcludeIn(value={Target.SQLITE, Target.CUBRID, Target.TERADATA})
    public void select_for_update_Where() {
        Assert.assertEquals((long)1L, (long)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).forUpdate()).where((Predicate)Constants.survey.id.isNotNull())).select(Constants.survey.id).fetch().size());
    }

    @Test
    @ExcludeIn(value={Target.SQLITE, Target.CUBRID, Target.TERADATA})
    public void select_for_update_UniqueResult() {
        ((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).forUpdate()).select(Constants.survey.id).fetchOne();
    }

    @Test
    public void select_for_share() {
        if (this.configuration.getTemplates().isForShareSupported()) {
            Assert.assertEquals((long)1L, (long)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).forShare()).where((Predicate)Constants.survey.id.isNotNull())).select(Constants.survey.id).fetch().size());
        } else {
            try {
                ((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).forShare()).where((Predicate)Constants.survey.id.isNotNull())).select(Constants.survey.id).fetch().size();
                Assert.fail();
            }
            catch (QueryException e) {
                Assert.assertTrue((boolean)e.getMessage().equals("Using forShare() is not supported"));
            }
        }
    }

    @Test
    @SkipForQuoted
    public void serialization() {
        SQLQuery<?> query = this.query();
        query.from((Expression)Constants.survey);
        Assert.assertEquals((Object)"from SURVEY s", (Object)query.toString());
        query.from((Expression)Constants.survey2);
        Assert.assertEquals((Object)"from SURVEY s, SURVEY s2", (Object)query.toString());
    }

    @Test
    public void serialization2() throws Exception {
        List rows = ((SQLQuery)this.query().from((Expression)Constants.survey)).select(new Expression[]{Constants.survey.id, Constants.survey.name}).fetch();
        this.serialize(rows);
    }

    private void serialize(List<Tuple> rows) throws IOException, ClassNotFoundException {
        rows = (List)Serialization.serialize(rows);
        for (Tuple row : rows) {
            row.hashCode();
        }
    }

    @Test
    public void single() {
        Assert.assertNotNull((Object)((SQLQuery)this.query().from((Expression)Constants.survey)).select((Expression)Constants.survey.name).fetchFirst());
    }

    @Test
    public void single_array() {
        Assert.assertNotNull((Object)((SQLQuery)this.query().from((Expression)Constants.survey)).select(new Expression[]{Constants.survey.name}).fetchFirst());
    }

    @Test
    public void single_column() {
        for (String s : ((SQLQuery)this.query().from((Expression)Constants.survey)).select((Expression)Constants.survey.name).fetch()) {
            Assert.assertNotNull((Object)s);
        }
    }

    @Test
    public void single_column_via_Object_type() {
        for (Object s : ((SQLQuery)this.query().from((Expression)Constants.survey)).select((Expression)ExpressionUtils.path(Object.class, (PathMetadata)Constants.survey.name.getMetadata())).fetch()) {
            Assert.assertEquals(String.class, s.getClass());
        }
    }

    @Test
    public void specialChars() {
        Assert.assertEquals((long)0L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.in((Object[])new String[]{"\n", "\r", "\\", "'", "\""}))).fetchCount());
    }

    @Test
    public void standardTest() {
        this.standardTest.runBooleanTests(Constants.employee.firstname.isNull(), Constants.employee2.lastname.isNotNull());
        this.standardTest.runDateTests(Constants.employee.datefield, Constants.employee2.datefield, Constants.date);
        this.standardTest.runNumericCasts(Constants.employee.id, Constants.employee2.id, (Number)1);
        this.standardTest.runNumericTests(Constants.employee.id, Constants.employee2.id, (Number)1);
        this.standardTest.runNumericTests(Constants.employee.salary, Constants.employee2.salary, (Number)new BigDecimal("30000.00"));
        this.standardTest.runStringTests((StringExpression)Constants.employee.firstname, (StringExpression)Constants.employee2.firstname, "Jennifer");
        Target target = Connections.getTarget();
        if (target != Target.SQLITE) {
            this.standardTest.runTimeTests(Constants.employee.timefield, Constants.employee2.timefield, Constants.time);
        }
        this.standardTest.report();
    }

    @Test
    @IncludeIn(value={Target.H2})
    public void standardTest_turkish() {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(new Locale("tr", "TR"));
        try {
            this.standardTest();
        }
        finally {
            Locale.setDefault(defaultLocale);
        }
    }

    @Test
    @ExcludeIn(value={Target.SQLITE})
    public void string() {
        StringTemplate str = Expressions.stringTemplate((String)"'  abcd  '", (Object[])new Object[0]);
        Assert.assertEquals((Object)"abcd  ", this.firstResult((Expression<T>)((Expression)StringExpressions.ltrim((Expression)str))));
        Assert.assertEquals((Object)3, this.firstResult((Expression<T>)((Expression)str.locate("a"))));
        Assert.assertEquals((Object)0, this.firstResult((Expression<T>)((Expression)str.locate("a", 4))));
        Assert.assertEquals((Object)4, this.firstResult((Expression<T>)((Expression)str.locate("b", 2))));
        Assert.assertEquals((Object)"  abcd", this.firstResult((Expression<T>)((Expression)StringExpressions.rtrim((Expression)str))));
        Assert.assertEquals((Object)"abc", this.firstResult((Expression<T>)((Expression)str.substring(2, 5))));
    }

    @Test
    @ExcludeIn(value={Target.SQLITE})
    public void string_withTemplate() {
        StringTemplate str = Expressions.stringTemplate((String)"'  abcd  '", (Object[])new Object[0]);
        NumberTemplate four = Expressions.numberTemplate(Integer.class, (String)"4", (Object[])new Object[0]);
        NumberTemplate two = Expressions.numberTemplate(Integer.class, (String)"2", (Object[])new Object[0]);
        NumberTemplate five = Expressions.numberTemplate(Integer.class, (String)"5", (Object[])new Object[0]);
        Assert.assertEquals((Object)"abcd  ", this.firstResult((Expression<T>)((Expression)StringExpressions.ltrim((Expression)str))));
        Assert.assertEquals((Object)3, this.firstResult((Expression<T>)((Expression)str.locate("a"))));
        Assert.assertEquals((Object)0, this.firstResult((Expression<T>)((Expression)str.locate("a", (Expression)four))));
        Assert.assertEquals((Object)4, this.firstResult((Expression<T>)((Expression)str.locate("b", (Expression)two))));
        Assert.assertEquals((Object)"  abcd", this.firstResult((Expression<T>)((Expression)StringExpressions.rtrim((Expression)str))));
        Assert.assertEquals((Object)"abc", this.firstResult((Expression<T>)((Expression)str.substring((Expression)two, (Expression)five))));
    }

    @Test
    @ExcludeIn(value={Target.POSTGRESQL, Target.SQLITE})
    public void string_indexOf() {
        StringTemplate str = Expressions.stringTemplate((String)"'  abcd  '", (Object[])new Object[0]);
        Assert.assertEquals((Object)2, this.firstResult((Expression<T>)((Expression)str.indexOf("a"))));
        Assert.assertEquals((Object)-1, this.firstResult((Expression<T>)((Expression)str.indexOf("a", 4))));
        Assert.assertEquals((Object)3, this.firstResult((Expression<T>)((Expression)str.indexOf("b", 2))));
    }

    @Test
    public void stringFunctions2() throws SQLException {
        for (BooleanExpression where : Arrays.asList(Constants.employee.firstname.startsWith("a"), Constants.employee.firstname.startsWithIgnoreCase("a"), Constants.employee.firstname.endsWith("a"), Constants.employee.firstname.endsWithIgnoreCase("a"))) {
            ((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)where)).select((Expression)Constants.employee.firstname).fetch();
        }
    }

    @Test
    @ExcludeIn(value={Target.SQLITE})
    public void string_left() {
        Assert.assertEquals((Object)"John", (Object)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.lastname.eq((Object)"Johnson"))).select((Expression)SQLExpressions.left((Expression)Constants.employee.lastname, (int)4)).fetchFirst());
    }

    @Test
    @ExcludeIn(value={Target.DERBY, Target.SQLITE})
    public void string_right() {
        Assert.assertEquals((Object)"son", (Object)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.lastname.eq((Object)"Johnson"))).select((Expression)SQLExpressions.right((Expression)Constants.employee.lastname, (int)3)).fetchFirst());
    }

    @Test
    @ExcludeIn(value={Target.DERBY, Target.SQLITE})
    public void string_left_Right() {
        Assert.assertEquals((Object)"hn", (Object)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.lastname.eq((Object)"Johnson"))).select((Expression)SQLExpressions.right((Expression)SQLExpressions.left((Expression)Constants.employee.lastname, (int)4), (int)2)).fetchFirst());
    }

    @Test
    @ExcludeIn(value={Target.DERBY, Target.SQLITE})
    public void string_right_Left() {
        Assert.assertEquals((Object)"ns", (Object)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.lastname.eq((Object)"Johnson"))).select((Expression)SQLExpressions.left((Expression)SQLExpressions.right((Expression)Constants.employee.lastname, (int)4), (int)2)).fetchFirst());
    }

    @Test
    @ExcludeIn(value={Target.DB2, Target.DERBY, Target.FIREBIRD})
    public void substring() {
        ((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.firstname.substring(-3, 1).eq((Expression)Constants.employee.firstname.substring(-2, 1)))).select(Constants.employee.id).fetch();
    }

    @Test
    public void syntax_for_employee() throws SQLException {
        Assert.assertEquals((long)3L, (long)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).groupBy(Constants.employee.superiorId)).orderBy(Constants.employee.superiorId.asc())).select(new Expression[]{Constants.employee.salary.avg(), Constants.employee.id.max()}).fetch().size());
        Assert.assertEquals((long)2L, (long)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).groupBy(Constants.employee.superiorId)).having((Predicate)Constants.employee.id.max().gt((Number)5))).orderBy(Constants.employee.superiorId.asc())).select(new Expression[]{Constants.employee.salary.avg(), Constants.employee.id.max()}).fetch().size());
        Assert.assertEquals((long)2L, (long)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).groupBy(Constants.employee.superiorId)).having((Predicate)Constants.employee.superiorId.isNotNull())).orderBy(Constants.employee.superiorId.asc())).select(new Expression[]{Constants.employee.salary.avg(), Constants.employee.id.max()}).fetch().size());
    }

    @Test
    public void templateExpression() {
        NumberTemplate one = Expressions.numberTemplate(Integer.class, (String)"1", (Object[])new Object[0]);
        Assert.assertEquals(Collections.singletonList(1), (Object)((SQLQuery)this.query().from((Expression)Constants.survey)).select((Expression)one.as("col1")).fetch());
    }

    @Test
    public void transform_groupBy() {
        QEmployee employee = new QEmployee("employee");
        QEmployee employee2 = new QEmployee("employee2");
        Map results = (Map)((SQLQuery)this.query().from(new Expression[]{employee, employee2})).transform(GroupBy.groupBy(employee.id).as((Expression)GroupBy.map(employee2.id, (Expression)employee2)));
        int count = (int)((SQLQuery)this.query().from((Expression)employee)).fetchCount();
        Assert.assertEquals((long)count, (long)results.size());
        for (Map.Entry entry : results.entrySet()) {
            Map employees = (Map)entry.getValue();
            Assert.assertEquals((long)count, (long)employees.size());
        }
    }

    @Test
    public void tuple_projection() {
        List tuples = ((SQLQuery)this.query().from((Expression)Constants.employee)).select(new Expression[]{Constants.employee.firstname, Constants.employee.lastname}).fetch();
        Assert.assertFalse((boolean)tuples.isEmpty());
        for (Tuple tuple : tuples) {
            Assert.assertNotNull((Object)tuple.get((Expression)Constants.employee.firstname));
            Assert.assertNotNull((Object)tuple.get((Expression)Constants.employee.lastname));
        }
    }

    @Test
    @ExcludeIn(value={Target.DB2, Target.DERBY})
    public void tuple2() {
        Assert.assertEquals((long)10L, (long)((SQLQuery)this.query().from((Expression)Constants.employee)).select(new Expression[]{Expressions.as((Expression)ConstantImpl.create((Object)"1"), (String)"code"), Constants.employee.id}).fetch().size());
    }

    @Test
    public void twoColumns() {
        for (Tuple row : ((SQLQuery)this.query().from((Expression)Constants.survey)).select(new Expression[]{Constants.survey.id, Constants.survey.name}).fetch()) {
            Assert.assertEquals((long)2L, (long)row.size());
            Assert.assertEquals(Integer.class, row.get(0, Object.class).getClass());
            Assert.assertEquals(String.class, row.get(1, Object.class).getClass());
        }
    }

    @Test
    public void twoColumns_and_projection() {
        for (Tuple row : ((SQLQuery)this.query().from((Expression)Constants.survey)).select(new Expression[]{Constants.survey.id, Constants.survey.name, new QIdName((Expression<Integer>)Constants.survey.id, (Expression<String>)Constants.survey.name)}).fetch()) {
            Assert.assertEquals((long)3L, (long)row.size());
            Assert.assertEquals(Integer.class, row.get(0, Object.class).getClass());
            Assert.assertEquals(String.class, row.get(1, Object.class).getClass());
            Assert.assertEquals(IdName.class, row.get(2, Object.class).getClass());
        }
    }

    @Test
    public void unique_Constructor_projection() {
        IdName idAndName = (IdName)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).limit(1L)).select((Expression)new QIdName((Expression<Integer>)Constants.survey.id, (Expression<String>)Constants.survey.name)).fetchFirst();
        Assert.assertNotNull((Object)idAndName);
        Assert.assertNotNull((Object)idAndName.getId());
        Assert.assertNotNull((Object)idAndName.getName());
    }

    @Test
    public void unique_single() {
        String s = (String)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).limit(1L)).select((Expression)Constants.survey.name).fetchFirst();
        Assert.assertNotNull((Object)s);
    }

    @Test
    public void unique_wildcard() {
        Tuple row = (Tuple)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).limit(1L)).select((Expression[])Constants.survey.all()).fetchFirst();
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((long)3L, (long)row.size());
        Assert.assertNotNull((Object)row.get(0, Object.class));
        Assert.assertNotNull((String)(row.get(0, Object.class) + " is not null"), (Object)row.get(1, Object.class));
    }

    @Test(expected=NonUniqueResultException.class)
    public void uniqueResultContract() {
        ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression[])Constants.employee.all()).fetchOne();
    }

    @Test
    public void various() throws SQLException {
        for (String s : ((SQLQuery)this.query().from((Expression)Constants.survey)).select((Expression)Constants.survey.name.lower()).fetch()) {
            Assert.assertEquals((Object)s, (Object)s.toLowerCase());
        }
        for (String s : ((SQLQuery)this.query().from((Expression)Constants.survey)).select((Expression)Constants.survey.name.append("abc")).fetch()) {
            Assert.assertTrue((boolean)s.endsWith("abc"));
        }
        System.out.println(((SQLQuery)this.query().from((Expression)Constants.survey)).select((Expression)Constants.survey.id.sqrt()).fetch());
    }

    @Test
    public void where_exists() throws SQLException {
        SQLQuery sq1 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.id.max());
        Assert.assertEquals((long)10L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)sq1.exists())).fetchCount());
    }

    @Test
    public void where_exists_Not() throws SQLException {
        SQLQuery sq1 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.id.max());
        Assert.assertEquals((long)0L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)sq1.exists().not())).fetchCount());
    }

    @Test
    @IncludeIn(value={Target.HSQLDB, Target.ORACLE, Target.POSTGRESQL})
    public void with() {
        Assert.assertEquals((long)10L, (long)((SQLQuery)((SQLQuery)this.query().with((Path)Constants.employee2, (SubQueryExpression)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.firstname.eq((Object)"Jim"))).select(Wildcard.all))).from(new Expression[]{Constants.employee, Constants.employee2})).select(new Expression[]{Constants.employee.id, Constants.employee2.id}).fetch().size());
    }

    @Test
    @IncludeIn(value={Target.HSQLDB, Target.ORACLE, Target.POSTGRESQL})
    public void with2() {
        QEmployee employee3 = new QEmployee("e3");
        Assert.assertEquals((long)100L, (long)((SQLQuery)((SQLQuery)((SQLQuery)this.query().with((Path)Constants.employee2, (SubQueryExpression)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.firstname.eq((Object)"Jim"))).select(Wildcard.all))).with((Path)Constants.employee2, (SubQueryExpression)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.firstname.eq((Object)"Jim"))).select(Wildcard.all))).from(new Expression[]{Constants.employee, Constants.employee2, employee3})).select(new Expression[]{Constants.employee.id, Constants.employee2.id, employee3.id}).fetch().size());
    }

    @Test
    @IncludeIn(value={Target.HSQLDB, Target.ORACLE, Target.POSTGRESQL})
    public void with3() {
        Assert.assertEquals((long)10L, (long)((SQLQuery)((SQLQuery)this.query().with((Path)Constants.employee2, Constants.employee2.all()).as((Expression)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.firstname.eq((Object)"Jim"))).select(Wildcard.all))).from(new Expression[]{Constants.employee, Constants.employee2})).select(new Expression[]{Constants.employee.id, Constants.employee2.id}).fetch().size());
    }

    @Test
    @IncludeIn(value={Target.HSQLDB, Target.ORACLE, Target.POSTGRESQL})
    public void with_limit() {
        Assert.assertEquals((long)5L, (long)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.query().with((Path)Constants.employee2, Constants.employee2.all()).as((Expression)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.firstname.eq((Object)"Jim"))).select(Wildcard.all))).from(new Expression[]{Constants.employee, Constants.employee2})).limit(5L)).orderBy(new OrderSpecifier[]{Constants.employee.id.asc(), Constants.employee2.id.asc()})).select(new Expression[]{Constants.employee.id, Constants.employee2.id}).fetch().size());
    }

    @Test
    @IncludeIn(value={Target.HSQLDB, Target.ORACLE, Target.POSTGRESQL})
    public void with_limitOffset() {
        Assert.assertEquals((long)5L, (long)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.query().with((Path)Constants.employee2, Constants.employee2.all()).as((Expression)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.firstname.eq((Object)"Jim"))).select(Wildcard.all))).from(new Expression[]{Constants.employee, Constants.employee2})).limit(10L)).offset(5L)).orderBy(new OrderSpecifier[]{Constants.employee.id.asc(), Constants.employee2.id.asc()})).select(new Expression[]{Constants.employee.id, Constants.employee2.id}).fetch().size());
    }

    @Test
    @IncludeIn(value={Target.ORACLE, Target.POSTGRESQL})
    public void with_recursive() {
        Assert.assertEquals((long)10L, (long)((SQLQuery)((SQLQuery)this.query().withRecursive((Path)Constants.employee2, (SubQueryExpression)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.firstname.eq((Object)"Jim"))).select(Wildcard.all))).from(new Expression[]{Constants.employee, Constants.employee2})).select(new Expression[]{Constants.employee.id, Constants.employee2.id}).fetch().size());
    }

    @Test
    @IncludeIn(value={Target.ORACLE, Target.POSTGRESQL})
    public void with_recursive2() {
        Assert.assertEquals((long)10L, (long)((SQLQuery)((SQLQuery)this.query().withRecursive((Path)Constants.employee2, Constants.employee2.all()).as((Expression)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.firstname.eq((Object)"Jim"))).select(Wildcard.all))).from(new Expression[]{Constants.employee, Constants.employee2})).select(new Expression[]{Constants.employee.id, Constants.employee2.id}).fetch().size());
    }

    @Test
    public void wildcard() {
        for (Tuple row : ((SQLQuery)this.query().from((Expression)Constants.survey)).select((Expression[])Constants.survey.all()).fetch()) {
            Assert.assertNotNull((Object)row);
            Assert.assertEquals((long)3L, (long)row.size());
            Assert.assertNotNull((Object)row.get(0, Object.class));
            Assert.assertNotNull((String)(row.get(0, Object.class) + " is not null"), (Object)row.get(1, Object.class));
        }
    }

    @Test
    @SkipForQuoted
    public void wildcard_all() {
        this.expectedQuery = "select * from EMPLOYEE e";
        ((SQLQuery)this.query().from((Expression)Constants.employee)).select(Wildcard.all).fetch();
    }

    @Test
    public void wildcard_all2() {
        Assert.assertEquals((long)10L, (long)((SQLQuery)this.query().from((Expression)new RelationalPathBase(Object.class, "employee", "public", "EMPLOYEE"))).select(Wildcard.all).fetch().size());
    }

    @Test
    public void wildcard_and_qTuple() {
        for (Tuple tuple : ((SQLQuery)this.query().from((Expression)Constants.survey)).select((Expression[])Constants.survey.all()).fetch()) {
            Assert.assertNotNull((Object)tuple.get(Constants.survey.id));
            Assert.assertNotNull((Object)tuple.get((Expression)Constants.survey.name));
        }
    }

    @Test
    @IncludeIn(value={Target.ORACLE})
    public void withinGroup() {
        ArrayList exprs = new ArrayList();
        NumberPath<Integer> path = Constants.survey.id;
        this.add(exprs, SQLExpressions.cumeDist((Object[])new Object[]{2, 3}), new Target[0]);
        this.add(exprs, SQLExpressions.denseRank((Object[])new Object[]{4, 5}), new Target[0]);
        this.add(exprs, SQLExpressions.listagg(path, (String)","), new Target[0]);
        this.add(exprs, SQLExpressions.percentRank((Object[])new Object[]{6, 7}), new Target[0]);
        this.add(exprs, SQLExpressions.rank((Object[])new Object[]{8, 9}), new Target[0]);
        for (WithinGroup wg : exprs) {
            ((SQLQuery)this.query().from((Expression)Constants.survey)).select((Expression)wg.withinGroup().orderBy(new ComparableExpressionBase[]{Constants.survey.id, Constants.survey.id})).fetch();
            ((SQLQuery)this.query().from((Expression)Constants.survey)).select((Expression)wg.withinGroup().orderBy(new OrderSpecifier[]{Constants.survey.id.asc(), Constants.survey.id.asc()})).fetch();
        }
        exprs.clear();
        this.add(exprs, SQLExpressions.percentileCont((Number)0.1), new Target[0]);
        this.add(exprs, SQLExpressions.percentileDisc((Number)0.9), new Target[0]);
        for (WithinGroup wg : exprs) {
            ((SQLQuery)this.query().from((Expression)Constants.survey)).select((Expression)wg.withinGroup().orderBy(Constants.survey.id)).fetch();
            ((SQLQuery)this.query().from((Expression)Constants.survey)).select((Expression)wg.withinGroup().orderBy(Constants.survey.id.asc())).fetch();
        }
    }

    @Test
    @ExcludeIn(value={Target.DB2, Target.DERBY, Target.H2})
    public void yearWeek() {
        SQLQuery query = (SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).orderBy(Constants.employee.id.asc());
        Assert.assertEquals((Object)200006, (Object)query.select((Expression)Constants.employee.datefield.yearWeek()).fetchFirst());
    }

    @Test
    @IncludeIn(value={Target.H2})
    public void yearWeek_h2() {
        SQLQuery query = (SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).orderBy(Constants.employee.id.asc());
        Assert.assertEquals((Object)200007, (Object)query.select((Expression)Constants.employee.datefield.yearWeek()).fetchFirst());
    }

    @Test
    public void statementOptions() {
        StatementOptions options = StatementOptions.builder().setFetchSize(Integer.valueOf(15)).setMaxRows(Integer.valueOf(150)).build();
        SQLQuery query = (SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).orderBy(Constants.employee.id.asc());
        query.setStatementOptions(options);
        query.addListener((SQLListener)new SQLBaseListener(){

            public void preExecute(SQLListenerContext context) {
                try {
                    Assert.assertEquals((long)15L, (long)context.getPreparedStatement().getFetchSize());
                    Assert.assertEquals((long)150L, (long)context.getPreparedStatement().getMaxRows());
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        query.select(Constants.employee.id).fetch();
    }

    @Test
    public void getResults() throws SQLException, InterruptedException {
        final AtomicLong endCalled = new AtomicLong(0L);
        SQLQuery query = (SQLQuery)this.query().select(Constants.employee.id).from((Expression)Constants.employee);
        query.addListener((SQLListener)new SQLBaseListener(){

            public void end(SQLListenerContext context) {
                endCalled.set(System.currentTimeMillis());
            }
        });
        ResultSet results = query.getResults(new Expression[]{Constants.employee.id});
        long getResultsCalled = System.currentTimeMillis();
        Thread.sleep(100L);
        results.close();
        Assert.assertTrue((endCalled.get() - getResultsCalled >= 100L ? 1 : 0) != 0);
    }

    @Test
    @ExcludeIn(value={Target.DB2, Target.DERBY, Target.ORACLE, Target.SQLSERVER})
    public void groupConcat() {
        List<String> expected = Arrays.asList("Mike,Mary", "Joe,Peter,Steve,Jim", "Jennifer,Helen,Daisy,Barbara");
        if (Connections.getTarget() == Target.POSTGRESQL) {
            expected = Arrays.asList("Steve,Jim,Joe,Peter", "Barbara,Helen,Daisy,Jennifer", "Mary,Mike");
        }
        Assert.assertEquals(expected, (Object)((SQLQuery)((SQLQuery)this.query().select((Expression)SQLExpressions.groupConcat((Expression)Constants.employee.firstname)).from((Expression)Constants.employee)).groupBy(Constants.employee.superiorId)).fetch());
    }

    @Test
    @ExcludeIn(value={Target.DB2, Target.DERBY, Target.ORACLE, Target.SQLSERVER})
    public void groupConcat2() {
        List<String> expected = Arrays.asList("Mike-Mary", "Joe-Peter-Steve-Jim", "Jennifer-Helen-Daisy-Barbara");
        if (Connections.getTarget() == Target.POSTGRESQL) {
            expected = Arrays.asList("Steve-Jim-Joe-Peter", "Barbara-Helen-Daisy-Jennifer", "Mary-Mike");
        }
        Assert.assertEquals(expected, (Object)((SQLQuery)((SQLQuery)this.query().select((Expression)SQLExpressions.groupConcat((Expression)Constants.employee.firstname, (String)"-")).from((Expression)Constants.employee)).groupBy(Constants.employee.superiorId)).fetch());
    }
}

