/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.Target;
import com.querydsl.core.testutil.IncludeIn;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.ComparableExpressionBase;
import com.querydsl.sql.AbstractBaseTest;
import com.querydsl.sql.AbstractSQLQuery;
import com.querydsl.sql.Constants;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLSerializer;
import com.querydsl.sql.SkipForQuoted;
import com.querydsl.sql.domain.QEmployee;
import com.querydsl.sql.oracle.OracleGrammar;
import com.querydsl.sql.oracle.OracleQuery;
import java.sql.SQLException;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class SelectOracleBase
extends AbstractBaseTest {
    private static final Logger logger = Logger.getLogger(AbstractSQLQuery.class.getName());

    protected OracleQuery<?> oracleQuery() {
        return new OracleQuery<Void>(this.connection, this.configuration){

            protected SQLSerializer serialize(boolean forCountRow) {
                SQLSerializer serializer = super.serialize(forCountRow);
                String rv = serializer.toString();
                if (SelectOracleBase.this.expectedQuery != null) {
                    Assert.assertEquals((Object)SelectOracleBase.this.expectedQuery, (Object)rv.replace('\n', ' '));
                    SelectOracleBase.this.expectedQuery = null;
                }
                logger.fine(rv);
                return serializer;
            }
        };
    }

    @Test
    @Ignore
    public void connectBy() throws SQLException {
        ((OracleQuery)((OracleQuery)((OracleQuery)this.oracleQuery().from((Expression)Constants.employee)).where((Predicate)OracleGrammar.level.eq((Object)-1))).connectBy((Predicate)OracleGrammar.level.lt((Number)1000))).select(Constants.employee.id).fetch();
    }

    @Test
    @IncludeIn(value={Target.ORACLE})
    @SkipForQuoted
    public void connectByPrior() throws SQLException {
        this.expectedQuery = "select e.ID, e.LASTNAME, e.SUPERIOR_ID from EMPLOYEE e connect by prior e.ID = e.SUPERIOR_ID";
        ((OracleQuery)((OracleQuery)this.oracleQuery().from((Expression)Constants.employee)).connectByPrior((Predicate)Constants.employee.id.eq(Constants.employee.superiorId))).select(new Expression[]{Constants.employee.id, Constants.employee.lastname, Constants.employee.superiorId}).fetch();
    }

    @Test
    @IncludeIn(value={Target.ORACLE})
    @SkipForQuoted
    public void connectByPrior2() throws SQLException {
        if (this.configuration.getUseLiterals()) {
            return;
        }
        this.expectedQuery = "select e.ID, e.LASTNAME, e.SUPERIOR_ID from EMPLOYEE e start with e.ID = ? connect by prior e.ID = e.SUPERIOR_ID";
        ((OracleQuery)((OracleQuery)((OracleQuery)this.oracleQuery().from((Expression)Constants.employee)).startWith((Predicate)Constants.employee.id.eq((Object)1))).connectByPrior((Predicate)Constants.employee.id.eq(Constants.employee.superiorId))).select(new Expression[]{Constants.employee.id, Constants.employee.lastname, Constants.employee.superiorId}).fetch();
    }

    @Test
    @IncludeIn(value={Target.ORACLE})
    @SkipForQuoted
    public void connectByPrior3() throws SQLException {
        if (this.configuration.getUseLiterals()) {
            return;
        }
        this.expectedQuery = "select e.ID, e.LASTNAME, e.SUPERIOR_ID from EMPLOYEE e start with e.ID = ? connect by prior e.ID = e.SUPERIOR_ID order siblings by e.LASTNAME";
        ((OracleQuery)((OracleQuery)((OracleQuery)((OracleQuery)this.oracleQuery().from((Expression)Constants.employee)).startWith((Predicate)Constants.employee.id.eq((Object)1))).connectByPrior((Predicate)Constants.employee.id.eq(Constants.employee.superiorId))).orderSiblingsBy((Expression)Constants.employee.lastname)).select(new Expression[]{Constants.employee.id, Constants.employee.lastname, Constants.employee.superiorId}).fetch();
    }

    @Test
    @IncludeIn(value={Target.ORACLE})
    @SkipForQuoted
    public void connectByPrior4() throws SQLException {
        if (this.configuration.getUseLiterals()) {
            return;
        }
        this.expectedQuery = "select e.ID, e.LASTNAME, e.SUPERIOR_ID from EMPLOYEE e connect by nocycle prior e.ID = e.SUPERIOR_ID";
        ((OracleQuery)((OracleQuery)this.oracleQuery().from((Expression)Constants.employee)).connectByNocyclePrior((Predicate)Constants.employee.id.eq(Constants.employee.superiorId))).select(new Expression[]{Constants.employee.id, Constants.employee.lastname, Constants.employee.superiorId}).fetch();
    }

    @Test
    @IncludeIn(value={Target.ORACLE})
    @SkipForQuoted
    public void sumOver() throws SQLException {
        this.expectedQuery = "select e.LASTNAME, e.SALARY, sum(e.SALARY) over (partition by e.SUPERIOR_ID order by e.LASTNAME asc, e.SALARY asc), sum(e.SALARY) over (order by e.SUPERIOR_ID asc, e.SALARY asc), sum(e.SALARY) over () from EMPLOYEE e order by e.SALARY asc, e.SUPERIOR_ID asc";
        ((OracleQuery)((OracleQuery)this.oracleQuery().from((Expression)Constants.employee)).orderBy(new OrderSpecifier[]{Constants.employee.salary.asc(), Constants.employee.superiorId.asc()})).select(new Expression[]{Constants.employee.lastname, Constants.employee.salary, SQLExpressions.sum(Constants.employee.salary).over().partitionBy(Constants.employee.superiorId).orderBy(new ComparableExpressionBase[]{Constants.employee.lastname, Constants.employee.salary}), SQLExpressions.sum(Constants.employee.salary).over().orderBy(new ComparableExpressionBase[]{Constants.employee.superiorId, Constants.employee.salary}), SQLExpressions.sum(Constants.employee.salary).over()}).fetch();
        QEmployee e = Constants.employee;
        ((OracleQuery)((OracleQuery)this.oracleQuery().from((Expression)e)).orderBy(new OrderSpecifier[]{e.salary.asc(), e.superiorId.asc()})).select(new Expression[]{e.lastname, e.salary, SQLExpressions.sum(e.salary).over().partitionBy(e.superiorId).orderBy(new ComparableExpressionBase[]{e.lastname, e.salary}), SQLExpressions.sum(e.salary).over().orderBy(new ComparableExpressionBase[]{e.superiorId, e.salary}), SQLExpressions.sum(e.salary).over()}).fetch();
    }
}

