/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.Target;
import com.querydsl.core.Tuple;
import com.querydsl.core.testutil.ExcludeIn;
import com.querydsl.core.testutil.IncludeIn;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.core.types.dsl.Wildcard;
import com.querydsl.sql.AbstractBaseTest;
import com.querydsl.sql.Constants;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.WindowOver;
import com.querydsl.sql.teradata.TeradataQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Test;

public class SelectWindowFunctionsBase
extends AbstractBaseTest {
    @Test
    @ExcludeIn(value={Target.SQLSERVER})
    public void windowFunctions() {
        NumberPath<Integer> path = Constants.survey.id;
        NumberPath<Integer> path2 = Constants.survey.id;
        ArrayList exprs = new ArrayList();
        this.add(exprs, SQLExpressions.avg(path), new Target[0]);
        this.add(exprs, SQLExpressions.count(path), new Target[0]);
        this.add(exprs, SQLExpressions.corr(path, path2), new Target[0]);
        this.add(exprs, SQLExpressions.covarPop(path, path2), Target.DB2);
        this.add(exprs, SQLExpressions.covarSamp(path, path2), Target.DB2);
        this.add(exprs, SQLExpressions.cumeDist(), Target.DB2, Target.TERADATA);
        this.add(exprs, SQLExpressions.denseRank(), Target.TERADATA);
        this.add(exprs, SQLExpressions.firstValue(path), Target.TERADATA);
        this.add(exprs, SQLExpressions.lag(path), Target.TERADATA);
        this.add(exprs, SQLExpressions.lastValue(path), Target.TERADATA);
        this.add(exprs, SQLExpressions.lead(path), Target.TERADATA);
        this.add(exprs, SQLExpressions.max(path), new Target[0]);
        this.add(exprs, SQLExpressions.min(path), new Target[0]);
        this.add(exprs, SQLExpressions.nthValue(path, (Number)2), Target.DB2, Target.TERADATA);
        this.add(exprs, SQLExpressions.ntile((Number)3), Target.DB2, Target.TERADATA);
        this.add(exprs, SQLExpressions.percentRank(), Target.DB2);
        this.add(exprs, SQLExpressions.rank(), new Target[0]);
        this.add(exprs, SQLExpressions.rowNumber(), new Target[0]);
        this.add(exprs, SQLExpressions.stddev(path), Target.TERADATA);
        this.add(exprs, SQLExpressions.stddevPop(path), Target.DB2, Target.TERADATA);
        this.add(exprs, SQLExpressions.stddevSamp(path), Target.DB2, Target.TERADATA);
        this.add(exprs, SQLExpressions.sum(path), new Target[0]);
        this.add(exprs, SQLExpressions.variance(path), Target.TERADATA);
        this.add(exprs, SQLExpressions.varPop(path), Target.DB2, Target.TERADATA);
        this.add(exprs, SQLExpressions.varSamp(path), Target.DB2, Target.TERADATA);
        for (WindowOver wo : exprs) {
            ((SQLQuery)this.query().from((Expression)Constants.survey)).select((Expression)wo.over().partitionBy((Expression)Constants.survey.name).orderBy(Constants.survey.id)).fetch();
        }
    }

    @Test
    public void windowFunctions_manual_paging() {
        SimpleExpression rowNumber = SQLExpressions.rowNumber().over().orderBy(Constants.employee.lastname.asc()).as("rn");
        Expression all = Wildcard.all;
        System.out.println("#1");
        for (Tuple row : ((SQLQuery)this.query().from((Expression)Constants.employee)).select(new Expression[]{Constants.employee.firstname, Constants.employee.lastname, rowNumber}).fetch()) {
            System.out.println(row);
        }
        System.out.println();
        System.out.println("#2");
        SQLQuery sub = ((SQLQuery)this.query().from((Expression)Constants.employee)).select(new Expression[]{Constants.employee.firstname, Constants.employee.lastname, rowNumber});
        SimplePath subAlias = Expressions.path(Tuple.class, (String)"s");
        for (Object[] row : ((SQLQuery)this.query().from((Expression)sub.as((Path)subAlias))).select(all).fetch()) {
            System.out.println(Arrays.asList(row));
        }
        System.out.println();
        System.out.println("#3");
        SQLQuery sub2 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)rowNumber);
        SimplePath subAlias2 = Expressions.path(Long.class, (String)"s");
        for (Object[] row : ((SQLQuery)this.query().from((Expression)sub2.as((Path)subAlias2))).select(all).fetch()) {
            System.out.println(Arrays.asList(row));
        }
        System.out.println();
        System.out.println("#4");
        SQLQuery sub3 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select(new Expression[]{Constants.employee.firstname, Constants.employee.lastname, rowNumber});
        for (Tuple row : ((SQLQuery)this.query().from((Expression)sub3.as((Path)Constants.employee2))).select(new Expression[]{Constants.employee2.firstname, Constants.employee2.lastname}).fetch()) {
            System.out.println(Collections.singletonList(row));
        }
    }

    @Test
    @IncludeIn(value={Target.ORACLE})
    public void windowFunctions_keep() {
        ArrayList exprs = new ArrayList();
        NumberPath<Integer> path = Constants.survey.id;
        this.add(exprs, SQLExpressions.avg(path), new Target[0]);
        this.add(exprs, SQLExpressions.count(path), new Target[0]);
        this.add(exprs, SQLExpressions.max(path), new Target[0]);
        this.add(exprs, SQLExpressions.min(path), new Target[0]);
        this.add(exprs, SQLExpressions.stddev(path), new Target[0]);
        this.add(exprs, SQLExpressions.variance(path), new Target[0]);
        for (WindowOver wo : exprs) {
            ((SQLQuery)this.query().from((Expression)Constants.survey)).select((Expression)wo.keepFirst().orderBy(Constants.survey.id)).fetch();
        }
    }

    @Test
    @ExcludeIn(value={Target.DB2, Target.SQLSERVER})
    public void windowFunctions_regr() {
        ArrayList exprs = new ArrayList();
        NumberPath<Integer> path = Constants.survey.id;
        NumberPath<Integer> path2 = Constants.survey.id;
        this.add(exprs, SQLExpressions.regrSlope(path, path2), Target.SQLSERVER);
        this.add(exprs, SQLExpressions.regrIntercept(path, path2), new Target[0]);
        this.add(exprs, SQLExpressions.regrCount(path, path2), new Target[0]);
        this.add(exprs, SQLExpressions.regrR2(path, path2), new Target[0]);
        this.add(exprs, SQLExpressions.regrAvgx(path, path2), new Target[0]);
        this.add(exprs, SQLExpressions.regrSxx(path, path2), new Target[0]);
        this.add(exprs, SQLExpressions.regrSyy(path, path2), new Target[0]);
        this.add(exprs, SQLExpressions.regrSxy(path, path2), new Target[0]);
        for (WindowOver wo : exprs) {
            ((SQLQuery)this.query().from((Expression)Constants.survey)).select((Expression)wo.over().partitionBy((Expression)Constants.survey.name).orderBy(Constants.survey.id)).fetch();
        }
    }

    @Test
    @IncludeIn(value={Target.ORACLE})
    public void windowFunctions_oracle() {
        ArrayList exprs = new ArrayList();
        NumberPath<Integer> path = Constants.survey.id;
        this.add(exprs, SQLExpressions.countDistinct(path), new Target[0]);
        this.add(exprs, SQLExpressions.ratioToReport(path), new Target[0]);
        this.add(exprs, SQLExpressions.stddevDistinct(path), new Target[0]);
        for (WindowOver wo : exprs) {
            ((SQLQuery)this.query().from((Expression)Constants.survey)).select((Expression)wo.over().partitionBy((Expression)Constants.survey.name)).fetch();
        }
    }

    @Test
    public void windowFunctions_over() {
        ((SQLQuery)this.query().from((Expression)Constants.employee)).select(new Expression[]{Constants.employee.id, SQLExpressions.sum(Constants.employee.salary).over()}).fetch();
    }

    @Test
    public void windowFunctions_partitionBy() {
        ((SQLQuery)this.query().from((Expression)Constants.employee)).select(new Expression[]{Constants.employee.id, Constants.employee.superiorId, SQLExpressions.sum(Constants.employee.salary).over().partitionBy(Constants.employee.superiorId)}).fetch();
    }

    @Test
    @ExcludeIn(value={Target.SQLSERVER})
    public void windowFunctions_orderBy() {
        ((SQLQuery)this.query().from((Expression)Constants.employee)).select(new Expression[]{Constants.employee.id, SQLExpressions.sum(Constants.employee.salary).over().partitionBy(Constants.employee.superiorId).orderBy(Constants.employee.datefield)}).fetch();
    }

    @Test
    @ExcludeIn(value={Target.SQLSERVER})
    public void windowFunctions_unboundedRows() {
        ((SQLQuery)this.query().from((Expression)Constants.employee)).select(new Expression[]{Constants.employee.id, SQLExpressions.sum(Constants.employee.salary).over().partitionBy(Constants.employee.superiorId).orderBy(Constants.employee.datefield).rows().between().unboundedPreceding().currentRow()}).fetch();
    }

    @Test
    @IncludeIn(value={Target.TERADATA})
    public void windowFunctions_qualify() {
        ((TeradataQuery)this.teradataQuery().from((Expression)Constants.employee)).qualify((Predicate)SQLExpressions.rank().over().partitionBy(Constants.employee.superiorId).orderBy(Constants.employee.datefield).eq((Object)1L)).select(new Expression[]{Constants.employee.id, SQLExpressions.sum(Constants.employee.salary).over()}).fetch();
    }
}

