/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.HSQLDBTemplates;
import com.querydsl.sql.ProjectableSQLQuery;
import com.querydsl.sql.RelationalFunctionCall;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLSerializer;
import com.querydsl.sql.SQLServerTemplates;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.Survey;
import com.querydsl.sql.Union;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import com.querydsl.sql.domain.QEmployee;
import com.querydsl.sql.domain.QSurvey;
import java.sql.Connection;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class SerializationTest {
    private static final QSurvey survey = QSurvey.survey;
    private final Connection connection = (Connection)EasyMock.createMock(Connection.class);

    @Test
    public void innerJoin() {
        SQLQuery query = new SQLQuery(this.connection, SQLTemplates.DEFAULT);
        ((SQLQuery)query.from((Expression)new QSurvey("s1"))).innerJoin((EntityPath)new QSurvey("s2"));
        Assert.assertEquals((Object)"from SURVEY s1\ninner join SURVEY s2", (Object)query.toString());
    }

    @Test
    public void leftJoin() {
        SQLQuery query = new SQLQuery(this.connection, SQLTemplates.DEFAULT);
        ((SQLQuery)query.from((Expression)new QSurvey("s1"))).leftJoin((EntityPath)new QSurvey("s2"));
        Assert.assertEquals((Object)"from SURVEY s1\nleft join SURVEY s2", (Object)query.toString());
    }

    @Test
    public void rightJoin() {
        SQLQuery query = new SQLQuery(this.connection, SQLTemplates.DEFAULT);
        ((SQLQuery)query.from((Expression)new QSurvey("s1"))).rightJoin((EntityPath)new QSurvey("s2"));
        Assert.assertEquals((Object)"from SURVEY s1\nright join SURVEY s2", (Object)query.toString());
    }

    @Test
    public void fullJoin() {
        SQLQuery query = new SQLQuery(this.connection, SQLTemplates.DEFAULT);
        ((SQLQuery)query.from((Expression)new QSurvey("s1"))).fullJoin((EntityPath)new QSurvey("s2"));
        Assert.assertEquals((Object)"from SURVEY s1\nfull join SURVEY s2", (Object)query.toString());
    }

    @Test
    public void update() {
        SQLUpdateClause updateClause = new SQLUpdateClause(this.connection, SQLTemplates.DEFAULT, (RelationalPath)survey);
        updateClause.set(SerializationTest.survey.id, (Object)1);
        updateClause.set((Path)SerializationTest.survey.name, (Object)null);
        Assert.assertEquals((Object)"update SURVEY\nset ID = ?, NAME = ?", (Object)updateClause.toString());
    }

    @Test
    public void update_where() {
        SQLUpdateClause updateClause = new SQLUpdateClause(this.connection, SQLTemplates.DEFAULT, (RelationalPath)survey);
        updateClause.set(SerializationTest.survey.id, (Object)1);
        updateClause.set((Path)SerializationTest.survey.name, (Object)null);
        updateClause.where((Predicate)SerializationTest.survey.name.eq((Object)"XXX"));
        Assert.assertEquals((Object)"update SURVEY\nset ID = ?, NAME = ?\nwhere SURVEY.NAME = ?", (Object)updateClause.toString());
    }

    @Test
    public void insert() {
        SQLInsertClause insertClause = new SQLInsertClause(this.connection, SQLTemplates.DEFAULT, (RelationalPath)survey);
        insertClause.set(SerializationTest.survey.id, (Object)1);
        insertClause.set((Path)SerializationTest.survey.name, (Object)null);
        Assert.assertEquals((Object)"insert into SURVEY (ID, NAME)\nvalues (?, ?)", (Object)insertClause.toString());
    }

    @Test
    public void delete_with_subQuery_exists() {
        QSurvey survey1 = new QSurvey("s1");
        QEmployee employee = new QEmployee("e");
        SQLDeleteClause delete = new SQLDeleteClause(this.connection, SQLTemplates.DEFAULT, (RelationalPath)survey1);
        delete.where(new Predicate[]{survey1.name.eq((Object)"XXX"), ((SQLQuery)((SQLQuery)SQLExpressions.selectOne().from((Expression)employee)).where((Predicate)survey1.id.eq(employee.id))).exists()});
        Assert.assertEquals((Object)"delete from SURVEY\nwhere SURVEY.NAME = ? and exists (select 1\nfrom EMPLOYEE e\nwhere SURVEY.ID = e.ID)", (Object)delete.toString());
    }

    @Test
    public void nextval() {
        ProjectableSQLQuery sq = SQLExpressions.select((Expression)SQLExpressions.nextval((String)"myseq")).from((Expression)QSurvey.survey);
        SQLSerializer serializer = new SQLSerializer(Configuration.DEFAULT);
        serializer.serialize(sq.getMetadata(), false);
        Assert.assertEquals((Object)"select nextval('myseq')\nfrom SURVEY SURVEY", (Object)serializer.toString());
    }

    @Test
    public void functionCall() {
        RelationalFunctionCall func = SQLExpressions.relationalFunctionCall(String.class, (String)"TableValuedFunction", (Object[])new Object[]{"parameter"});
        PathBuilder funcAlias = new PathBuilder(String.class, "tokFunc");
        ProjectableSQLQuery expr = ((SQLQuery)((SQLQuery)SQLExpressions.select((Expression)SerializationTest.survey.name).from((Expression)survey)).join(func, (Path)funcAlias)).on((Predicate)SerializationTest.survey.name.like((Expression)funcAlias.getString("prop")).not());
        SQLSerializer serializer = new SQLSerializer(new Configuration((SQLTemplates)new SQLServerTemplates()));
        serializer.serialize(expr.getMetadata(), false);
        Assert.assertEquals((Object)"select SURVEY.NAME\nfrom SURVEY SURVEY\njoin TableValuedFunction(?) as tokFunc\non not (SURVEY.NAME like tokFunc.prop escape '\\')", (Object)serializer.toString());
    }

    @Test
    public void functionCall2() {
        RelationalFunctionCall func = SQLExpressions.relationalFunctionCall(String.class, (String)"TableValuedFunction", (Object[])new Object[]{"parameter"});
        PathBuilder funcAlias = new PathBuilder(String.class, "tokFunc");
        SQLQuery q = new SQLQuery((SQLTemplates)SQLServerTemplates.DEFAULT);
        ((SQLQuery)((SQLQuery)q.from((Expression)survey)).join(func, (Path)funcAlias)).on((Predicate)SerializationTest.survey.name.like((Expression)funcAlias.getString("prop")).not());
        Assert.assertEquals((Object)"from SURVEY SURVEY\njoin TableValuedFunction(?) as tokFunc\non not (SURVEY.NAME like tokFunc.prop escape '\\')", (Object)q.toString());
    }

    @Test
    public void functionCall3() {
        RelationalFunctionCall func = SQLExpressions.relationalFunctionCall(String.class, (String)"TableValuedFunction", (Object[])new Object[]{"parameter"});
        PathBuilder funcAlias = new PathBuilder(String.class, "tokFunc");
        SQLQuery q = new SQLQuery((SQLTemplates)HSQLDBTemplates.DEFAULT);
        ((SQLQuery)((SQLQuery)q.from((Expression)survey)).join(func, (Path)funcAlias)).on((Predicate)SerializationTest.survey.name.like((Expression)funcAlias.getString("prop")).not());
        Assert.assertEquals((Object)"from SURVEY SURVEY\njoin table(TableValuedFunction(?)) as tokFunc\non not (SURVEY.NAME like tokFunc.prop escape '\\')", (Object)q.toString());
    }

    @Test
    public void union1() {
        Union q = SQLExpressions.union((SubQueryExpression[])new SubQueryExpression[]{SQLExpressions.select((Expression[])survey.all()).from((Expression)survey), SQLExpressions.select((Expression[])survey.all()).from((Expression)survey)});
        Assert.assertEquals((Object)"(select SURVEY.NAME, SURVEY.NAME2, SURVEY.ID\nfrom SURVEY SURVEY)\nunion\n(select SURVEY.NAME, SURVEY.NAME2, SURVEY.ID\nfrom SURVEY SURVEY)", (Object)q.toString());
    }

    @Test
    public void union1_groupBy() {
        Union q = SQLExpressions.union((SubQueryExpression[])new SubQueryExpression[]{SQLExpressions.select((Expression[])survey.all()).from((Expression)survey), SQLExpressions.select((Expression[])survey.all()).from((Expression)survey)}).groupBy(new Expression[]{SerializationTest.survey.id});
        Assert.assertEquals((Object)"(select SURVEY.NAME, SURVEY.NAME2, SURVEY.ID\nfrom SURVEY SURVEY)\nunion\n(select SURVEY.NAME, SURVEY.NAME2, SURVEY.ID\nfrom SURVEY SURVEY)\ngroup by SURVEY.ID", (Object)q.toString());
    }

    @Test
    public void union2() {
        ProjectableSQLQuery q = new SQLQuery().union((Path)survey, new SubQueryExpression[]{SQLExpressions.select((Expression[])survey.all()).from((Expression)survey), SQLExpressions.select((Expression[])survey.all()).from((Expression)survey)});
        Assert.assertEquals((Object)"from ((select SURVEY.NAME, SURVEY.NAME2, SURVEY.ID\nfrom SURVEY SURVEY)\nunion\n(select SURVEY.NAME, SURVEY.NAME2, SURVEY.ID\nfrom SURVEY SURVEY)) as SURVEY", (Object)q.toString());
    }

    @Test
    public void with() {
        QSurvey survey2 = new QSurvey("survey2");
        SQLQuery q = new SQLQuery();
        q.with((Path)survey, new Path[]{SerializationTest.survey.id, SerializationTest.survey.name}).as((Expression)SQLExpressions.select((Expression[])new Expression[]{survey2.id, survey2.name}).from((Expression)survey2));
        Assert.assertEquals((Object)"with SURVEY (ID, NAME) as (select survey2.ID, survey2.NAME\nfrom SURVEY survey2)\n\nfrom dual", (Object)q.toString());
    }

    @Test
    public void with_complex() {
        QSurvey s = new QSurvey("s");
        SQLQuery q = new SQLQuery();
        ((SQLQuery)q.with((Path)s, new Path[]{s.id, s.name}).as((Expression)SQLExpressions.select((Expression[])new Expression[]{SerializationTest.survey.id, SerializationTest.survey.name}).from((Expression)survey))).select(new Expression[]{s.id, s.name, SerializationTest.survey.id, SerializationTest.survey.name}).from(new Expression[]{s, survey});
        Assert.assertEquals((Object)"with s (ID, NAME) as (select SURVEY.ID, SURVEY.NAME\nfrom SURVEY SURVEY)\nselect s.ID, s.NAME, SURVEY.ID, SURVEY.NAME\nfrom s s, SURVEY SURVEY", (Object)q.toString());
    }

    @Test
    public void with_tuple() {
        PathBuilder survey = new PathBuilder(Survey.class, "SURVEY");
        QSurvey survey2 = new QSurvey("survey2");
        SQLQuery q = new SQLQuery();
        q.with((Path)survey, new Path[]{survey.get(survey2.id), survey.get(survey2.name)}).as((Expression)SQLExpressions.select((Expression[])new Expression[]{survey2.id, survey2.name}).from((Expression)survey2));
        Assert.assertEquals((Object)"with SURVEY (ID, NAME) as (select survey2.ID, survey2.NAME\nfrom SURVEY survey2)\n\nfrom dual", (Object)q.toString());
    }

    @Test
    public void with_tuple2() {
        QSurvey survey2 = new QSurvey("survey2");
        SQLQuery q = new SQLQuery();
        q.with((Path)survey, new Path[]{SerializationTest.survey.id, SerializationTest.survey.name}).as((Expression)SQLExpressions.select((Expression[])new Expression[]{survey2.id, survey2.name}).from((Expression)survey2));
        Assert.assertEquals((Object)"with SURVEY (ID, NAME) as (select survey2.ID, survey2.NAME\nfrom SURVEY survey2)\n\nfrom dual", (Object)q.toString());
    }

    @Test
    public void with_singleColumn() {
        QSurvey survey2 = new QSurvey("survey2");
        SQLQuery q = new SQLQuery();
        q.with((Path)survey, new Path[]{SerializationTest.survey.id}).as((Expression)SQLExpressions.select(survey2.id).from((Expression)survey2));
        Assert.assertEquals((Object)"with SURVEY (ID) as (select survey2.ID\nfrom SURVEY survey2)\n\nfrom dual", (Object)q.toString());
    }
}

