/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.testutil.EmptyStatement;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.SkipForQuoted;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class SkipForQuotedRule
implements MethodRule {
    private final Configuration configuration;

    public SkipForQuotedRule(Configuration conf) {
        this.configuration = conf;
    }

    public Statement apply(Statement base, FrameworkMethod method, Object target) {
        SQLTemplates templates = this.configuration.getTemplates();
        if (templates.isUseQuotes() || templates.isPrintSchema() || this.configuration.getUseLiterals()) {
            boolean skip = method.getMethod().isAnnotationPresent(SkipForQuoted.class);
            return skip ? EmptyStatement.DEFAULT : base;
        }
        return base;
    }
}

