/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class StoredProcedures {
    private StoredProcedures() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws ClassNotFoundException, SQLException {
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        String url = "jdbc:derby:target/procedure_test;create=true";
        try (Connection connection = DriverManager.getConnection(url, "", "");){
            DatabaseMetaData md = connection.getMetaData();
            try (ResultSet procedures = md.getProcedures(null, null, null);){
                while (procedures.next()) {
                    String cat = procedures.getString(1);
                    String schema = procedures.getString(2);
                    String name = procedures.getString(3);
                    String remarks = procedures.getString(7);
                    String type = procedures.getString(8);
                    String specificName = procedures.getString(9);
                    System.out.println(name + "\n" + remarks + "\n" + type + "\n" + specificName);
                    ResultSet procedureColumns = md.getProcedureColumns(cat, schema, name, null);
                    try {
                        while (procedureColumns.next()) {
                            String columnName = procedureColumns.getString(4);
                            int columnType = procedureColumns.getInt(5);
                            int dataType = procedureColumns.getInt(6);
                            String typeName = procedureColumns.getString(7);
                            short nullable = procedureColumns.getShort(12);
                            System.out.println(" " + columnName + " " + columnType + " " + dataType + " " + typeName + " " + nullable);
                        }
                        System.out.println();
                    }
                    finally {
                        if (procedureColumns == null) continue;
                        procedureColumns.close();
                    }
                }
                return;
            }
        }
    }
}

