/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.Target;
import com.querydsl.core.testutil.ExcludeIn;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.Param;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.Wildcard;
import com.querydsl.sql.AbstractBaseTest;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.Constants;
import com.querydsl.sql.ForeignKey;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLSerializer;
import com.querydsl.sql.SkipForQuoted;
import com.querydsl.sql.domain.QEmployee;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class SubqueriesBase
extends AbstractBaseTest {
    @Test
    @ExcludeIn(value={Target.CUBRID, Target.DERBY, Target.FIREBIRD, Target.H2, Target.HSQLDB, Target.SQLITE, Target.SQLSERVER})
    public void keys() {
        QEmployee employee2 = new QEmployee("employee2");
        ForeignKey nameKey1 = new ForeignKey((RelationalPath)Constants.employee, Arrays.asList(Constants.employee.firstname, Constants.employee.lastname), Arrays.asList("a", "b"));
        ForeignKey nameKey2 = new ForeignKey((RelationalPath)Constants.employee, Arrays.asList(Constants.employee.firstname, Constants.employee.lastname), Arrays.asList("a", "b"));
        ((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)nameKey1.in((SubQueryExpression)((SQLQuery)this.query().from((Expression)employee2)).select(nameKey2.getProjection())))).select(Constants.employee.id).fetch();
    }

    @Test
    @ExcludeIn(value={Target.CUBRID, Target.DERBY, Target.FIREBIRD, Target.H2, Target.HSQLDB, Target.SQLITE, Target.SQLSERVER})
    public void list_in_query() {
        QEmployee employee2 = new QEmployee("employee2");
        ((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Expressions.list((SimpleExpression[])new SimpleExpression[]{Constants.employee.id, Constants.employee.lastname}).in((SubQueryExpression)((SQLQuery)this.query().from((Expression)employee2)).select(new Expression[]{employee2.id, employee2.lastname})))).select(Constants.employee.id).fetch();
    }

    @Test
    @SkipForQuoted
    @ExcludeIn(value={Target.DB2})
    public void subQueries() throws SQLException {
        this.expectedQuery = "select e.ID from EMPLOYEE e where e.ID = (select max(e.ID) from EMPLOYEE e)";
        List list = ((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.id.eq((Expression)((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.id.max())))).select(Constants.employee.id).fetch();
        Assert.assertFalse((boolean)list.isEmpty());
    }

    @Test
    public void subQuery_alias() {
        ((SQLQuery)this.query().from((Expression)((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression[])Constants.employee.all()).as((Path)Constants.employee2))).select((Expression[])Constants.employee2.all()).fetch();
    }

    @Test
    @ExcludeIn(value={Target.SQLITE})
    public void subQuery_all() {
        ((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.id.gtAll((SubQueryExpression)((SQLQuery)this.query().from((Expression)Constants.employee2)).select(Constants.employee2.id)))).fetchCount();
    }

    @Test
    @ExcludeIn(value={Target.SQLITE})
    public void subQuery_any() {
        ((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.id.gtAny((SubQueryExpression)((SQLQuery)this.query().from((Expression)Constants.employee2)).select(Constants.employee2.id)))).fetchCount();
    }

    @Test
    public void subQuery_innerJoin() {
        SQLQuery sq = ((SQLQuery)this.query().from((Expression)Constants.employee2)).select(Constants.employee2.id);
        QEmployee sqEmp = new QEmployee("sq");
        ((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).innerJoin((SubQueryExpression)sq, (Path)sqEmp)).on((Predicate)sqEmp.id.eq(Constants.employee.id))).select(Constants.employee.id).fetch();
    }

    @Test
    public void subQuery_leftJoin() {
        SQLQuery sq = ((SQLQuery)this.query().from((Expression)Constants.employee2)).select(Constants.employee2.id);
        QEmployee sqEmp = new QEmployee("sq");
        ((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).leftJoin((SubQueryExpression)sq, (Path)sqEmp)).on((Predicate)sqEmp.id.eq(Constants.employee.id))).select(Constants.employee.id).fetch();
    }

    @Test
    @ExcludeIn(value={Target.MYSQL, Target.POSTGRESQL, Target.DERBY, Target.SQLSERVER, Target.TERADATA})
    public void subQuery_params() {
        Param aParam = new Param(String.class, "param");
        SQLQuery subQuery = (SQLQuery)((SQLQuery)SQLExpressions.select((Expression)Wildcard.all).from((Expression)Constants.employee)).where((Predicate)Constants.employee.firstname.eq((Expression)aParam));
        subQuery.set((ParamExpression)aParam, (Object)"Mike");
        Assert.assertEquals((long)1L, (long)((SQLQuery)this.query().from((Expression)subQuery)).fetchCount());
    }

    @Test
    @ExcludeIn(value={Target.SQLITE})
    public void subQuery_rightJoin() {
        SQLQuery sq = ((SQLQuery)this.query().from((Expression)Constants.employee2)).select(Constants.employee2.id);
        QEmployee sqEmp = new QEmployee("sq");
        ((SQLQuery)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).rightJoin((SubQueryExpression)sq, (Path)sqEmp)).on((Predicate)sqEmp.id.eq(Constants.employee.id))).select(Constants.employee.id).fetch();
    }

    @Test
    public void subQuery_with_alias() {
        List ids1 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select(Constants.employee.id).fetch();
        List ids2 = ((SQLQuery)this.query().from((SubQueryExpression)((SQLQuery)this.query().from((Expression)Constants.employee)).select(Constants.employee.id), (Path)Constants.employee)).select(Constants.employee.id).fetch();
        Assert.assertEquals((Object)ids1, (Object)ids2);
    }

    @Test
    public void subQuery_with_alias2() {
        List ids1 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select(Constants.employee.id).fetch();
        List ids2 = ((SQLQuery)this.query().from((Expression)((SQLQuery)this.query().from((Expression)Constants.employee)).select(Constants.employee.id).as((Path)Constants.employee))).select(Constants.employee.id).fetch();
        Assert.assertEquals((Object)ids1, (Object)ids2);
    }

    @Test
    @SkipForQuoted
    public void subQuerySerialization() {
        SQLQuery<?> query = this.query();
        query.from((Expression)Constants.survey);
        Assert.assertEquals((Object)"from SURVEY s", (Object)query.toString());
        query.from((Expression)Constants.survey2);
        Assert.assertEquals((Object)"from SURVEY s, SURVEY s2", (Object)query.toString());
    }

    @Test
    public void subQuerySerialization2() {
        NumberPath sal = Expressions.numberPath(BigDecimal.class, (String)"sal");
        PathBuilder sq = new PathBuilder(Object[].class, "sq");
        SQLSerializer serializer = new SQLSerializer(Configuration.DEFAULT);
        serializer.handle((Expression)((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.salary.add(Constants.employee.salary).add(Constants.employee.salary).as((Path)sal)).as((Path)sq));
        Assert.assertEquals((Object)"(select (e.SALARY + e.SALARY + e.SALARY) as sal\nfrom EMPLOYEE e) as sq", (Object)serializer.toString());
    }

    @Test
    public void scalarSubQueryInClause() {
        SQLSerializer serializer = new SQLSerializer(Configuration.DEFAULT);
        serializer.handle((Expression)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select((Expression)Constants.employee.firstname).from((Expression)Constants.employee)).orderBy(Constants.employee.salary.asc())).limit(1L)).in(Arrays.asList("Mike", "Mary"))));
        this.expectedQuery = "(\nfrom EMPLOYEE e\nwhere (select e.FIRSTNAME\nfrom EMPLOYEE e\norder by e.SALARY asc\nlimit ?) in (?, ?))";
        Assert.assertEquals((Object)this.expectedQuery, (Object)serializer.toString());
    }

    @Test
    public void scalarSubQueryInClause2() {
        SQLSerializer serializer = new SQLSerializer(Configuration.DEFAULT);
        serializer.handle((Expression)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select((Expression)Constants.employee.firstname).from((Expression)Constants.employee)).orderBy(Constants.employee.salary.asc())).limit(1L)).in((Object[])new String[]{"Mike", "Mary"})));
        this.expectedQuery = "(\nfrom EMPLOYEE e\nwhere (select e.FIRSTNAME\nfrom EMPLOYEE e\norder by e.SALARY asc\nlimit ?) in (?, ?))";
        Assert.assertEquals((Object)this.expectedQuery, (Object)serializer.toString());
    }
}

