/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.sql.AbstractSQLTemplatesTest;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.TeradataTemplates;
import org.junit.Assert;
import org.junit.Test;

public class TeradataTemplatesTest
extends AbstractSQLTemplatesTest {
    @Override
    protected SQLTemplates createTemplates() {
        return new TeradataTemplates();
    }

    @Test
    public void limit() {
        ((SQLQuery)this.query.from((Expression)survey1)).limit(5L);
        Assert.assertEquals((Object)"from SURVEY survey1 qualify row_number() over (order by 1) <= ?", (Object)this.query.toString());
    }

    @Test
    public void offset() {
        ((SQLQuery)this.query.from((Expression)survey1)).offset(5L);
        Assert.assertEquals((Object)"from SURVEY survey1 qualify row_number() over (order by 1) > ?", (Object)this.query.toString());
    }

    @Test
    public void limit_offset() {
        ((SQLQuery)((SQLQuery)this.query.from((Expression)survey1)).limit(5L)).offset(10L);
        Assert.assertEquals((Object)"from SURVEY survey1 qualify row_number() over (order by 1) between ? and ?", (Object)this.query.toString());
    }

    @Test
    public void orderBy_limit() {
        ((SQLQuery)((SQLQuery)this.query.from((Expression)survey1)).orderBy(TeradataTemplatesTest.survey1.name.asc())).limit(5L);
        Assert.assertEquals((Object)"from SURVEY survey1 order by survey1.NAME asc qualify row_number() over (order by survey1.NAME asc) <= ?", (Object)this.query.toString());
    }

    @Test
    public void precedence() {
        int p1 = this.getPrecedence(new Operator[]{Ops.NEGATE});
        int p2 = this.getPrecedence(new Operator[]{Ops.MULT, Ops.DIV, Ops.MOD});
        int p3 = this.getPrecedence(new Operator[]{Ops.ADD, Ops.SUB});
        int p4 = this.getPrecedence(new Operator[]{Ops.CONCAT});
        int p5 = this.getPrecedence(new Operator[]{Ops.EQ, Ops.NE, Ops.GT, Ops.LT, Ops.GOE, Ops.LOE, Ops.IN, Ops.NOT_IN, Ops.BETWEEN, Ops.LIKE, Ops.LIKE_ESCAPE});
        int p6 = this.getPrecedence(new Operator[]{Ops.NOT});
        int p7 = this.getPrecedence(new Operator[]{Ops.AND});
        int p8 = this.getPrecedence(new Operator[]{Ops.OR});
        Assert.assertTrue((p1 < p2 ? 1 : 0) != 0);
        Assert.assertTrue((p2 < p3 ? 1 : 0) != 0);
        Assert.assertTrue((p3 < p4 ? 1 : 0) != 0);
        Assert.assertTrue((p4 < p5 ? 1 : 0) != 0);
        Assert.assertTrue((p5 < p6 ? 1 : 0) != 0);
        Assert.assertTrue((p6 < p7 ? 1 : 0) != 0);
        Assert.assertTrue((p7 < p8 ? 1 : 0) != 0);
    }
}

