/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.QueryMetadata;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLDetailedListener;
import com.querydsl.sql.SQLListenerContext;
import com.querydsl.sql.dml.SQLInsertBatch;
import com.querydsl.sql.dml.SQLMergeBatch;
import com.querydsl.sql.dml.SQLUpdateBatch;
import java.util.List;
import java.util.Map;

public class TestLoggingListener
implements SQLDetailedListener {
    private static boolean enabled = false;

    public static void enable() {
        enabled = true;
    }

    public static void disable() {
        enabled = false;
    }

    public void start(SQLListenerContext context) {
        if (enabled) {
            System.out.println(String.format("\n\tstart %s", context));
        }
    }

    public void preRender(SQLListenerContext context) {
        if (enabled) {
            System.out.println(String.format("\t\tpreRender %s", context));
        }
    }

    public void rendered(SQLListenerContext context) {
        if (enabled) {
            System.out.println(String.format("\t\t\trendered %s", context));
        }
    }

    public void prePrepare(SQLListenerContext context) {
        if (enabled) {
            System.out.println(String.format("\t\tprePrepare %s", context));
        }
    }

    public void prepared(SQLListenerContext context) {
        if (enabled) {
            System.out.println(String.format("\t\t\tprepared %s", context));
        }
    }

    public void preExecute(SQLListenerContext context) {
        if (enabled) {
            System.out.println(String.format("\t\tpreExecute %s", context));
        }
    }

    public void executed(SQLListenerContext context) {
        if (enabled) {
            System.out.println(String.format("\t\t\texecuted %s", context));
        }
    }

    public void exception(SQLListenerContext context) {
        if (enabled) {
            System.out.println(String.format("\t\texception %s", context));
        }
    }

    public void end(SQLListenerContext context) {
        if (enabled) {
            System.out.println(String.format("\tend %s\n\n", context));
        }
    }

    public void notifyQuery(QueryMetadata md) {
        if (enabled) {
            System.out.println(String.format("\t\t\tnotifyQuery %s", md));
        }
    }

    public void notifyDelete(RelationalPath<?> entity, QueryMetadata md) {
        if (enabled) {
            System.out.println(String.format("\t\t\tnotifyDelete %s", entity));
        }
    }

    public void notifyDeletes(RelationalPath<?> entity, List<QueryMetadata> batches) {
        if (enabled) {
            System.out.println(String.format("\t\t\tnotifyDeletes %s", entity));
        }
    }

    public void notifyMerge(RelationalPath<?> entity, QueryMetadata md, List<Path<?>> keys, List<Path<?>> columns, List<Expression<?>> values, SubQueryExpression<?> subQuery) {
        if (enabled) {
            System.out.println(String.format("\t\t\tnotifyMerge %s", entity));
        }
    }

    public void notifyMerges(RelationalPath<?> entity, QueryMetadata md, List<SQLMergeBatch> batches) {
        if (enabled) {
            System.out.println(String.format("\t\t\tnotifyMerges %s", entity));
        }
    }

    public void notifyInsert(RelationalPath<?> entity, QueryMetadata md, List<Path<?>> columns, List<Expression<?>> values, SubQueryExpression<?> subQuery) {
        if (enabled) {
            System.out.println(String.format("\t\t\tnotifyInsert %s", entity));
        }
    }

    public void notifyInserts(RelationalPath<?> entity, QueryMetadata md, List<SQLInsertBatch> batches) {
        if (enabled) {
            System.out.println(String.format("\t\t\tnotifyInserts %s", entity));
        }
    }

    public void notifyUpdate(RelationalPath<?> entity, QueryMetadata md, Map<Path<?>, Expression<?>> updates) {
        if (enabled) {
            System.out.println(String.format("\t\t\tnotifyUpdate %s", entity));
        }
    }

    public void notifyUpdates(RelationalPath<?> entity, List<SQLUpdateBatch> batches) {
        if (enabled) {
            System.out.println(String.format("\t\t\tnotifyUpdates %s", entity));
        }
    }
}

