/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.Target;
import com.querydsl.core.testutil.ExcludeIn;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.sql.AbstractBaseTest;
import com.querydsl.sql.Connections;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.ddl.CreateTableClause;
import com.querydsl.sql.ddl.DropTableClause;
import com.querydsl.sql.dml.SQLInsertClause;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.Test;

public class TypesBase
extends AbstractBaseTest {
    @Test
    public void create_tables() {
        LinkedHashMap<Class<String>, Object> instances = new LinkedHashMap<Class<String>, Object>();
        instances.put(BigInteger.class, BigInteger.valueOf(1L));
        instances.put(Long.class, 1L);
        instances.put(Integer.class, 1);
        instances.put(Short.class, (short)1);
        instances.put(Byte.class, (byte)1);
        instances.put(BigDecimal.class, BigDecimal.valueOf(1.0));
        instances.put(Double.class, 1.0);
        instances.put(Float.class, Float.valueOf(1.0f));
        instances.put(Boolean.class, Boolean.TRUE);
        instances.put(Character.class, Character.valueOf('a'));
        instances.put(String.class, "ABC");
        for (Map.Entry entry : instances.entrySet()) {
            String tableName = "test_" + ((Class)entry.getKey()).getSimpleName();
            new DropTableClause(this.connection, this.configuration, tableName).execute();
            CreateTableClause c = new CreateTableClause(this.connection, this.configuration, tableName).column("col", (Class)entry.getKey());
            if (((Class)entry.getKey()).equals(String.class)) {
                c.size(256);
            }
            c.execute();
            RelationalPathBase entityPath = new RelationalPathBase(Object.class, tableName, "PUBLIC", tableName);
            SimplePath columnPath = Expressions.path((Class)((Class)entry.getKey()), (Path)entityPath, (String)"col");
            ((SQLInsertClause)this.insert((RelationalPath<?>)entityPath).set((Path)columnPath, entry.getValue())).execute();
            new DropTableClause(this.connection, this.configuration, tableName).execute();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    @ExcludeIn(value={Target.CUBRID, Target.POSTGRESQL, Target.TERADATA})
    public void dump_types() throws SQLException {
        Connection conn = Connections.getConnection();
        DatabaseMetaData md = conn.getMetaData();
        try (ResultSet rs = md.getUDTs(null, null, null, null);){
            while (rs.next()) {
                String cat = rs.getString(1);
                String schema = rs.getString(2);
                String name = rs.getString(3);
                String classname = rs.getString(4);
                String datatype = rs.getString(5);
                String remarks = rs.getString(6);
                String baseType = rs.getString(7);
                System.out.println(name + " " + classname + " " + datatype + " " + remarks + " " + baseType);
                ResultSet rs2 = md.getAttributes(cat, schema, name, null);
                try {
                    while (rs2.next()) {
                        String cat2 = rs2.getString(1);
                        String schema2 = rs2.getString(2);
                        String name2 = rs2.getString(3);
                        String attrName2 = rs2.getString(4);
                        String dataType2 = rs2.getString(5);
                        String attrTypeName2 = rs2.getString(6);
                        String attrSize2 = rs2.getString(7);
                        System.out.println(" " + attrName2 + " " + dataType2 + " " + attrTypeName2 + " " + attrSize2);
                    }
                }
                finally {
                    if (rs2 == null) continue;
                    rs2.close();
                }
            }
            return;
        }
    }
}

