/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.sql.Connections;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Types;
import java.util.HashMap;

public final class TypesDump {
    private TypesDump() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        HashMap<Integer, String> typeConstants = new HashMap<Integer, String>();
        for (Field field : Types.class.getDeclaredFields()) {
            if (!field.getType().equals(Integer.TYPE)) continue;
            typeConstants.put(field.getInt(null), field.getName());
        }
        Connections.initOracle();
        try {
            Connection c = Connections.getConnection();
            DatabaseMetaData m = c.getMetaData();
            System.out.println(m.getDatabaseProductName());
            try (ResultSet rs = m.getTypeInfo();){
                while (rs.next()) {
                    String name = rs.getString("TYPE_NAME");
                    int jdbcType = rs.getInt("DATA_TYPE");
                    String jdbcTypeField = (String)typeConstants.get(jdbcType);
                    if (jdbcTypeField != null && jdbcTypeField.equalsIgnoreCase(name)) continue;
                    String prefix = rs.getString("LITERAL_PREFIX");
                    String suffix = rs.getString("LITERAL_SUFFIX");
                    Object jdbcTypeStr = jdbcTypeField != null ? "Types." + jdbcTypeField : String.valueOf(jdbcType);
                    System.out.println("addTypeNameToCode(\"" + name.toLowerCase() + "\", " + (String)jdbcTypeStr + ");");
                }
            }
        }
        finally {
            Connections.close();
        }
    }
}

