/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.Target;
import com.querydsl.core.Tuple;
import com.querydsl.core.testutil.ExcludeIn;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.sql.AbstractBaseTest;
import com.querydsl.sql.Constants;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.domain.Employee;
import com.querydsl.sql.domain.QEmployee;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class UnionBase
extends AbstractBaseTest {
    @Test
    @ExcludeIn(value={Target.MYSQL, Target.TERADATA})
    public void in_union() {
        Assert.assertNotNull((Object)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.id.in((SubQueryExpression)this.query().union(new SubQueryExpression[]{this.query().select((Expression)Expressions.ONE), this.query().select((Expression)Expressions.TWO)})))).select((Expression)Expressions.ONE).fetchFirst());
    }

    @Test
    @ExcludeIn(value={Target.FIREBIRD})
    public void union() throws SQLException {
        SQLQuery sq1 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.id.max().as("ID"));
        SQLQuery sq2 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.id.min().as("ID"));
        Assert.assertEquals(Arrays.asList((Integer)((SQLQuery)this.query().select((Expression)Constants.employee.id.min()).from((Expression)Constants.employee)).fetchFirst(), (Integer)((SQLQuery)this.query().select((Expression)Constants.employee.id.max()).from((Expression)Constants.employee)).fetchFirst()), (Object)this.query().union(new SubQueryExpression[]{sq1, sq2}).orderBy(new OrderSpecifier[]{Constants.employee.id.asc()}).fetch());
    }

    @Test
    public void union_list() throws SQLException {
        SQLQuery sq1 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.id.max());
        SQLQuery sq2 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.id.min());
        Assert.assertEquals((Object)this.query().union(new SubQueryExpression[]{sq1, sq2}).fetch(), (Object)this.query().union(new SubQueryExpression[]{sq1, sq2}).list());
    }

    @Test
    public void union_all() {
        SQLQuery sq1 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.id.max());
        SQLQuery sq2 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.id.min());
        List list = this.query().unionAll(new SubQueryExpression[]{sq1, sq2}).fetch();
        Assert.assertFalse((boolean)list.isEmpty());
    }

    @Test
    public void union_multiple_columns() throws SQLException {
        SQLQuery sq1 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select(new Expression[]{Constants.employee.firstname, Constants.employee.lastname});
        SQLQuery sq2 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select(new Expression[]{Constants.employee.lastname, Constants.employee.firstname});
        List list = this.query().union(new SubQueryExpression[]{sq1, sq2}).fetch();
        Assert.assertFalse((boolean)list.isEmpty());
        for (Tuple row : list) {
            Assert.assertNotNull((Object)row.get(0, Object.class));
            Assert.assertNotNull((Object)row.get(1, Object.class));
        }
    }

    @Test
    @ExcludeIn(value={Target.DERBY})
    public void union_multiple_columns2() throws SQLException {
        SQLQuery sq1 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select(new Expression[]{Constants.employee.firstname, Constants.employee.lastname});
        SQLQuery sq2 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select(new Expression[]{Constants.employee.firstname, Constants.employee.lastname});
        SQLQuery<?> query = this.query();
        query.union(new SubQueryExpression[]{sq1, sq2});
        List list = query.select((Expression)Constants.employee.firstname).fetch();
        Assert.assertFalse((boolean)list.isEmpty());
        for (String row : list) {
            Assert.assertNotNull((Object)row);
        }
    }

    @Test
    @ExcludeIn(value={Target.DERBY})
    public void union_multiple_columns3() throws SQLException {
        SQLQuery sq1 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select(new Expression[]{Constants.employee.firstname, Constants.employee.lastname});
        SQLQuery sq2 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select(new Expression[]{Constants.employee.firstname, Constants.employee.lastname});
        SQLQuery<?> query = this.query();
        query.union(new SubQueryExpression[]{sq1, sq2});
        List list = query.select(new Expression[]{Constants.employee.lastname, Constants.employee.firstname}).fetch();
        Assert.assertFalse((boolean)list.isEmpty());
        for (Tuple row : list) {
            System.out.println((String)row.get(0, String.class) + " " + (String)row.get(1, String.class));
        }
    }

    @Test
    public void union_empty_result() throws SQLException {
        SQLQuery sq1 = ((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.firstname.eq((Object)"XXX"))).select(Constants.employee.id);
        SQLQuery sq2 = ((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).where((Predicate)Constants.employee.firstname.eq((Object)"YYY"))).select(Constants.employee.id);
        List list = this.query().union(new SubQueryExpression[]{sq1, sq2}).fetch();
        Assert.assertTrue((boolean)list.isEmpty());
    }

    @Test
    public void union2() throws SQLException {
        List list = this.query().union(new SubQueryExpression[]{((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.id.max()), ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.id.min())}).fetch();
        Assert.assertFalse((boolean)list.isEmpty());
    }

    @Test
    public void union3() throws SQLException {
        SQLQuery sq3 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select(new Expression[]{Constants.employee.id.max()});
        SQLQuery sq4 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select(new Expression[]{Constants.employee.id.min()});
        List list2 = this.query().union(new SubQueryExpression[]{sq3, sq4}).fetch();
        Assert.assertFalse((boolean)list2.isEmpty());
    }

    @Test
    @ExcludeIn(value={Target.DERBY})
    public void union4() {
        SQLQuery sq1 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select(new Expression[]{Constants.employee.id, Constants.employee.firstname});
        SQLQuery sq2 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select(new Expression[]{Constants.employee.id, Constants.employee.firstname});
        Assert.assertEquals((long)1L, (long)((SQLQuery)this.query().union((Path)Constants.employee, new SubQueryExpression[]{sq1, sq2})).select((Expression)Constants.employee.id.count()).fetch().size());
    }

    @Test
    @ExcludeIn(value={Target.DERBY, Target.CUBRID, Target.FIREBIRD, Target.TERADATA})
    @Ignore
    public void union5() {
        QEmployee superior = new QEmployee("superior");
        SQLQuery sq1 = ((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.employee)).join(Constants.employee.superiorIdKey, (RelationalPath)superior)).select(new Expression[]{Constants.employee.id, Constants.employee.firstname, superior.id.as("sup_id"), superior.firstname.as("sup_name")});
        SQLQuery sq2 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select(new Expression[]{Constants.employee.id, Constants.employee.firstname, null, null});
        List results = this.query().union(new SubQueryExpression[]{sq1, sq2}).orderBy(new OrderSpecifier[]{Constants.employee.id.asc()}).fetch();
        for (Tuple result : results) {
            System.err.println(Collections.singletonList(result));
        }
    }

    @Test
    @ExcludeIn(value={Target.FIREBIRD, Target.TERADATA})
    public void union_with_order() throws SQLException {
        SQLQuery sq1 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select(Constants.employee.id);
        SQLQuery sq2 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select(Constants.employee.id);
        List list = this.query().union(new SubQueryExpression[]{sq1, sq2}).orderBy(new OrderSpecifier[]{Constants.employee.id.asc()}).fetch();
        Assert.assertFalse((boolean)list.isEmpty());
    }

    @Test
    @ExcludeIn(value={Target.FIREBIRD})
    public void union_multi_column_projection_list() throws IOException {
        SQLQuery sq1 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select(new Expression[]{Constants.employee.id.max(), Constants.employee.id.max().subtract((Number)1)});
        SQLQuery sq2 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select(new Expression[]{Constants.employee.id.min(), Constants.employee.id.min().subtract((Number)1)});
        List list = this.query().union(new SubQueryExpression[]{sq1, sq2}).list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((list.get(0) != null ? 1 : 0) != 0);
        Assert.assertTrue((list.get(1) != null ? 1 : 0) != 0);
    }

    @Test
    @ExcludeIn(value={Target.FIREBIRD})
    public void union_multi_column_projection_iterate() throws IOException {
        SQLQuery sq1 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select(new Expression[]{Constants.employee.id.max(), Constants.employee.id.max().subtract((Number)1)});
        SQLQuery sq2 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select(new Expression[]{Constants.employee.id.min(), Constants.employee.id.min().subtract((Number)1)});
        try (CloseableIterator iterator = this.query().union(new SubQueryExpression[]{sq1, sq2}).iterate();){
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertTrue((iterator.next() != null ? 1 : 0) != 0);
            Assert.assertTrue((iterator.next() != null ? 1 : 0) != 0);
            Assert.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void union_single_column_projections_list() throws IOException {
        SQLQuery sq1 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.id.max());
        SQLQuery sq2 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.id.min());
        List list = this.query().union(new SubQueryExpression[]{sq1, sq2}).list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((list.get(0) != null ? 1 : 0) != 0);
        Assert.assertTrue((list.get(1) != null ? 1 : 0) != 0);
    }

    @Test
    public void union_single_column_projections_iterate() throws IOException {
        SQLQuery sq1 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.id.max());
        SQLQuery sq2 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Constants.employee.id.min());
        try (CloseableIterator iterator = this.query().union(new SubQueryExpression[]{sq1, sq2}).iterate();){
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertTrue((iterator.next() != null ? 1 : 0) != 0);
            Assert.assertTrue((iterator.next() != null ? 1 : 0) != 0);
            Assert.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void union_factoryExpression() {
        SQLQuery sq1 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Projections.constructor(Employee.class, (Expression[])new Expression[]{Constants.employee.id}));
        SQLQuery sq2 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Projections.constructor(Employee.class, (Expression[])new Expression[]{Constants.employee.id}));
        List employees = this.query().union(new SubQueryExpression[]{sq1, sq2}).list();
        for (Employee employee : employees) {
            Assert.assertNotNull((Object)employee);
        }
    }

    @Test
    @ExcludeIn(value={Target.DERBY, Target.CUBRID})
    public void union_clone() {
        NumberPath idAlias = Expressions.numberPath(Integer.class, (String)"id");
        SQLQuery sq1 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Projections.constructor(Employee.class, (Expression[])new Expression[]{Constants.employee.id.as((Path)idAlias)}));
        SQLQuery sq2 = ((SQLQuery)this.query().from((Expression)Constants.employee)).select((Expression)Projections.constructor(Employee.class, (Expression[])new Expression[]{Constants.employee.id.as((Path)idAlias)}));
        SQLQuery<?> query = this.query();
        query.union(new SubQueryExpression[]{sq1, sq2});
        Assert.assertEquals((long)10L, (long)((SQLQuery)query.clone()).select((Expression)idAlias).fetch().size());
    }
}

