/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.H2Templates;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLSerializer;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.Union;
import org.junit.Assert;
import org.junit.Test;

public class UnionSubQueryTest {
    private static final SimpleExpression<Integer> one = Expressions.numberTemplate(Integer.class, (String)"1", (Object[])new Object[0]);
    private static final SimpleExpression<Integer> two = Expressions.numberTemplate(Integer.class, (String)"2", (Object[])new Object[0]);
    private static final SimpleExpression<Integer> three = Expressions.numberTemplate(Integer.class, (String)"3", (Object[])new Object[0]);
    private SQLTemplates templates = H2Templates.builder().newLineToSingleSpace().build();
    private SQLSerializer serializer = new SQLSerializer(new Configuration(this.templates));

    @Test
    public void in_union() {
        NumberPath intPath = Expressions.numberPath(Integer.class, (String)"intPath");
        BooleanExpression expr = intPath.in((SubQueryExpression)SQLExpressions.union((SubQueryExpression[])new SubQueryExpression[]{SQLExpressions.select(one), SQLExpressions.select(two)}));
        this.serializer.handle((Expression)expr);
        Assert.assertEquals((Object)"intPath in ((select 1 from dual)\nunion\n(select 2 from dual))", (Object)this.serializer.toString());
    }

    @Test
    public void union_subQuery() {
        SimplePath col1 = Expressions.path(Integer.class, (String)"col1");
        Union union = SQLExpressions.union((SubQueryExpression[])new SubQueryExpression[]{SQLExpressions.select((Expression)one.as((Path)col1)), SQLExpressions.select(two), SQLExpressions.select(three)});
        this.serializer.handle((Expression)union);
        Assert.assertEquals((Object)"(select 1 as col1 from dual)\nunion\n(select 2 from dual)\nunion\n(select 3 from dual)", (Object)this.serializer.toString());
    }

    @Test
    public void unionAll_subQuery() {
        SimplePath col1 = Expressions.path(Integer.class, (String)"col1");
        Union union = SQLExpressions.unionAll((SubQueryExpression[])new SubQueryExpression[]{SQLExpressions.select((Expression)one.as((Path)col1)), SQLExpressions.select(two), SQLExpressions.select(three)});
        this.serializer.handle((Expression)union);
        Assert.assertEquals((Object)"(select 1 as col1 from dual)\nunion all\n(select 2 from dual)\nunion all\n(select 3 from dual)", (Object)this.serializer.toString());
    }
}

