/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.Target;
import com.querydsl.core.dml.DMLClause;
import com.querydsl.core.testutil.ExcludeIn;
import com.querydsl.core.testutil.IncludeIn;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.Param;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.sql.AbstractBaseTest;
import com.querydsl.sql.Constants;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SkipForQuoted;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import com.querydsl.sql.domain.QEmployee;
import com.querydsl.sql.domain.QSurvey;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UpdateBase
extends AbstractBaseTest {
    protected void reset() throws SQLException {
        this.delete((RelationalPath<?>)Constants.survey).execute();
        ((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).values(new Object[]{1, "Hello World", "Hello"})).execute();
    }

    @Before
    public void setUp() throws SQLException {
        this.reset();
    }

    @After
    public void tearDown() throws SQLException {
        this.reset();
    }

    @Test
    public void update() throws SQLException {
        long count = ((SQLQuery)this.query().from((Expression)Constants.survey)).fetchCount();
        Assert.assertEquals((long)0L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.eq((Object)"S"))).fetchCount());
        Assert.assertEquals((long)0L, (long)((SQLUpdateClause)((SQLUpdateClause)this.update((RelationalPath<?>)Constants.survey).where((Predicate)Constants.survey.name.eq((Object)"XXX"))).set((Path)Constants.survey.name, (Object)"S")).execute());
        Assert.assertEquals((long)0L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.eq((Object)"S"))).fetchCount());
        Assert.assertEquals((long)count, (long)((SQLUpdateClause)this.update((RelationalPath<?>)Constants.survey).set((Path)Constants.survey.name, (Object)"S")).execute());
        Assert.assertEquals((long)count, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.eq((Object)"S"))).fetchCount());
    }

    @Test
    @IncludeIn(value={Target.CUBRID, Target.H2, Target.MYSQL, Target.ORACLE, Target.SQLSERVER})
    public void update_limit() {
        Assert.assertEquals((long)1L, (long)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).values(new Object[]{2, "A", "B"})).execute());
        Assert.assertEquals((long)1L, (long)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).values(new Object[]{3, "B", "C"})).execute());
        Assert.assertEquals((long)2L, (long)((SQLUpdateClause)((SQLUpdateClause)this.update((RelationalPath<?>)Constants.survey).set((Path)Constants.survey.name, (Object)"S")).limit(2L)).execute());
    }

    @Test
    public void update2() throws SQLException {
        List<StringPath> paths = Collections.singletonList(Constants.survey.name);
        List<String> values = Collections.singletonList("S");
        long count = ((SQLQuery)this.query().from((Expression)Constants.survey)).fetchCount();
        Assert.assertEquals((long)0L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.eq((Object)"S"))).fetchCount());
        Assert.assertEquals((long)0L, (long)((SQLUpdateClause)((SQLUpdateClause)this.update((RelationalPath<?>)Constants.survey).where((Predicate)Constants.survey.name.eq((Object)"XXX"))).set(paths, values)).execute());
        Assert.assertEquals((long)0L, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.eq((Object)"S"))).fetchCount());
        Assert.assertEquals((long)count, (long)((SQLUpdateClause)this.update((RelationalPath<?>)Constants.survey).set(paths, values)).execute());
        Assert.assertEquals((long)count, (long)((SQLQuery)((SQLQuery)this.query().from((Expression)Constants.survey)).where((Predicate)Constants.survey.name.eq((Object)"S"))).fetchCount());
    }

    @Test
    public void update3() {
        Assert.assertEquals((long)1L, (long)((SQLUpdateClause)this.update((RelationalPath<?>)Constants.survey).set((Path)Constants.survey.name, (Expression)Constants.survey.name.append("X"))).execute());
    }

    @Test
    public void update4() {
        Assert.assertEquals((long)1L, (long)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).values(new Object[]{2, "A", "B"})).execute());
        Assert.assertEquals((long)1L, (long)((SQLUpdateClause)((SQLUpdateClause)this.update((RelationalPath<?>)Constants.survey).set((Path)Constants.survey.name, (Object)"AA")).where((Predicate)Constants.survey.name.eq((Object)"A"))).execute());
    }

    @Test
    public void update5() {
        Assert.assertEquals((long)1L, (long)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).values(new Object[]{3, "B", "C"})).execute());
        Assert.assertEquals((long)1L, (long)((SQLUpdateClause)((SQLUpdateClause)this.update((RelationalPath<?>)Constants.survey).set((Path)Constants.survey.name, (Object)"BB")).where((Predicate)Constants.survey.name.eq((Object)"B"))).execute());
    }

    @Test
    public void setNull() {
        List<StringPath> paths = Collections.singletonList(Constants.survey.name);
        List<Object> values = Collections.singletonList(null);
        long count = ((SQLQuery)this.query().from((Expression)Constants.survey)).fetchCount();
        Assert.assertEquals((long)count, (long)((SQLUpdateClause)this.update((RelationalPath<?>)Constants.survey).set(paths, values)).execute());
    }

    @Test
    public void setNull2() {
        long count = ((SQLQuery)this.query().from((Expression)Constants.survey)).fetchCount();
        Assert.assertEquals((long)count, (long)((SQLUpdateClause)this.update((RelationalPath<?>)Constants.survey).set((Path)Constants.survey.name, (Object)null)).execute());
    }

    @Test
    @SkipForQuoted
    @ExcludeIn(value={Target.DB2, Target.DERBY})
    public void setNullEmptyRootPath() {
        StringPath name = Expressions.stringPath((String)"name");
        long count = ((SQLQuery)this.query().from((Expression)Constants.survey)).fetchCount();
        Assert.assertEquals((long)count, (long)this.execute(new DMLClause[]{this.update((RelationalPath<?>)Constants.survey).setNull((Path)name)}));
    }

    @Test
    public void batch() throws SQLException {
        Assert.assertEquals((long)1L, (long)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).values(new Object[]{2, "A", "B"})).execute());
        Assert.assertEquals((long)1L, (long)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).values(new Object[]{3, "B", "C"})).execute());
        SQLUpdateClause update = this.update((RelationalPath<?>)Constants.survey);
        ((SQLUpdateClause)((SQLUpdateClause)update.set((Path)Constants.survey.name, (Object)"AA")).where((Predicate)Constants.survey.name.eq((Object)"A"))).addBatch();
        Assert.assertEquals((long)1L, (long)update.getBatchCount());
        ((SQLUpdateClause)((SQLUpdateClause)update.set((Path)Constants.survey.name, (Object)"BB")).where((Predicate)Constants.survey.name.eq((Object)"B"))).addBatch();
        Assert.assertEquals((long)2L, (long)update.getBatchCount());
        Assert.assertEquals((long)2L, (long)update.execute());
    }

    @Test
    public void batch_templates() throws SQLException {
        Assert.assertEquals((long)1L, (long)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).values(new Object[]{2, "A", "B"})).execute());
        Assert.assertEquals((long)1L, (long)((SQLInsertClause)this.insert((RelationalPath<?>)Constants.survey).values(new Object[]{3, "B", "C"})).execute());
        SQLUpdateClause update = this.update((RelationalPath<?>)Constants.survey);
        ((SQLUpdateClause)((SQLUpdateClause)update.set((Path)Constants.survey.name, (Object)"AA")).where((Predicate)Constants.survey.name.eq((Expression)Expressions.stringTemplate((String)"'A'", (Object[])new Object[0])))).addBatch();
        ((SQLUpdateClause)((SQLUpdateClause)update.set((Path)Constants.survey.name, (Object)"BB")).where((Predicate)Constants.survey.name.eq((Expression)Expressions.stringTemplate((String)"'B'", (Object[])new Object[0])))).addBatch();
        Assert.assertEquals((long)2L, (long)update.execute());
    }

    @Test
    public void update_with_subQuery_exists() {
        QSurvey survey1 = new QSurvey("s1");
        QEmployee employee = new QEmployee("e");
        SQLUpdateClause update = this.update((RelationalPath<?>)survey1);
        update.set((Path)survey1.name, (Object)"AA");
        update.where((Predicate)((SQLQuery)((SQLQuery)SQLExpressions.selectOne().from((Expression)employee)).where((Predicate)survey1.id.eq(employee.id))).exists());
        Assert.assertEquals((long)1L, (long)update.execute());
    }

    @Test
    public void update_with_subQuery_exists_Params() {
        QSurvey survey1 = new QSurvey("s1");
        QEmployee employee = new QEmployee("e");
        Param param = new Param(Integer.class, "param");
        SQLQuery sq = (SQLQuery)((SQLQuery)this.query().from((Expression)employee)).where((Predicate)employee.id.eq((Expression)param));
        sq.set((ParamExpression)param, (Object)-12478923);
        SQLUpdateClause update = this.update((RelationalPath<?>)survey1);
        update.set((Path)survey1.name, (Object)"AA");
        update.where((Predicate)sq.exists());
        Assert.assertEquals((long)0L, (long)update.execute());
    }

    @Test
    public void update_with_subQuery_exists2() {
        QSurvey survey1 = new QSurvey("s1");
        QEmployee employee = new QEmployee("e");
        SQLUpdateClause update = this.update((RelationalPath<?>)survey1);
        update.set((Path)survey1.name, (Object)"AA");
        update.where((Predicate)((SQLQuery)((SQLQuery)SQLExpressions.selectOne().from((Expression)employee)).where((Predicate)survey1.name.eq((Expression)employee.lastname))).exists());
        Assert.assertEquals((long)0L, (long)update.execute());
    }

    @Test
    public void update_with_subQuery_notExists() {
        QSurvey survey1 = new QSurvey("s1");
        QEmployee employee = new QEmployee("e");
        SQLUpdateClause update = this.update((RelationalPath<?>)survey1);
        update.set((Path)survey1.name, (Object)"AA");
        update.where((Predicate)((SQLQuery)((SQLQuery)this.query().from((Expression)employee)).where((Predicate)survey1.id.eq(employee.id))).notExists());
        Assert.assertEquals((long)0L, (long)update.execute());
    }

    @Test
    @ExcludeIn(value={Target.TERADATA})
    public void update_with_templateExpression_in_batch() {
        Assert.assertEquals((long)1L, (long)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.update((RelationalPath<?>)Constants.survey).set(Constants.survey.id, (Object)3)).set((Path)Constants.survey.name, (Expression)Expressions.stringTemplate((String)"'Hello'", (Object[])new Object[0]))).addBatch()).execute());
    }
}

