/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.dsl.ComparableExpressionBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLSerializer;
import com.querydsl.sql.WindowFunction;
import org.junit.Assert;
import org.junit.Test;

public class WindowFunctionTest {
    private static String toString(Expression<?> e) {
        return ((SQLSerializer)new SQLSerializer(Configuration.DEFAULT).handle(e)).toString();
    }

    @Test
    public void complex() {
        NumberPath path = Expressions.numberPath(Long.class, (String)"path");
        NumberPath path2 = Expressions.numberPath(Long.class, (String)"path2");
        WindowFunction wf = SQLExpressions.sum((Expression)path).over().partitionBy((Expression)path2).orderBy((ComparableExpressionBase)path);
        Assert.assertEquals((Object)"sum(path) over (partition by path2 order by path asc)", (Object)WindowFunctionTest.toString(wf));
    }

    @Test
    public void complex_nullsFirst() {
        NumberPath path = Expressions.numberPath(Long.class, (String)"path");
        NumberPath path2 = Expressions.numberPath(Long.class, (String)"path2");
        WindowFunction wf = SQLExpressions.sum((Expression)path).over().partitionBy((Expression)path2).orderBy(path.desc().nullsFirst());
        Assert.assertEquals((Object)"sum(path) over (partition by path2 order by path desc nulls first)", (Object)WindowFunctionTest.toString(wf));
    }

    @Test
    public void all() {
        NumberPath path = Expressions.numberPath(Long.class, (String)"path");
        NumberPath path2 = Expressions.numberPath(Long.class, (String)"path2");
        Assert.assertEquals((Object)"avg(path)", (Object)WindowFunctionTest.toString(SQLExpressions.avg((Expression)path)));
        Assert.assertEquals((Object)"count(path)", (Object)WindowFunctionTest.toString(SQLExpressions.count((Expression)path)));
        Assert.assertEquals((Object)"corr(path,path2)", (Object)WindowFunctionTest.toString(SQLExpressions.corr((Expression)path, (Expression)path2)));
        Assert.assertEquals((Object)"covar_pop(path,path2)", (Object)WindowFunctionTest.toString(SQLExpressions.covarPop((Expression)path, (Expression)path2)));
        Assert.assertEquals((Object)"covar_samp(path,path2)", (Object)WindowFunctionTest.toString(SQLExpressions.covarSamp((Expression)path, (Expression)path2)));
        Assert.assertEquals((Object)"cume_dist()", (Object)WindowFunctionTest.toString(SQLExpressions.cumeDist()));
        Assert.assertEquals((Object)"dense_rank()", (Object)WindowFunctionTest.toString(SQLExpressions.denseRank()));
        Assert.assertEquals((Object)"first_value(path)", (Object)WindowFunctionTest.toString(SQLExpressions.firstValue((Expression)path)));
        Assert.assertEquals((Object)"lag(path)", (Object)WindowFunctionTest.toString(SQLExpressions.lag((Expression)path)));
        Assert.assertEquals((Object)"last_value(path)", (Object)WindowFunctionTest.toString(SQLExpressions.lastValue((Expression)path)));
        Assert.assertEquals((Object)"lead(path)", (Object)WindowFunctionTest.toString(SQLExpressions.lead((Expression)path)));
        Assert.assertEquals((Object)"max(path)", (Object)WindowFunctionTest.toString(SQLExpressions.max((Expression)path)));
        Assert.assertEquals((Object)"min(path)", (Object)WindowFunctionTest.toString(SQLExpressions.min((Expression)path)));
        Assert.assertEquals((Object)"nth_value(path, ?)", (Object)WindowFunctionTest.toString(SQLExpressions.nthValue((Expression)path, (Number)3)));
        Assert.assertEquals((Object)"ntile(?)", (Object)WindowFunctionTest.toString(SQLExpressions.ntile((Number)4)));
        Assert.assertEquals((Object)"percent_rank()", (Object)WindowFunctionTest.toString(SQLExpressions.percentRank()));
        Assert.assertEquals((Object)"rank()", (Object)WindowFunctionTest.toString(SQLExpressions.rank()));
        Assert.assertEquals((Object)"ratio_to_report(path)", (Object)WindowFunctionTest.toString(SQLExpressions.ratioToReport((Expression)path)));
        Assert.assertEquals((Object)"row_number()", (Object)WindowFunctionTest.toString(SQLExpressions.rowNumber()));
        Assert.assertEquals((Object)"stddev(path)", (Object)WindowFunctionTest.toString(SQLExpressions.stddev((Expression)path)));
        Assert.assertEquals((Object)"stddev(distinct path)", (Object)WindowFunctionTest.toString(SQLExpressions.stddevDistinct((Expression)path)));
        Assert.assertEquals((Object)"stddev_pop(path)", (Object)WindowFunctionTest.toString(SQLExpressions.stddevPop((Expression)path)));
        Assert.assertEquals((Object)"stddev_samp(path)", (Object)WindowFunctionTest.toString(SQLExpressions.stddevSamp((Expression)path)));
        Assert.assertEquals((Object)"sum(path)", (Object)WindowFunctionTest.toString(SQLExpressions.sum((Expression)path)));
        Assert.assertEquals((Object)"variance(path)", (Object)WindowFunctionTest.toString(SQLExpressions.variance((Expression)path)));
        Assert.assertEquals((Object)"var_pop(path)", (Object)WindowFunctionTest.toString(SQLExpressions.varPop((Expression)path)));
        Assert.assertEquals((Object)"var_samp(path)", (Object)WindowFunctionTest.toString(SQLExpressions.varSamp((Expression)path)));
    }

    @Test
    public void regr() {
        NumberPath path = Expressions.numberPath(Long.class, (String)"path");
        NumberPath path2 = Expressions.numberPath(Long.class, (String)"path2");
        Assert.assertEquals((Object)"regr_slope(path, path2)", (Object)WindowFunctionTest.toString(SQLExpressions.regrSlope((Expression)path, (Expression)path2)));
        Assert.assertEquals((Object)"regr_intercept(path, path2)", (Object)WindowFunctionTest.toString(SQLExpressions.regrIntercept((Expression)path, (Expression)path2)));
        Assert.assertEquals((Object)"regr_count(path, path2)", (Object)WindowFunctionTest.toString(SQLExpressions.regrCount((Expression)path, (Expression)path2)));
        Assert.assertEquals((Object)"regr_r2(path, path2)", (Object)WindowFunctionTest.toString(SQLExpressions.regrR2((Expression)path, (Expression)path2)));
        Assert.assertEquals((Object)"regr_avgx(path, path2)", (Object)WindowFunctionTest.toString(SQLExpressions.regrAvgx((Expression)path, (Expression)path2)));
        Assert.assertEquals((Object)"regr_avgy(path, path2)", (Object)WindowFunctionTest.toString(SQLExpressions.regrAvgy((Expression)path, (Expression)path2)));
        Assert.assertEquals((Object)"regr_sxx(path, path2)", (Object)WindowFunctionTest.toString(SQLExpressions.regrSxx((Expression)path, (Expression)path2)));
        Assert.assertEquals((Object)"regr_syy(path, path2)", (Object)WindowFunctionTest.toString(SQLExpressions.regrSyy((Expression)path, (Expression)path2)));
        Assert.assertEquals((Object)"regr_sxy(path, path2)", (Object)WindowFunctionTest.toString(SQLExpressions.regrSxy((Expression)path, (Expression)path2)));
    }

    @Test
    public void rows_between() {
        NumberPath path = Expressions.numberPath(Long.class, (String)"path");
        NumberPath intPath = Expressions.numberPath(Integer.class, (String)"intPath");
        WindowFunction wf = SQLExpressions.sum((Expression)path).over().orderBy((ComparableExpressionBase)path);
        Assert.assertEquals((Object)"sum(path) over (order by path asc rows between current row and unbounded following)", (Object)WindowFunctionTest.toString(wf.rows().between().currentRow().unboundedFollowing()));
        Assert.assertEquals((Object)"sum(path) over (order by path asc rows between preceding intPath and following intPath)", (Object)WindowFunctionTest.toString(wf.rows().between().preceding((Expression)intPath).following((Expression)intPath)));
        Assert.assertEquals((Object)"sum(path) over (order by path asc rows between preceding ? and following ?)", (Object)WindowFunctionTest.toString(wf.rows().between().preceding(1).following(3)));
    }

    @Test
    public void rows_unboundedPreceding() {
        NumberPath path = Expressions.numberPath(Long.class, (String)"path");
        WindowFunction wf = SQLExpressions.sum((Expression)path).over().orderBy((ComparableExpressionBase)path);
        Assert.assertEquals((Object)"sum(path) over (order by path asc rows unbounded preceding)", (Object)WindowFunctionTest.toString(wf.rows().unboundedPreceding()));
    }

    @Test
    public void rows_currentRow() {
        NumberPath path = Expressions.numberPath(Long.class, (String)"path");
        WindowFunction wf = SQLExpressions.sum((Expression)path).over().orderBy((ComparableExpressionBase)path);
        Assert.assertEquals((Object)"sum(path) over (order by path asc rows current row)", (Object)WindowFunctionTest.toString(wf.rows().currentRow()));
    }

    @Test
    public void rows_precedingRow() {
        NumberPath path = Expressions.numberPath(Long.class, (String)"path");
        NumberPath intPath = Expressions.numberPath(Integer.class, (String)"intPath");
        WindowFunction wf = SQLExpressions.sum((Expression)path).over().orderBy((ComparableExpressionBase)path);
        Assert.assertEquals((Object)"sum(path) over (order by path asc rows preceding intPath)", (Object)WindowFunctionTest.toString(wf.rows().preceding((Expression)intPath)));
        Assert.assertEquals((Object)"sum(path) over (order by path asc rows preceding ?)", (Object)WindowFunctionTest.toString(wf.rows().preceding(3)));
    }

    @Test
    public void keep_first() {
        NumberPath path = Expressions.numberPath(Long.class, (String)"path");
        NumberPath path2 = Expressions.numberPath(Long.class, (String)"path2");
        NumberPath path3 = Expressions.numberPath(Long.class, (String)"path3");
        Assert.assertEquals((Object)"min(path) keep (dense_rank first order by path2 asc)", (Object)WindowFunctionTest.toString(SQLExpressions.min((Expression)path).keepFirst().orderBy((ComparableExpressionBase)path2)));
        Assert.assertEquals((Object)"min(path) keep (dense_rank first order by path2 asc) over (partition by path3)", (Object)WindowFunctionTest.toString(SQLExpressions.min((Expression)path).keepFirst().orderBy((ComparableExpressionBase)path2).over().partitionBy((Expression)path3)));
    }

    @Test
    public void keep_last() {
        NumberPath path = Expressions.numberPath(Long.class, (String)"path");
        NumberPath path2 = Expressions.numberPath(Long.class, (String)"path2");
        NumberPath path3 = Expressions.numberPath(Long.class, (String)"path3");
        Assert.assertEquals((Object)"min(path) keep (dense_rank last order by path2 asc) over (partition by path3)", (Object)WindowFunctionTest.toString(SQLExpressions.min((Expression)path).keepLast().orderBy((ComparableExpressionBase)path2).over().partitionBy((Expression)path3)));
    }
}

