/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLSerializer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WithinGroupTest {
    NumberPath<Long> path = null;
    NumberPath<Long> path2 = null;

    private static String toString(Expression<?> e) {
        return ((SQLSerializer)new SQLSerializer(Configuration.DEFAULT).handle(e)).toString();
    }

    @Before
    public void setPaths() {
        this.path = Expressions.numberPath(Long.class, (String)"path");
        this.path2 = Expressions.numberPath(Long.class, (String)"path2");
    }

    @Test
    public void cume_Dist() {
        Assert.assertEquals((Object)"cume_dist(path)", (Object)WithinGroupTest.toString(SQLExpressions.cumeDist((Expression[])new Expression[]{this.path})));
        Assert.assertEquals((Object)"cume_dist(path, path2)", (Object)WithinGroupTest.toString(SQLExpressions.cumeDist((Expression[])new Expression[]{this.path, this.path2})));
    }

    @Test
    public void dense_Rank() {
        Assert.assertEquals((Object)"dense_rank(path, path2)", (Object)WithinGroupTest.toString(SQLExpressions.denseRank((Expression[])new Expression[]{this.path, this.path2})));
    }

    @Test
    public void perfect_Rank() {
        Assert.assertEquals((Object)"percent_rank(path, path2)", (Object)WithinGroupTest.toString(SQLExpressions.percentRank((Expression[])new Expression[]{this.path, this.path2})));
    }

    @Test
    public void percentile() {
        Assert.assertEquals((Object)"percentile_cont(path)", (Object)WithinGroupTest.toString(SQLExpressions.percentileCont(this.path)));
        Assert.assertEquals((Object)"percentile_disc(path)", (Object)WithinGroupTest.toString(SQLExpressions.percentileDisc(this.path)));
    }

    @Test
    public void rank() {
        Assert.assertEquals((Object)"rank(path, path2)", (Object)WithinGroupTest.toString(SQLExpressions.rank((Expression[])new Expression[]{this.path, this.path2})));
    }

    @Test
    public void listaggComma() {
        Assert.assertEquals((Object)"listagg(path,',')", (Object)WithinGroupTest.toString(SQLExpressions.listagg(this.path, (String)",")));
    }

    @Test
    public void listaggEmpty() {
        Assert.assertEquals((Object)"listagg(path,'')", (Object)WithinGroupTest.toString(SQLExpressions.listagg(this.path, (String)"")));
    }

    @Test
    public void listaggSpace() {
        Assert.assertEquals((Object)"listagg(path,' ')", (Object)WithinGroupTest.toString(SQLExpressions.listagg(this.path, (String)" ")));
    }

    @Test
    public void listaggDelimiter() {
        Assert.assertEquals((Object)"listagg(path,'|')", (Object)WithinGroupTest.toString(SQLExpressions.listagg(this.path, (String)"|")));
    }

    @Test
    public void listaggCommaWithSpace() {
        Assert.assertEquals((Object)"listagg(path,', ')", (Object)WithinGroupTest.toString(SQLExpressions.listagg(this.path, (String)", ")));
    }

    @Test
    public void listaggIntString() {
        Assert.assertEquals((Object)"listagg(path,'1')", (Object)WithinGroupTest.toString(SQLExpressions.listagg(this.path, (String)"1")));
    }
}

