/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.ddl;

import com.querydsl.core.QueryException;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.ddl.ColumnData;
import com.querydsl.sql.ddl.ForeignKeyBuilder;
import com.querydsl.sql.ddl.ForeignKeyData;
import com.querydsl.sql.ddl.IndexData;
import com.querydsl.sql.ddl.PrimaryKeyData;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class CreateTableClause {
    private static final Logger logger = Logger.getLogger(CreateTableClause.class.getName());
    private final Connection connection;
    private final Configuration configuration;
    private final SQLTemplates templates;
    private final String table;
    private final List<ColumnData> columns = new ArrayList<ColumnData>();
    private final List<IndexData> indexes = new ArrayList<IndexData>();
    private PrimaryKeyData primaryKey;
    private final List<ForeignKeyData> foreignKeys = new ArrayList<ForeignKeyData>();

    public CreateTableClause(Connection conn, Configuration c, String table) {
        this.connection = conn;
        this.configuration = c;
        this.templates = c.getTemplates();
        this.table = this.templates.quoteIdentifier(table);
    }

    public CreateTableClause column(String name, Class<?> type) {
        String typeName = this.configuration.getTypeName(type);
        this.columns.add(new ColumnData(this.templates.quoteIdentifier(name), typeName));
        return this;
    }

    private ColumnData lastColumn() {
        return this.columns.get(this.columns.size() - 1);
    }

    public CreateTableClause notNull() {
        this.lastColumn().setNullAllowed(false);
        return this;
    }

    public CreateTableClause size(int size) {
        this.lastColumn().setSize(size);
        return this;
    }

    public CreateTableClause autoIncrement() {
        this.lastColumn().setAutoIncrement(true);
        return this;
    }

    public CreateTableClause primaryKey(String name, String ... columns) {
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = this.templates.quoteIdentifier(columns[i]);
        }
        this.primaryKey = new PrimaryKeyData(this.templates.quoteIdentifier(name), columns);
        return this;
    }

    public CreateTableClause index(String name, String ... columns) {
        this.indexes.add(new IndexData(name, columns));
        return this;
    }

    public CreateTableClause unique() {
        this.indexes.get(this.indexes.size() - 1).setUnique(true);
        return this;
    }

    public ForeignKeyBuilder foreignKey(String name, String ... columns) {
        return new ForeignKeyBuilder(this, this.templates, this.foreignKeys, this.templates.quoteIdentifier(name), columns);
    }

    public void execute() {
        StringBuilder line;
        StringBuilder builder = new StringBuilder();
        builder.append(this.templates.getCreateTable()).append(this.table).append(" (\n");
        ArrayList<String> lines = new ArrayList<String>(this.columns.size() + this.foreignKeys.size() + 1);
        for (ColumnData column : this.columns) {
            line = new StringBuilder();
            line.append(column.getName()).append(" ").append(column.getType().toUpperCase());
            if (column.getSize() != null) {
                line.append("(").append(column.getSize()).append(")");
            }
            if (!column.isNullAllowed()) {
                line.append(this.templates.getNotNull().toUpperCase());
            }
            if (column.isAutoIncrement()) {
                line.append(this.templates.getAutoIncrement().toUpperCase());
            }
            lines.add(line.toString());
        }
        if (this.primaryKey != null) {
            StringBuilder line2 = new StringBuilder();
            line2.append("CONSTRAINT ").append(this.primaryKey.getName()).append(" ");
            line2.append("PRIMARY KEY(").append(String.join((CharSequence)", ", this.primaryKey.getColumns())).append(")");
            lines.add(line2.toString());
        }
        for (ForeignKeyData foreignKey : this.foreignKeys) {
            line = new StringBuilder();
            line.append("CONSTRAINT ").append(foreignKey.getName()).append(" ");
            line.append("FOREIGN KEY(").append(String.join((CharSequence)", ", foreignKey.getForeignColumns())).append(") ");
            line.append("REFERENCES ").append(foreignKey.getTable()).append("(").append(String.join((CharSequence)", ", foreignKey.getParentColumns())).append(")");
            lines.add(line.toString());
        }
        builder.append("  ").append(String.join((CharSequence)",\n  ", lines));
        builder.append("\n)\n");
        logger.info(builder.toString());
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(builder.toString());
            for (IndexData index : this.indexes) {
                String indexColumns = String.join((CharSequence)", ", index.getColumns());
                String prefix = this.templates.getCreateIndex();
                if (index.isUnique()) {
                    prefix = this.templates.getCreateUniqueIndex();
                }
                String sql = prefix + index.getName() + this.templates.getOn() + this.table + "(" + indexColumns + ")";
                logger.info(sql);
                stmt.execute(sql);
            }
        }
        catch (SQLException e) {
            System.err.println(builder.toString());
            throw new QueryException(e.getMessage(), (Throwable)e);
        }
    }
}

