/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.dml;

import com.querydsl.core.types.Predicate;
import com.querydsl.sql.KeyAccessorsTest;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLBindings;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.dml.SQLDeleteClause;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class SQLDeleteClauseTest {
    @Test(expected=IllegalStateException.class)
    public void noConnection() {
        KeyAccessorsTest.QEmployee emp1 = new KeyAccessorsTest.QEmployee("emp1");
        SQLDeleteClause delete = new SQLDeleteClause(null, SQLTemplates.DEFAULT, (RelationalPath)emp1);
        delete.where((Predicate)emp1.id.eq((Object)1));
        delete.execute();
    }

    @Test(expected=IllegalArgumentException.class)
    @Ignore
    public void error() {
        KeyAccessorsTest.QEmployee emp1 = new KeyAccessorsTest.QEmployee("emp1");
        KeyAccessorsTest.QEmployee emp2 = new KeyAccessorsTest.QEmployee("emp2");
        SQLDeleteClause delete = new SQLDeleteClause(null, SQLTemplates.DEFAULT, (RelationalPath)emp1);
        delete.where((Predicate)emp2.id.eq((Object)1));
    }

    @Test
    public void getSQL() {
        KeyAccessorsTest.QEmployee emp1 = new KeyAccessorsTest.QEmployee("emp1");
        SQLDeleteClause delete = new SQLDeleteClause(null, SQLTemplates.DEFAULT, (RelationalPath)emp1);
        delete.where((Predicate)emp1.id.eq((Object)1));
        SQLBindings sql = (SQLBindings)delete.getSQL().get(0);
        Assert.assertEquals((Object)"delete from EMPLOYEE\nwhere EMPLOYEE.ID = ?", (Object)sql.getSQL());
        Assert.assertEquals(Collections.singletonList(1), (Object)sql.getNullFriendlyBindings());
    }

    @Test
    public void clear() {
        KeyAccessorsTest.QEmployee emp1 = new KeyAccessorsTest.QEmployee("emp1");
        SQLDeleteClause delete = new SQLDeleteClause(null, SQLTemplates.DEFAULT, (RelationalPath)emp1);
        delete.where((Predicate)emp1.id.eq((Object)1));
        delete.addBatch();
        Assert.assertEquals((long)1L, (long)delete.getBatchCount());
        delete.clear();
        Assert.assertEquals((long)0L, (long)delete.getBatchCount());
    }
}

