/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.dml;

import com.querydsl.core.QueryFlag;
import com.querydsl.sql.KeyAccessorsTest;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLBindings;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.domain.QEmployee;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class SQLInsertClauseTest {
    @Test(expected=IllegalStateException.class)
    public void noConnection() {
        KeyAccessorsTest.QEmployee emp1 = new KeyAccessorsTest.QEmployee("emp1");
        SQLInsertClause insert = new SQLInsertClause(null, SQLTemplates.DEFAULT, (RelationalPath)emp1);
        insert.set(emp1.id, (Object)1);
        insert.execute();
    }

    @Test
    public void getSQL() {
        KeyAccessorsTest.QEmployee emp1 = new KeyAccessorsTest.QEmployee("emp1");
        SQLInsertClause insert = new SQLInsertClause(null, SQLTemplates.DEFAULT, (RelationalPath)emp1);
        insert.set(emp1.id, (Object)1);
        SQLBindings sql = (SQLBindings)insert.getSQL().get(0);
        Assert.assertEquals((Object)"insert into EMPLOYEE (ID)\nvalues (?)", (Object)sql.getSQL());
        Assert.assertEquals(Collections.singletonList(1), (Object)sql.getNullFriendlyBindings());
    }

    @Test
    public void bulk() {
        KeyAccessorsTest.QEmployee emp1 = new KeyAccessorsTest.QEmployee("emp1");
        SQLInsertClause insert = new SQLInsertClause(null, SQLTemplates.DEFAULT, (RelationalPath)emp1);
        insert.set(emp1.id, (Object)1);
        insert.addBatch();
        insert.set(emp1.id, (Object)2);
        insert.addBatch();
        insert.addFlag(QueryFlag.Position.END, " on duplicate key ignore");
        insert.setBatchToBulk(true);
        Assert.assertEquals((Object)"insert into EMPLOYEE (ID)\nvalues (?), (?) on duplicate key ignore", (Object)((SQLBindings)insert.getSQL().get(0)).getSQL());
    }

    @Test
    public void getSQLWithPreservedColumnOrder() {
        QEmployee emp1 = new QEmployee("emp1");
        SQLInsertClause insert = new SQLInsertClause(null, SQLTemplates.DEFAULT, (RelationalPath)emp1);
        insert.populate((Object)emp1);
        SQLBindings sql = (SQLBindings)insert.getSQL().get(0);
        Assert.assertEquals((String)"The order of columns in generated sql should be predictable", (Object)"insert into EMPLOYEE (ID, FIRSTNAME, LASTNAME, SALARY, DATEFIELD, TIMEFIELD, SUPERIOR_ID)\nvalues (EMPLOYEE.ID, EMPLOYEE.FIRSTNAME, EMPLOYEE.LASTNAME, EMPLOYEE.SALARY, EMPLOYEE.DATEFIELD, EMPLOYEE.TIMEFIELD, EMPLOYEE.SUPERIOR_ID)", (Object)sql.getSQL());
    }

    @Test
    public void clear() {
        KeyAccessorsTest.QEmployee emp1 = new KeyAccessorsTest.QEmployee("emp1");
        SQLInsertClause insert = new SQLInsertClause(null, SQLTemplates.DEFAULT, (RelationalPath)emp1);
        insert.set(emp1.id, (Object)1);
        insert.addBatch();
        Assert.assertEquals((long)1L, (long)insert.getBatchCount());
        insert.clear();
        Assert.assertEquals((long)0L, (long)insert.getBatchCount());
    }
}

