/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.dml;

import com.querydsl.core.QueryFlag;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.KeyAccessorsTest;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLBindings;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class SQLUpdateClauseTest {
    @Test(expected=IllegalStateException.class)
    public void noConnection() {
        KeyAccessorsTest.QEmployee emp1 = new KeyAccessorsTest.QEmployee("emp1");
        SQLUpdateClause update = new SQLUpdateClause(null, SQLTemplates.DEFAULT, (RelationalPath)emp1);
        update.set(emp1.id, (Object)1);
        update.execute();
    }

    @Test
    public void getSQL() {
        KeyAccessorsTest.QEmployee emp1 = new KeyAccessorsTest.QEmployee("emp1");
        SQLUpdateClause update = new SQLUpdateClause(null, SQLTemplates.DEFAULT, (RelationalPath)emp1);
        update.set(emp1.id, (Object)1);
        SQLBindings sql = (SQLBindings)update.getSQL().get(0);
        Assert.assertEquals((Object)"update EMPLOYEE\nset ID = ?", (Object)sql.getSQL());
        Assert.assertEquals(Collections.singletonList(1), (Object)sql.getNullFriendlyBindings());
    }

    @Test
    public void intertable() {
        KeyAccessorsTest.QEmployee emp1 = new KeyAccessorsTest.QEmployee("emp1");
        KeyAccessorsTest.QEmployee emp2 = new KeyAccessorsTest.QEmployee("emp2");
        SQLUpdateClause update = new SQLUpdateClause(null, SQLTemplates.DEFAULT, (RelationalPath)emp1);
        ((SQLUpdateClause)update.set(emp1.id, (Object)1)).where((Predicate)emp1.id.eq((Expression)((SQLQuery)SQLExpressions.select(emp2.id).from((Expression)emp2)).where((Predicate)emp2.superiorId.isNotNull())));
        SQLBindings sql = (SQLBindings)update.getSQL().get(0);
        Assert.assertEquals((Object)"update EMPLOYEE\nset ID = ?\nwhere EMPLOYEE.ID = (select emp2.ID\nfrom EMPLOYEE emp2\nwhere emp2.SUPERIOR_ID is not null)", (Object)sql.getSQL());
    }

    @Test
    public void intertable2() {
        KeyAccessorsTest.QEmployee emp1 = new KeyAccessorsTest.QEmployee("emp1");
        KeyAccessorsTest.QEmployee emp2 = new KeyAccessorsTest.QEmployee("emp2");
        SQLUpdateClause update = new SQLUpdateClause(null, SQLTemplates.DEFAULT, (RelationalPath)emp1);
        update.set(emp1.id, (Expression)((SQLQuery)SQLExpressions.select(emp2.id).from((Expression)emp2)).where((Predicate)emp2.superiorId.isNotNull()));
        SQLBindings sql = (SQLBindings)update.getSQL().get(0);
        Assert.assertEquals((Object)"update EMPLOYEE\nset ID = (select emp2.ID\nfrom EMPLOYEE emp2\nwhere emp2.SUPERIOR_ID is not null)", (Object)sql.getSQL());
    }

    @Test
    public void intertable3() {
        KeyAccessorsTest.QEmployee emp1 = new KeyAccessorsTest.QEmployee("emp1");
        KeyAccessorsTest.QEmployee emp2 = new KeyAccessorsTest.QEmployee("emp2");
        SQLUpdateClause update = new SQLUpdateClause(null, SQLTemplates.DEFAULT, (RelationalPath)emp1);
        update.set(emp1.superiorId, (Expression)((SQLQuery)SQLExpressions.select(emp2.id).from((Expression)emp2)).where((Predicate)emp2.id.eq(emp1.id)));
        SQLBindings sql = (SQLBindings)update.getSQL().get(0);
        Assert.assertEquals((Object)"update EMPLOYEE\nset SUPERIOR_ID = (select emp2.ID\nfrom EMPLOYEE emp2\nwhere emp2.ID = EMPLOYEE.ID)", (Object)sql.getSQL());
    }

    @Test
    public void testBeforeFiltersFlag() {
        KeyAccessorsTest.QEmployee emp1 = new KeyAccessorsTest.QEmployee("emp1");
        KeyAccessorsTest.QEmployee emp2 = new KeyAccessorsTest.QEmployee("emp2");
        SQLUpdateClause update = (SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)new SQLUpdateClause(null, SQLTemplates.DEFAULT, (RelationalPath)emp1).set(emp1.superiorId, emp2.id)).addFlag(QueryFlag.Position.BEFORE_FILTERS, String.format("\nfrom %s %s", new Object[]{emp2.getTableName(), emp2}))).where((Predicate)emp2.id.eq(emp1.id));
        SQLBindings sql = (SQLBindings)update.getSQL().get(0);
        Assert.assertEquals((Object)"update EMPLOYEE\nset SUPERIOR_ID = emp2.ID\nfrom EMPLOYEE emp2\nwhere emp2.ID = EMPLOYEE.ID", (Object)sql.getSQL());
        update = (SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)new SQLUpdateClause(null, SQLTemplates.DEFAULT, (RelationalPath)emp1).set(emp1.superiorId, emp2.id)).addFlag(QueryFlag.Position.BEFORE_FILTERS, " THE_FLAG")).where((Predicate)emp2.id.eq(emp1.id));
        sql = (SQLBindings)update.getSQL().get(0);
        Assert.assertEquals((Object)"update EMPLOYEE\nset SUPERIOR_ID = emp2.ID THE_FLAG\nwhere emp2.ID = EMPLOYEE.ID", (Object)sql.getSQL());
    }

    @Test
    public void clear() {
        KeyAccessorsTest.QEmployee emp1 = new KeyAccessorsTest.QEmployee("emp1");
        SQLUpdateClause update = new SQLUpdateClause(null, SQLTemplates.DEFAULT, (RelationalPath)emp1);
        update.set(emp1.id, (Object)1);
        update.addBatch();
        Assert.assertEquals((long)1L, (long)update.getBatchCount());
        update.clear();
        Assert.assertEquals((long)0L, (long)update.getBatchCount());
    }
}

