/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.mssql;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLServerTemplates;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.domain.QEmployee;
import com.querydsl.sql.domain.QSurvey;
import com.querydsl.sql.mssql.SQLServerQuery;
import com.querydsl.sql.mssql.SQLServerTableHints;
import org.junit.Assert;
import org.junit.Test;

public class SQLServerQueryTest {
    private static final QSurvey survey = QSurvey.survey;

    @Test
    public void tableHints_single() {
        SQLServerQuery query = new SQLServerQuery(null, (SQLTemplates)new SQLServerTemplates());
        ((SQLServerQuery)((SQLServerQuery)query.from((Expression)survey)).tableHints(new SQLServerTableHints[]{SQLServerTableHints.NOWAIT})).where((Predicate)SQLServerQueryTest.survey.name.isNull());
        Assert.assertEquals((Object)"from SURVEY SURVEY with (NOWAIT)\nwhere SURVEY.NAME is null", (Object)query.toString());
    }

    @Test
    public void tableHints_multiple() {
        SQLServerQuery query = new SQLServerQuery(null, (SQLTemplates)new SQLServerTemplates());
        ((SQLServerQuery)((SQLServerQuery)query.from((Expression)survey)).tableHints(new SQLServerTableHints[]{SQLServerTableHints.NOWAIT, SQLServerTableHints.NOLOCK})).where((Predicate)SQLServerQueryTest.survey.name.isNull());
        Assert.assertEquals((Object)"from SURVEY SURVEY with (NOWAIT, NOLOCK)\nwhere SURVEY.NAME is null", (Object)query.toString());
    }

    @Test
    public void tableHints_multiple2() {
        QSurvey survey2 = new QSurvey("survey2");
        SQLServerQuery query = new SQLServerQuery(null, (SQLTemplates)new SQLServerTemplates());
        ((SQLServerQuery)((SQLServerQuery)((SQLServerQuery)((SQLServerQuery)query.from((Expression)survey)).tableHints(new SQLServerTableHints[]{SQLServerTableHints.NOWAIT})).from((Expression)survey2)).tableHints(new SQLServerTableHints[]{SQLServerTableHints.NOLOCK})).where((Predicate)SQLServerQueryTest.survey.name.isNull());
        Assert.assertEquals((Object)"from SURVEY SURVEY with (NOWAIT), SURVEY survey2 with (NOLOCK)\nwhere SURVEY.NAME is null", (Object)query.toString());
    }

    @Test
    public void join_tableHints_single() {
        QEmployee employee1 = QEmployee.employee;
        QEmployee employee2 = new QEmployee("employee2");
        SQLServerQuery query = new SQLServerQuery(null, (SQLTemplates)new SQLServerTemplates());
        ((SQLServerQuery)((SQLServerQuery)((SQLServerQuery)((SQLServerQuery)query.from((Expression)employee1)).tableHints(new SQLServerTableHints[]{SQLServerTableHints.NOLOCK})).join((EntityPath)employee2)).tableHints(new SQLServerTableHints[]{SQLServerTableHints.NOLOCK})).on((Predicate)employee1.superiorId.eq(employee2.id));
        Assert.assertEquals((Object)"from EMPLOYEE EMPLOYEE with (NOLOCK)\njoin EMPLOYEE employee2 with (NOLOCK)\non EMPLOYEE.SUPERIOR_ID = employee2.ID", (Object)query.toString());
    }

    @Test
    public void join_tableHints_multiple() {
        QEmployee employee1 = QEmployee.employee;
        QEmployee employee2 = new QEmployee("employee2");
        SQLServerQuery query = new SQLServerQuery(null, (SQLTemplates)new SQLServerTemplates());
        ((SQLServerQuery)((SQLServerQuery)((SQLServerQuery)((SQLServerQuery)query.from((Expression)employee1)).tableHints(new SQLServerTableHints[]{SQLServerTableHints.NOLOCK, SQLServerTableHints.READUNCOMMITTED})).join((EntityPath)employee2)).tableHints(new SQLServerTableHints[]{SQLServerTableHints.NOLOCK, SQLServerTableHints.READUNCOMMITTED})).on((Predicate)employee1.superiorId.eq(employee2.id));
        Assert.assertEquals((Object)"from EMPLOYEE EMPLOYEE with (NOLOCK, READUNCOMMITTED)\njoin EMPLOYEE employee2 with (NOLOCK, READUNCOMMITTED)\non EMPLOYEE.SUPERIOR_ID = employee2.ID", (Object)query.toString());
    }
}

