/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.mssql;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.dsl.ComparableExpressionBase;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.Constants;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLSerializer;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.WindowFunction;
import org.junit.Assert;
import org.junit.Test;

public class WindowFunctionTest {
    private static final Configuration configuration = new Configuration(SQLTemplates.DEFAULT);

    private static String toString(Expression<?> e) {
        return ((SQLSerializer)new SQLSerializer(configuration).handle(e)).toString();
    }

    @Test
    public void mutable() {
        WindowFunction rn = SQLExpressions.rowNumber().over().orderBy((ComparableExpressionBase)Constants.employee.firstname);
        Assert.assertEquals((Object)"row_number() over (order by e.FIRSTNAME asc)", (Object)WindowFunctionTest.toString(rn));
        Assert.assertEquals((Object)"row_number() over (order by e.FIRSTNAME asc, e.LASTNAME asc)", (Object)WindowFunctionTest.toString(rn.orderBy((ComparableExpressionBase)Constants.employee.lastname)));
    }

    @Test
    public void orderBy() {
        Assert.assertEquals((Object)"row_number() over (order by e.FIRSTNAME asc)", (Object)WindowFunctionTest.toString(SQLExpressions.rowNumber().over().orderBy(Constants.employee.firstname.asc())));
        Assert.assertEquals((Object)"row_number() over (order by e.FIRSTNAME asc)", (Object)WindowFunctionTest.toString(SQLExpressions.rowNumber().over().orderBy((ComparableExpressionBase)Constants.employee.firstname)));
        Assert.assertEquals((Object)"row_number() over (order by e.FIRSTNAME asc) as rn", (Object)WindowFunctionTest.toString(SQLExpressions.rowNumber().over().orderBy(Constants.employee.firstname.asc()).as("rn")));
        Assert.assertEquals((Object)"row_number() over (order by e.FIRSTNAME desc)", (Object)WindowFunctionTest.toString(SQLExpressions.rowNumber().over().orderBy(Constants.employee.firstname.desc())));
    }

    @Test
    public void partitionBy() {
        Assert.assertEquals((Object)"row_number() over (partition by e.LASTNAME order by e.FIRSTNAME asc)", (Object)WindowFunctionTest.toString(SQLExpressions.rowNumber().over().partitionBy((Expression)Constants.employee.lastname).orderBy(Constants.employee.firstname.asc())));
        Assert.assertEquals((Object)"row_number() over (partition by e.LASTNAME, e.FIRSTNAME order by e.FIRSTNAME asc)", (Object)WindowFunctionTest.toString(SQLExpressions.rowNumber().over().partitionBy(new Expression[]{Constants.employee.lastname, Constants.employee.firstname}).orderBy(Constants.employee.firstname.asc())));
    }
}

